/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration.model;

import io.ebean.annotation.IdentityGenerated;
import io.ebean.config.dbplatform.IdType;
import io.ebeaninternal.dbmigration.migration.CreateTable;
import io.ebeaninternal.dbmigration.migration.IdentityType;
import io.ebeaninternal.server.deploy.IdentityMode;
import java.math.BigInteger;

public class MTableIdentity {
    public static IdentityMode fromCreateTable(CreateTable createTable) {
        IdType type = MTableIdentity.fromType(createTable.getIdentityType());
        IdentityGenerated generated = MTableIdentity.fromGenerated(createTable.getIdentityGenerated());
        int start = MTableIdentity.toInt(createTable.getIdentityStart(), createTable.getSequenceInitial());
        int increment = MTableIdentity.toInt(createTable.getIdentityIncrement(), createTable.getSequenceAllocate());
        int cache = MTableIdentity.toInt(createTable.getIdentityCache(), null);
        String seqName = createTable.getSequenceName();
        return new IdentityMode(type, generated, start, increment, cache, seqName);
    }

    private static IdentityGenerated fromGenerated(String identityGenerated) {
        if (identityGenerated == null) {
            return IdentityGenerated.AUTO;
        }
        return IdentityGenerated.valueOf(identityGenerated.toUpperCase());
    }

    public static void toCreateTable(IdentityMode identityMode, CreateTable createTable) {
        String seqName;
        if (!identityMode.isPlatformDefault()) {
            createTable.setIdentityType(MTableIdentity.toType(identityMode.getIdType()));
        }
        if ((seqName = identityMode.getSequenceName()) != null && !seqName.isEmpty()) {
            createTable.setSequenceName(seqName);
        }
        createTable.setIdentityStart(MTableIdentity.toBigInteger(identityMode.getStart()));
        createTable.setIdentityIncrement(MTableIdentity.toBigInteger(identityMode.getIncrement()));
        createTable.setIdentityCache(MTableIdentity.toBigInteger(identityMode.getCache()));
        IdentityGenerated generated = identityMode.getGenerated();
        if (generated != null && generated != IdentityGenerated.AUTO) {
            createTable.setIdentityGenerated(generated.name().toLowerCase());
        }
    }

    private static IdType fromType(IdentityType type) {
        if (type == null) {
            return IdType.AUTO;
        }
        switch (type) {
            case DEFAULT: {
                return IdType.AUTO;
            }
            case SEQUENCE: {
                return IdType.SEQUENCE;
            }
            case IDENTITY: {
                return IdType.IDENTITY;
            }
            case GENERATOR: {
                return IdType.GENERATOR;
            }
            case EXTERNAL: {
                return IdType.EXTERNAL;
            }
        }
        return IdType.AUTO;
    }

    private static IdentityType toType(IdType type) {
        if (type == null) {
            return null;
        }
        switch (type) {
            case SEQUENCE: {
                return IdentityType.SEQUENCE;
            }
            case IDENTITY: {
                return IdentityType.IDENTITY;
            }
            case EXTERNAL: {
                return IdentityType.EXTERNAL;
            }
            case GENERATOR: {
                return IdentityType.GENERATOR;
            }
        }
        return null;
    }

    private static int toInt(BigInteger firstVal, BigInteger secVal) {
        if (firstVal != null) {
            return firstVal.intValue();
        }
        return secVal == null ? 0 : secVal.intValue();
    }

    private static BigInteger toBigInteger(int value) {
        return value == 0 ? null : BigInteger.valueOf(value);
    }
}

