/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration.ddlgeneration.platform;

import io.ebeaninternal.dbmigration.ddlgeneration.DdlBuffer;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlWrite;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.DbTriggerBasedHistoryDdl;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.DbTriggerUpdate;
import io.ebeaninternal.dbmigration.model.MTable;
import java.io.IOException;

public class MySqlHistoryDdl
extends DbTriggerBasedHistoryDdl {
    MySqlHistoryDdl() {
    }

    @Override
    protected void dropTriggers(DdlBuffer buffer, String baseTable) throws IOException {
        buffer.append("drop trigger ").append(this.updateTriggerName(baseTable)).endOfStatement();
        buffer.append("drop trigger ").append(this.deleteTriggerName(baseTable)).endOfStatement();
    }

    @Override
    protected void createTriggers(DdlWrite writer, MTable table) throws IOException {
        DbTriggerUpdate update = this.createDbTriggerUpdate(writer, table);
        this.addBeforeUpdate(this.updateTriggerName(update.getBaseTable()), update);
        this.addBeforeDelete(this.deleteTriggerName(update.getBaseTable()), update);
    }

    @Override
    protected void updateHistoryTriggers(DbTriggerUpdate update) throws IOException {
        this.recreateHistoryView(update);
        DdlBuffer buffer = update.historyTriggerBuffer();
        String baseTable = update.getBaseTable();
        this.dropTriggers(buffer, baseTable);
        this.addBeforeUpdate(this.updateTriggerName(baseTable), update);
        this.addBeforeDelete(this.deleteTriggerName(baseTable), update);
    }

    private void addBeforeUpdate(String triggerName, DbTriggerUpdate update) throws IOException {
        DdlBuffer apply = update.historyTriggerBuffer();
        apply.append("delimiter $$").newLine().append("create trigger ").append(triggerName).append(" before update on ").append(update.getBaseTable()).append(" for each row begin").newLine();
        this.appendInsertIntoHistory(apply, update.getHistoryTable(), update.getColumns());
        apply.append("    set NEW.").append(this.sysPeriod).append("_start = now(6)").endOfStatement().append("end$$").newLine();
    }

    private void addBeforeDelete(String triggerName, DbTriggerUpdate update) throws IOException {
        DdlBuffer apply = update.historyTriggerBuffer();
        apply.append("delimiter $$").newLine().append("create trigger ").append(triggerName).append(" before delete on ").append(update.getBaseTable()).append(" for each row begin").newLine();
        this.appendInsertIntoHistory(apply, update.getHistoryTable(), update.getColumns());
        apply.append("end$$").newLine();
    }
}

