/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration.ddlgeneration.platform;

import io.ebean.annotation.Platform;
import io.ebean.config.DatabaseConfig;
import io.ebean.config.DbConstraintNaming;
import io.ebean.config.NamingConvention;
import io.ebean.config.dbplatform.DbHistorySupport;
import io.ebean.config.dbplatform.IdType;
import io.ebean.util.StringHelper;
import io.ebeaninternal.api.PlatformMatch;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlBuffer;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlOptions;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlWrite;
import io.ebeaninternal.dbmigration.ddlgeneration.TableDdl;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.DdlHelp;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.DdlIdentity;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.HistoryTableUpdate;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.PlatformDdl;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.SplitColumns;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.WriteCreateIndex;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.WriteForeignKey;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.WriteUniqueConstraint;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.util.IndexSet;
import io.ebeaninternal.dbmigration.migration.AddColumn;
import io.ebeaninternal.dbmigration.migration.AddHistoryTable;
import io.ebeaninternal.dbmigration.migration.AddTableComment;
import io.ebeaninternal.dbmigration.migration.AddUniqueConstraint;
import io.ebeaninternal.dbmigration.migration.AlterColumn;
import io.ebeaninternal.dbmigration.migration.AlterForeignKey;
import io.ebeaninternal.dbmigration.migration.Column;
import io.ebeaninternal.dbmigration.migration.CreateIndex;
import io.ebeaninternal.dbmigration.migration.CreateTable;
import io.ebeaninternal.dbmigration.migration.DdlScript;
import io.ebeaninternal.dbmigration.migration.DropColumn;
import io.ebeaninternal.dbmigration.migration.DropHistoryTable;
import io.ebeaninternal.dbmigration.migration.DropIndex;
import io.ebeaninternal.dbmigration.migration.DropTable;
import io.ebeaninternal.dbmigration.migration.ForeignKey;
import io.ebeaninternal.dbmigration.migration.UniqueConstraint;
import io.ebeaninternal.dbmigration.model.MTable;
import io.ebeaninternal.dbmigration.model.MTableIdentity;
import io.ebeaninternal.server.deploy.IdentityMode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class BaseTableDdl
implements TableDdl {
    protected final DbConstraintNaming naming;
    protected final NamingConvention namingConvention;
    protected final PlatformDdl platformDdl;
    protected final String historyTableSuffix;
    protected final IndexSet indexSet = new IndexSet();
    protected final List<Column> externalUnique = new ArrayList<Column>();
    protected final List<UniqueConstraint> externalCompoundUnique = new ArrayList<UniqueConstraint>();
    protected int countCheck;
    protected int countUnique;
    protected int countForeignKey;
    protected int countIndex;
    protected final Map<String, HistoryTableUpdate> regenerateHistoryTriggers = new LinkedHashMap<String, HistoryTableUpdate>();
    private final boolean strictMode;
    private final HistorySupport historySupport;

    public BaseTableDdl(DatabaseConfig config, PlatformDdl platformDdl) {
        this.namingConvention = config.getNamingConvention();
        this.naming = config.getConstraintNaming();
        this.historyTableSuffix = config.getHistoryTableSuffix();
        this.platformDdl = platformDdl;
        this.platformDdl.configure(config);
        this.strictMode = config.isDdlStrictMode();
        DbHistorySupport hist = platformDdl.getPlatform().getHistorySupport();
        this.historySupport = hist == null ? HistorySupport.NONE : (hist.isStandardsBased() ? HistorySupport.SQL2011 : HistorySupport.TRIGGER_BASED);
    }

    protected void reset() {
        this.indexSet.clear();
        this.externalUnique.clear();
        this.externalCompoundUnique.clear();
        this.countCheck = 0;
        this.countUnique = 0;
        this.countForeignKey = 0;
        this.countIndex = 0;
    }

    @Override
    public void generate(DdlWrite writer, CreateTable createTable) throws IOException {
        this.reset();
        String tableName = this.lowerTableName(createTable.getName());
        List<Column> columns = createTable.getColumn();
        List<Column> pk = this.determinePrimaryKeyColumns(columns);
        DdlIdentity identity = DdlIdentity.NONE;
        if (pk.size() == 1) {
            IdentityMode identityMode = MTableIdentity.fromCreateTable(createTable);
            IdType idType = this.platformDdl.useIdentityType(identityMode.getIdType());
            String sequenceName = identityMode.getSequenceName();
            if (IdType.SEQUENCE == idType && (sequenceName == null || sequenceName.isEmpty())) {
                sequenceName = this.sequenceName(createTable, pk);
            }
            identity = new DdlIdentity(idType, identityMode, sequenceName);
        }
        String partitionMode = createTable.getPartitionMode();
        DdlBuffer apply = writer.apply();
        apply.append(this.platformDdl.getCreateTableCommandPrefix()).append(" ").append(tableName).append(" (");
        this.writeTableColumns(apply, columns, identity);
        this.writeUniqueConstraints(apply, createTable);
        this.writeCompoundUniqueConstraints(apply, createTable);
        if (!(pk.isEmpty() || partitionMode != null && this.platformDdl.suppressPrimaryKeyOnPartition())) {
            this.writePrimaryKeyConstraint(apply, createTable.getPkName(), this.toColumnNames(pk));
        }
        if (this.platformDdl.isInlineForeignKeys()) {
            this.writeInlineForeignKeys(writer, createTable);
        }
        apply.newLine().append(")");
        this.addTableStorageEngine(apply, createTable);
        this.addTableCommentInline(apply, createTable);
        if (partitionMode != null) {
            this.platformDdl.addTablePartition(apply, partitionMode, createTable.getPartitionColumn());
        }
        apply.endOfStatement();
        this.addComments(apply, createTable);
        this.writeUniqueOneToOneConstraints(writer, createTable);
        if (this.isTrue(createTable.isWithHistory())) {
            this.createWithHistory(writer, createTable.getName());
        }
        this.dropTable(writer.dropAll(), tableName);
        if (identity.useSequence()) {
            this.writeSequence(writer, identity);
        }
        apply.end();
        writer.dropAll().end();
        if (!this.platformDdl.isInlineForeignKeys()) {
            this.writeAddForeignKeys(writer, createTable);
        }
    }

    private String sequenceName(CreateTable createTable, List<Column> pk) {
        return this.namingConvention.getSequenceName(createTable.getName(), pk.get(0).getName());
    }

    private void addComments(DdlBuffer apply, CreateTable createTable) throws IOException {
        if (!this.platformDdl.isInlineComments()) {
            String tableComment = createTable.getComment();
            if (this.hasValue(tableComment)) {
                this.platformDdl.addTableComment(apply, createTable.getName(), tableComment);
            }
            for (Column column : createTable.getColumn()) {
                if (StringHelper.isNull(column.getComment())) continue;
                this.platformDdl.addColumnComment(apply, createTable.getName(), column.getName(), column.getComment());
            }
        }
    }

    private void addTableStorageEngine(DdlBuffer apply, CreateTable createTable) throws IOException {
        if (this.platformDdl.isIncludeStorageEngine()) {
            this.platformDdl.tableStorageEngine(apply, createTable.getStorageEngine());
        }
    }

    private void addTableCommentInline(DdlBuffer apply, CreateTable createTable) throws IOException {
        String tableComment;
        if (this.platformDdl.isInlineComments() && !StringHelper.isNull(tableComment = createTable.getComment())) {
            this.platformDdl.inlineTableComment(apply, tableComment);
        }
    }

    private void writeTableColumns(DdlBuffer apply, List<Column> columns, DdlIdentity identity) throws IOException {
        this.platformDdl.writeTableColumns(apply, columns, identity);
    }

    protected void writeUniqueOneToOneConstraints(DdlWrite write, CreateTable createTable) throws IOException {
        String[] columnNames;
        String uqName;
        String tableName = createTable.getName();
        for (Column col : this.externalUnique) {
            uqName = col.getUniqueOneToOne();
            if (uqName == null) {
                uqName = col.getUnique();
            }
            columnNames = new String[]{col.getName()};
            write.apply().appendStatement(this.platformDdl.alterTableAddUniqueConstraint(tableName, uqName, columnNames, Boolean.TRUE.equals(col.isNotnull()) ? null : columnNames));
            write.dropAllForeignKeys().appendStatement(this.platformDdl.dropIndex(uqName, tableName));
        }
        for (UniqueConstraint constraint : this.externalCompoundUnique) {
            uqName = constraint.getName();
            columnNames = SplitColumns.split(constraint.getColumnNames());
            String[] nullableColumns = SplitColumns.split(constraint.getNullableColumns());
            write.apply().appendStatement(this.platformDdl.alterTableAddUniqueConstraint(tableName, uqName, columnNames, nullableColumns));
            write.dropAllForeignKeys().appendStatement(this.platformDdl.dropIndex(uqName, tableName));
        }
    }

    protected void writeSequence(DdlWrite writer, DdlIdentity identity) throws IOException {
        String seqName = identity.getSequenceName();
        String createSeq = this.platformDdl.createSequence(seqName, identity);
        if (this.hasValue(createSeq)) {
            writer.apply().append(createSeq).newLine();
            writer.dropAll().appendStatement(this.platformDdl.dropSequence(seqName));
        }
    }

    protected void createWithHistory(DdlWrite writer, String name) throws IOException {
        MTable table = writer.getTable(name);
        this.platformDdl.createWithHistory(writer, table);
    }

    protected void writeInlineForeignKeys(DdlWrite write, CreateTable createTable) throws IOException {
        for (Column column : createTable.getColumn()) {
            String references = column.getReferences();
            if (!this.hasValue(references)) continue;
            this.writeInlineForeignKey(write, column);
        }
        this.writeInlineCompoundForeignKeys(write, createTable);
    }

    protected void writeInlineForeignKey(DdlWrite write, Column column) throws IOException {
        String fkConstraint = this.platformDdl.tableInlineForeignKey(new WriteForeignKey(null, column));
        write.apply().append(",").newLine().append("  ").append(fkConstraint);
    }

    protected void writeInlineCompoundForeignKeys(DdlWrite write, CreateTable createTable) throws IOException {
        for (ForeignKey key : createTable.getForeignKey()) {
            String fkConstraint = this.platformDdl.tableInlineForeignKey(new WriteForeignKey(null, key));
            write.apply().append(",").newLine().append("  ").append(fkConstraint);
        }
    }

    protected void writeAddForeignKeys(DdlWrite write, CreateTable createTable) throws IOException {
        for (Column column : createTable.getColumn()) {
            String references = column.getReferences();
            if (!this.hasValue(references)) continue;
            this.writeForeignKey(write, createTable.getName(), column);
        }
        this.writeAddCompoundForeignKeys(write, createTable);
    }

    protected void writeAddCompoundForeignKeys(DdlWrite write, CreateTable createTable) throws IOException {
        for (ForeignKey key : createTable.getForeignKey()) {
            this.writeForeignKey(write, new WriteForeignKey(createTable.getName(), key));
        }
    }

    protected void writeForeignKey(DdlWrite write, String tableName, Column column) throws IOException {
        this.writeForeignKey(write, new WriteForeignKey(tableName, column));
    }

    protected void writeForeignKey(DdlWrite write, WriteForeignKey request) throws IOException {
        DdlBuffer fkeyBuffer = write.applyForeignKeys();
        String tableName = this.lowerTableName(request.table());
        if (request.indexName() != null) {
            fkeyBuffer.appendStatement(this.platformDdl.createIndex(new WriteCreateIndex(request.indexName(), tableName, request.cols(), false)));
        }
        this.alterTableAddForeignKey(write.getOptions(), fkeyBuffer, request);
        fkeyBuffer.end();
        write.dropAllForeignKeys().appendStatement(this.platformDdl.alterTableDropForeignKey(tableName, request.fkName()));
        if (this.hasValue(request.indexName())) {
            write.dropAllForeignKeys().appendStatement(this.platformDdl.dropIndex(request.indexName(), tableName));
        }
        write.dropAllForeignKeys().end();
    }

    protected void alterTableAddForeignKey(DdlOptions options, DdlBuffer buffer, WriteForeignKey request) throws IOException {
        buffer.appendStatement(this.platformDdl.alterTableAddForeignKey(options, request));
    }

    protected void appendColumns(String[] columns, DdlBuffer buffer) throws IOException {
        buffer.append(" (");
        for (int i = 0; i < columns.length; ++i) {
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append(this.lowerColumnName(columns[i].trim()));
        }
        buffer.append(")");
    }

    protected void dropTable(DdlBuffer buffer, String tableName) throws IOException {
        buffer.appendStatement(this.platformDdl.dropTable(tableName));
    }

    protected void dropSequence(DdlBuffer buffer, String sequenceName) throws IOException {
        buffer.appendStatement(this.platformDdl.dropSequence(sequenceName));
    }

    protected void writeCompoundUniqueConstraints(DdlBuffer apply, CreateTable createTable) throws IOException {
        boolean inlineUniqueWhenNull = this.platformDdl.isInlineUniqueWhenNullable();
        for (UniqueConstraint uniqueConstraint : createTable.getUniqueConstraint()) {
            if (!this.platformInclude(uniqueConstraint.getPlatforms())) continue;
            if (inlineUniqueWhenNull) {
                String uqName = uniqueConstraint.getName();
                apply.append(",").newLine();
                apply.append("  constraint ").append(uqName).append(" unique");
                this.appendColumns(SplitColumns.split(uniqueConstraint.getColumnNames()), apply);
                continue;
            }
            this.externalCompoundUnique.add(uniqueConstraint);
        }
    }

    private boolean platformInclude(String platforms) {
        return PlatformMatch.matchPlatform(this.platformDdl.getPlatform().getPlatform(), platforms);
    }

    protected void writeUniqueConstraints(DdlBuffer apply, CreateTable createTable) throws IOException {
        boolean inlineUniqueWhenNullable = this.platformDdl.isInlineUniqueWhenNullable();
        List<Column> columns = new WriteUniqueConstraint(createTable.getColumn()).uniqueKeys();
        for (Column column : columns) {
            if (Boolean.TRUE.equals(column.isNotnull()) || inlineUniqueWhenNullable) {
                this.inlineUniqueConstraintSingle(apply, column);
                continue;
            }
            this.externalUnique.add(column);
        }
    }

    protected void inlineUniqueConstraintSingle(DdlBuffer buffer, Column column) throws IOException {
        String uqName = column.getUnique();
        if (uqName == null) {
            uqName = column.getUniqueOneToOne();
        }
        buffer.append(",").newLine();
        buffer.append("  constraint ").append(uqName).append(" unique ");
        buffer.append("(");
        buffer.append(this.lowerColumnName(column.getName()));
        buffer.append(")");
    }

    protected void writePrimaryKeyConstraint(DdlBuffer buffer, String pkName, String[] pkColumns) throws IOException {
        buffer.append(",").newLine();
        buffer.append("  constraint ").append(pkName).append(" primary key");
        this.appendColumns(pkColumns, buffer);
    }

    protected String[] toColumnNames(List<Column> columns) {
        String[] cols = new String[columns.size()];
        for (int i = 0; i < cols.length; ++i) {
            cols[i] = columns.get(i).getName();
        }
        return cols;
    }

    protected String lowerTableName(String name) {
        return this.naming.lowerTableName(name);
    }

    protected String lowerColumnName(String name) {
        return this.naming.lowerColumnName(name);
    }

    protected List<Column> determinePrimaryKeyColumns(List<Column> columns) {
        ArrayList<Column> pk = new ArrayList<Column>(3);
        for (Column column : columns) {
            if (!this.isTrue(column.isPrimaryKey())) continue;
            pk.add(column);
        }
        return pk;
    }

    @Override
    public void generate(DdlWrite writer, CreateIndex index) throws IOException {
        if (this.platformInclude(index.getPlatforms())) {
            writer.apply().appendStatement(this.platformDdl.createIndex(new WriteCreateIndex(index)));
            writer.dropAll().appendStatement(this.platformDdl.dropIndex(index.getIndexName(), index.getTableName(), Boolean.TRUE.equals(index.isConcurrent())));
        }
    }

    @Override
    public void generate(DdlWrite writer, DropIndex dropIndex) throws IOException {
        if (this.platformInclude(dropIndex.getPlatforms())) {
            writer.apply().appendStatement(this.platformDdl.dropIndex(dropIndex.getIndexName(), dropIndex.getTableName(), Boolean.TRUE.equals(dropIndex.isConcurrent())));
        }
    }

    @Override
    public void generate(DdlWrite writer, AddUniqueConstraint constraint) throws IOException {
        if (this.platformInclude(constraint.getPlatforms())) {
            if (DdlHelp.isDropConstraint(constraint.getColumnNames())) {
                writer.apply().appendStatement(this.platformDdl.alterTableDropUniqueConstraint(constraint.getTableName(), constraint.getConstraintName()));
            } else {
                String[] cols = SplitColumns.split(constraint.getColumnNames());
                String[] nullableColumns = SplitColumns.split(constraint.getNullableColumns());
                writer.apply().appendStatement(this.platformDdl.alterTableAddUniqueConstraint(constraint.getTableName(), constraint.getConstraintName(), cols, nullableColumns));
            }
        }
    }

    @Override
    public void generate(DdlWrite writer, AlterForeignKey alterForeignKey) throws IOException {
        if (DdlHelp.isDropForeignKey(alterForeignKey.getColumnNames())) {
            writer.apply().appendStatement(this.platformDdl.alterTableDropForeignKey(alterForeignKey.getTableName(), alterForeignKey.getName()));
        } else {
            writer.apply().appendStatement(this.platformDdl.alterTableAddForeignKey(writer.getOptions(), new WriteForeignKey(alterForeignKey)));
        }
    }

    @Override
    public void generate(DdlWrite writer, AddHistoryTable addHistoryTable) throws IOException {
        this.platformDdl.addHistoryTable(writer, addHistoryTable);
    }

    @Override
    public void generate(DdlWrite writer, DropHistoryTable dropHistoryTable) throws IOException {
        this.platformDdl.dropHistoryTable(writer, dropHistoryTable);
    }

    @Override
    public void generateProlog(DdlWrite write) throws IOException {
        this.platformDdl.generateProlog(write);
    }

    @Override
    public void generateEpilog(DdlWrite write) throws IOException {
        if (!this.regenerateHistoryTriggers.isEmpty()) {
            this.platformDdl.lockTables(write.applyHistoryTrigger(), this.regenerateHistoryTriggers.keySet());
            for (HistoryTableUpdate update : this.regenerateHistoryTriggers.values()) {
                this.platformDdl.regenerateHistoryTriggers(write, update);
            }
            this.platformDdl.unlockTables(write.applyHistoryTrigger(), this.regenerateHistoryTriggers.keySet());
        }
        this.platformDdl.generateEpilog(write);
    }

    @Override
    public void generate(DdlWrite writer, AddTableComment addTableComment) throws IOException {
        if (this.hasValue(addTableComment.getComment())) {
            this.platformDdl.addTableComment(writer.apply(), addTableComment.getName(), addTableComment.getComment());
        }
    }

    @Override
    public void generate(DdlWrite writer, AddColumn addColumn) throws IOException {
        String tableName = addColumn.getTableName();
        List<Column> columns = addColumn.getColumn();
        for (Column column : columns) {
            this.alterTableAddColumn(writer.apply(), tableName, column, false, this.isTrue(addColumn.isWithHistory()));
        }
        if (this.isTrue(addColumn.isWithHistory()) && this.historySupport == HistorySupport.TRIGGER_BASED) {
            String historyTable = this.historyTable(tableName);
            for (Column column : columns) {
                this.regenerateHistoryTriggers(tableName, HistoryTableUpdate.Change.ADD, column.getName());
                this.alterTableAddColumn(writer.apply(), historyTable, column, true, true);
            }
        }
        for (Column column : columns) {
            if (!this.hasValue(column.getReferences())) continue;
            this.writeForeignKey(writer, tableName, column);
        }
        writer.apply().end();
    }

    @Override
    public void generate(DdlWrite writer, DropTable dropTable) throws IOException {
        this.dropTable(writer.apply(), dropTable.getName());
        if (this.hasValue(dropTable.getSequenceCol()) && this.platformDdl.getPlatform().getDbIdentity().isSupportsSequence()) {
            String sequenceName = dropTable.getSequenceName();
            if (!this.hasValue(sequenceName)) {
                sequenceName = this.namingConvention.getSequenceName(dropTable.getName(), dropTable.getSequenceCol());
            }
            this.dropSequence(writer.apply(), sequenceName);
        }
    }

    @Override
    public void generate(DdlWrite writer, DropColumn dropColumn) throws IOException {
        String tableName = dropColumn.getTableName();
        this.alterTableDropColumn(writer.apply(), tableName, dropColumn.getColumnName());
        if (this.isTrue(dropColumn.isWithHistory()) && this.historySupport == HistorySupport.TRIGGER_BASED) {
            this.regenerateHistoryTriggers(tableName, HistoryTableUpdate.Change.DROP, dropColumn.getColumnName());
            this.alterTableDropColumn(writer.apply(), this.historyTable(tableName), dropColumn.getColumnName());
        }
        writer.apply().end();
    }

    @Override
    public void generate(DdlWrite writer, AlterColumn alterColumn) throws IOException {
        boolean alterCheckConstraint;
        DdlMigrationHelp ddlHelp = new DdlMigrationHelp(alterColumn);
        ddlHelp.writeBefore(writer.apply());
        if (this.isTrue(alterColumn.isHistoryExclude())) {
            this.regenerateHistoryTriggers(alterColumn.getTableName(), HistoryTableUpdate.Change.EXCLUDE, alterColumn.getColumnName());
        } else if (this.isFalse(alterColumn.isHistoryExclude())) {
            this.regenerateHistoryTriggers(alterColumn.getTableName(), HistoryTableUpdate.Change.INCLUDE, alterColumn.getColumnName());
        }
        if (this.hasValue(alterColumn.getDropForeignKey())) {
            this.alterColumnDropForeignKey(writer, alterColumn);
        }
        if (this.hasValue(alterColumn.getReferences())) {
            this.alterColumnAddForeignKey(writer, alterColumn);
        }
        if (this.hasValue(alterColumn.getDropUnique())) {
            this.alterColumnDropUniqueConstraint(writer, alterColumn);
        }
        if (this.hasValue(alterColumn.getUnique())) {
            this.alterColumnAddUniqueConstraint(writer, alterColumn);
        }
        if (this.hasValue(alterColumn.getUniqueOneToOne())) {
            this.alterColumnAddUniqueOneToOneConstraint(writer, alterColumn);
        }
        if (this.hasValue(alterColumn.getComment())) {
            this.alterColumnComment(writer, alterColumn);
        }
        if (this.hasValue(alterColumn.getDropCheckConstraint())) {
            this.dropCheckConstraint(writer, alterColumn, alterColumn.getDropCheckConstraint());
        }
        if (alterCheckConstraint = this.hasValue(alterColumn.getCheckConstraint())) {
            this.dropCheckConstraint(writer, alterColumn, alterColumn.getCheckConstraintName());
        }
        boolean alterBaseAttributes = false;
        if (this.hasValue(alterColumn.getType())) {
            this.alterColumnType(writer, alterColumn);
            alterBaseAttributes = true;
        }
        if (this.hasValue(alterColumn.getDefaultValue())) {
            this.alterColumnDefaultValue(writer, alterColumn);
            alterBaseAttributes = true;
        }
        if (alterColumn.isNotnull() != null) {
            this.alterColumnNotnull(writer, alterColumn);
            alterBaseAttributes = true;
        }
        if (alterBaseAttributes) {
            this.alterColumnBaseAttributes(writer, alterColumn);
        }
        if (alterCheckConstraint) {
            this.addCheckConstraint(writer, alterColumn);
        }
        ddlHelp.writeAfter(writer.apply());
    }

    private void alterColumnComment(DdlWrite writer, AlterColumn alterColumn) throws IOException {
        this.platformDdl.addColumnComment(writer.apply(), alterColumn.getTableName(), alterColumn.getColumnName(), alterColumn.getComment());
    }

    protected String historyTable(String baseTable) {
        return baseTable + this.historyTableSuffix;
    }

    protected void regenerateHistoryTriggers(String baseTableName, HistoryTableUpdate.Change change, String column) {
        HistoryTableUpdate update = this.regenerateHistoryTriggers.computeIfAbsent(baseTableName, HistoryTableUpdate::new);
        update.add(change, column);
    }

    protected void alterColumnBaseAttributes(DdlWrite writer, AlterColumn alter) throws IOException {
        String ddl = this.platformDdl.alterColumnBaseAttributes(alter);
        if (this.hasValue(ddl)) {
            writer.apply().appendStatement(ddl);
            if (this.isTrue(alter.isWithHistory()) && alter.getType() != null && this.historySupport == HistorySupport.TRIGGER_BASED) {
                this.regenerateHistoryTriggers(alter.getTableName(), HistoryTableUpdate.Change.ALTER, alter.getColumnName());
                AlterColumn alterHistoryColumn = new AlterColumn();
                alterHistoryColumn.setTableName(this.historyTable(alter.getTableName()));
                alterHistoryColumn.setColumnName(alter.getColumnName());
                alterHistoryColumn.setType(alter.getType());
                String histColumnDdl = this.platformDdl.alterColumnBaseAttributes(alterHistoryColumn);
                writer.apply().appendStatement(histColumnDdl);
            }
        }
    }

    protected void alterColumnDefaultValue(DdlWrite writer, AlterColumn alter) throws IOException {
        writer.apply().appendStatement(this.platformDdl.alterColumnDefaultValue(alter.getTableName(), alter.getColumnName(), alter.getDefaultValue()));
    }

    protected void dropCheckConstraint(DdlWrite writer, AlterColumn alter, String constraintName) throws IOException {
        writer.apply().appendStatement(this.platformDdl.alterTableDropConstraint(alter.getTableName(), constraintName));
    }

    protected void addCheckConstraint(DdlWrite writer, AlterColumn alter) throws IOException {
        writer.apply().appendStatement(this.platformDdl.alterTableAddCheckConstraint(alter.getTableName(), alter.getCheckConstraintName(), alter.getCheckConstraint()));
    }

    protected void alterColumnNotnull(DdlWrite writer, AlterColumn alter) throws IOException {
        writer.apply().appendStatement(this.platformDdl.alterColumnNotnull(alter.getTableName(), alter.getColumnName(), alter.isNotnull()));
    }

    protected void alterColumnType(DdlWrite writer, AlterColumn alter) throws IOException {
        String ddl = this.platformDdl.alterColumnType(alter.getTableName(), alter.getColumnName(), alter.getType());
        if (this.hasValue(ddl)) {
            writer.apply().appendStatement(ddl);
            if (this.isTrue(alter.isWithHistory()) && this.historySupport == HistorySupport.TRIGGER_BASED) {
                this.regenerateHistoryTriggers(alter.getTableName(), HistoryTableUpdate.Change.ALTER, alter.getColumnName());
                ddl = this.platformDdl.alterColumnType(this.historyTable(alter.getTableName()), alter.getColumnName(), alter.getType());
                writer.apply().appendStatement(ddl);
            }
        }
    }

    protected void alterColumnAddForeignKey(DdlWrite writer, AlterColumn alterColumn) throws IOException {
        this.alterTableAddForeignKey(writer.getOptions(), writer.apply(), new WriteForeignKey(alterColumn));
    }

    protected void alterColumnDropForeignKey(DdlWrite writer, AlterColumn alter) throws IOException {
        writer.apply().appendStatement(this.platformDdl.alterTableDropForeignKey(alter.getTableName(), alter.getDropForeignKey()));
    }

    protected void alterColumnDropUniqueConstraint(DdlWrite writer, AlterColumn alter) throws IOException {
        writer.apply().appendStatement(this.platformDdl.alterTableDropUniqueConstraint(alter.getTableName(), alter.getDropUnique()));
    }

    protected void alterColumnAddUniqueOneToOneConstraint(DdlWrite writer, AlterColumn alter) throws IOException {
        this.addUniqueConstraint(writer, alter, alter.getUniqueOneToOne());
    }

    protected void alterColumnAddUniqueConstraint(DdlWrite writer, AlterColumn alter) throws IOException {
        this.addUniqueConstraint(writer, alter, alter.getUnique());
    }

    protected void addUniqueConstraint(DdlWrite writer, AlterColumn alter, String uqName) throws IOException {
        String[] cols = new String[]{alter.getColumnName()};
        boolean notNull = alter.isNotnull() != null ? alter.isNotnull().booleanValue() : Boolean.TRUE.equals(alter.isNotnull());
        writer.apply().appendStatement(this.platformDdl.alterTableAddUniqueConstraint(alter.getTableName(), uqName, cols, notNull ? null : cols));
        writer.dropAllForeignKeys().appendStatement(this.platformDdl.dropIndex(uqName, alter.getTableName()));
    }

    protected void alterTableDropColumn(DdlBuffer buffer, String tableName, String columnName) throws IOException {
        this.platformDdl.alterTableDropColumn(buffer, tableName, columnName);
    }

    protected void alterTableAddColumn(DdlBuffer buffer, String tableName, Column column, boolean onHistoryTable, boolean withHistory) throws IOException {
        DdlMigrationHelp help = new DdlMigrationHelp(tableName, column, withHistory);
        if (!onHistoryTable) {
            help.writeBefore(buffer);
        }
        this.platformDdl.alterTableAddColumn(buffer, tableName, column, onHistoryTable, help.getDefaultValue());
        String comment = column.getComment();
        if (comment != null && !comment.isEmpty()) {
            this.platformDdl.addColumnComment(buffer, tableName, column.getName(), comment);
        }
        if (!onHistoryTable) {
            help.writeAfter(buffer);
        }
    }

    protected boolean isFalse(Boolean value) {
        return value != null && value == false;
    }

    protected boolean hasValue(String value) {
        return value != null && !value.trim().isEmpty();
    }

    protected boolean isTrue(Boolean value) {
        return Boolean.TRUE.equals(value);
    }

    static enum HistorySupport {
        NONE,
        SQL2011,
        TRIGGER_BASED;

    }

    private class DdlMigrationHelp {
        private final List<String> before;
        private final List<String> after;
        private final String tableName;
        private final String columnName;
        private final String defaultValue;
        private final boolean withHistory;

        DdlMigrationHelp(String tableName, Column column, boolean withHistory) {
            this.tableName = tableName;
            this.columnName = column.getName();
            this.defaultValue = BaseTableDdl.this.platformDdl.convertDefaultValue(column.getDefaultValue());
            boolean alterNotNull = Boolean.TRUE.equals(column.isNotnull());
            if (column.getBefore().isEmpty() && alterNotNull && this.defaultValue == null) {
                this.handleStrictError(tableName, this.columnName);
            }
            this.before = this.getScriptsForPlatform(column.getBefore());
            this.after = this.getScriptsForPlatform(column.getAfter());
            this.withHistory = withHistory;
        }

        DdlMigrationHelp(AlterColumn alter) {
            this.tableName = alter.getTableName();
            this.columnName = alter.getColumnName();
            String tmp = alter.getDefaultValue() != null ? alter.getDefaultValue() : alter.getCurrentDefaultValue();
            this.defaultValue = BaseTableDdl.this.platformDdl.convertDefaultValue(tmp);
            boolean alterNotNull = Boolean.TRUE.equals(alter.isNotnull());
            this.withHistory = BaseTableDdl.this.isTrue(alter.isWithHistory());
            if (alter.getBefore().isEmpty() && alterNotNull) {
                if (this.defaultValue == null) {
                    this.handleStrictError(this.tableName, this.columnName);
                }
                this.before = Collections.singletonList(BaseTableDdl.this.platformDdl.getUpdateNullWithDefault());
            } else {
                this.before = this.getScriptsForPlatform(alter.getBefore());
            }
            this.after = this.getScriptsForPlatform(alter.getAfter());
        }

        void writeBefore(DdlBuffer buffer) throws IOException {
            if (!this.before.isEmpty()) {
                buffer.end();
            }
            if (!this.before.isEmpty() && this.withHistory) {
                buffer.append("-- NOTE: table has @History - special migration may be necessary").newLine();
            }
            for (String ddlScript : this.before) {
                buffer.appendStatement(this.translate(ddlScript, this.tableName, this.columnName, this.defaultValue));
            }
        }

        void writeAfter(DdlBuffer buffer) throws IOException {
            if (!this.after.isEmpty() && this.withHistory) {
                buffer.append("-- NOTE: table has @History - special migration may be necessary").newLine();
            }
            for (String ddlScript : this.after) {
                buffer.appendStatement(this.translate(ddlScript, this.tableName, this.columnName, this.defaultValue));
            }
            if (!this.after.isEmpty()) {
                buffer.end();
            }
        }

        private List<String> getScriptsForPlatform(List<DdlScript> scripts) {
            Platform searchPlatform = BaseTableDdl.this.platformDdl.getPlatform().getPlatform();
            for (DdlScript script : scripts) {
                if (!PlatformMatch.matchPlatform(searchPlatform, script.getPlatforms())) continue;
                return script.getDdl();
            }
            return Collections.emptyList();
        }

        private String translate(String ddl, String tableName, String columnName, String defaultValue) {
            String ret = StringHelper.replace(ddl, "${table}", tableName);
            ret = StringHelper.replace(ret, "${column}", columnName);
            return StringHelper.replace(ret, "${default}", defaultValue);
        }

        private void handleStrictError(String tableName, String columnName) {
            if (BaseTableDdl.this.strictMode) {
                String message = "DB Migration of non-null column with no default value specified for: " + tableName + "." + columnName + " Use @DbDefault to specify a default value or specify dbMigration.setStrictMode(false)";
                throw new IllegalArgumentException(message);
            }
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

