/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration;

import io.ebean.config.dbplatform.DatabasePlatform;
import io.ebean.migration.MigrationVersion;
import io.ebeaninternal.dbmigration.DefaultDbMigration;
import io.ebeaninternal.dbmigration.MChecksum;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;

class IndexMigration {
    private static final String eol = "\n";
    private final List<Entry> all = new ArrayList<Entry>();
    private final File topDir;
    private final DatabasePlatform databasePlatform;
    private final File indexFile;
    private final Stack<String> pathStack = new Stack();

    IndexMigration(File topDir, DatabasePlatform databasePlatform) {
        this.topDir = topDir;
        this.databasePlatform = databasePlatform;
        this.indexFile = this.init();
    }

    IndexMigration(File topDir, DefaultDbMigration.Pair pair) {
        this.topDir = new File(topDir, pair.prefix);
        this.databasePlatform = pair.platform;
        this.indexFile = this.init();
    }

    File init() {
        this.pathStack.push("");
        String name = "idx_" + this.databasePlatform.getPlatform().base().name().toLowerCase() + ".migrations";
        return new File(this.topDir, name);
    }

    void generate() throws IOException {
        this.readSqlFiles(this.topDir);
        this.generateIndex();
    }

    private void generateIndex() throws IOException {
        Collections.sort(this.all);
        FileWriter writer = new FileWriter(this.indexFile);
        for (Entry entry : this.all) {
            this.writeChecksumPadded(writer, entry.checksum);
            writer.write(entry.fileName);
            writer.write(eol);
        }
        writer.write(eol);
        writer.close();
    }

    private void writeChecksumPadded(FileWriter writer, int checksum) throws IOException {
        String asStr = String.valueOf(checksum);
        writer.write(asStr);
        writer.write(44);
        int max = 15 - asStr.length();
        for (int i = 0; i < max; ++i) {
            writer.write(32);
        }
    }

    private void readSqlFiles(File dir) {
        File[] files = dir.listFiles();
        if (files != null && files.length > 0) {
            for (File file : files) {
                String lowerName;
                if (file.isDirectory()) {
                    this.readDirectory(file);
                }
                if (!(lowerName = file.getName().toLowerCase()).endsWith(".sql")) continue;
                this.addEntry(file);
            }
        }
    }

    private void readDirectory(File dir) {
        String current = this.pathStack.peek();
        this.pathStack.push(current + dir.getName() + "/");
        this.readSqlFiles(dir);
        this.pathStack.pop();
    }

    private void addEntry(File sqlFile) {
        String relativePath = this.pathStack.peek();
        String fileName = sqlFile.getName();
        String name = fileName.substring(0, fileName.length() - 4);
        MigrationVersion version = MigrationVersion.parse(name);
        int checksum = MChecksum.calculate(sqlFile);
        this.all.add(new Entry(checksum, version, relativePath + fileName));
    }

    static class Entry
    implements Comparable<Entry> {
        private final int checksum;
        private final String fileName;
        private final MigrationVersion version;

        Entry(int checksum, MigrationVersion version, String fileName) {
            this.checksum = checksum;
            this.version = version;
            this.fileName = fileName;
        }

        @Override
        public int compareTo(Entry other) {
            return this.version.compareTo(other.version);
        }
    }
}

