/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration;

import io.ebean.DB;
import io.ebean.Database;
import io.ebean.annotation.Platform;
import io.ebean.config.DatabaseConfig;
import io.ebean.config.DbConstraintNaming;
import io.ebean.config.PlatformConfig;
import io.ebean.config.PropertiesWrapper;
import io.ebean.config.dbplatform.DatabasePlatform;
import io.ebean.config.dbplatform.clickhouse.ClickHousePlatform;
import io.ebean.config.dbplatform.cockroach.CockroachPlatform;
import io.ebean.config.dbplatform.db2.DB2Platform;
import io.ebean.config.dbplatform.h2.H2Platform;
import io.ebean.config.dbplatform.hana.HanaPlatform;
import io.ebean.config.dbplatform.hsqldb.HsqldbPlatform;
import io.ebean.config.dbplatform.mariadb.MariaDbPlatform;
import io.ebean.config.dbplatform.mysql.MySql55Platform;
import io.ebean.config.dbplatform.mysql.MySqlPlatform;
import io.ebean.config.dbplatform.nuodb.NuoDbPlatform;
import io.ebean.config.dbplatform.oracle.Oracle11Platform;
import io.ebean.config.dbplatform.oracle.OraclePlatform;
import io.ebean.config.dbplatform.postgres.Postgres9Platform;
import io.ebean.config.dbplatform.postgres.PostgresPlatform;
import io.ebean.config.dbplatform.sqlanywhere.SqlAnywherePlatform;
import io.ebean.config.dbplatform.sqlite.SQLitePlatform;
import io.ebean.config.dbplatform.sqlserver.SqlServer16Platform;
import io.ebean.config.dbplatform.sqlserver.SqlServer17Platform;
import io.ebean.dbmigration.DbMigration;
import io.ebeaninternal.api.DbOffline;
import io.ebeaninternal.api.PlatformMatch;
import io.ebeaninternal.api.SpiEbeanServer;
import io.ebeaninternal.dbmigration.IndexMigration;
import io.ebeaninternal.dbmigration.LastMigration;
import io.ebeaninternal.dbmigration.UnknownResourcePathException;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlOptions;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlWrite;
import io.ebeaninternal.dbmigration.migration.Migration;
import io.ebeaninternal.dbmigration.migrationreader.MigrationXmlWriter;
import io.ebeaninternal.dbmigration.model.CurrentModel;
import io.ebeaninternal.dbmigration.model.MConfiguration;
import io.ebeaninternal.dbmigration.model.MigrationModel;
import io.ebeaninternal.dbmigration.model.ModelContainer;
import io.ebeaninternal.dbmigration.model.ModelDiff;
import io.ebeaninternal.dbmigration.model.PlatformDdlWriter;
import io.ebeaninternal.extraddl.model.DdlScript;
import io.ebeaninternal.extraddl.model.ExtraDdl;
import io.ebeaninternal.extraddl.model.ExtraDdlXmlReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDbMigration
implements DbMigration {
    protected static final Logger logger = LoggerFactory.getLogger("io.ebean.GenerateMigration");
    private static final String initialVersion = "1.0";
    private static final String GENERATED_COMMENT = "THIS IS A GENERATED FILE - DO NOT MODIFY";
    protected final boolean online;
    private boolean logToSystemOut = true;
    protected SpiEbeanServer server;
    protected String pathToResources = "src/main/resources";
    protected String migrationPath = "dbmigration";
    protected String migrationInitPath = "dbinit";
    protected String modelPath = "model";
    protected String modelSuffix = ".model.xml";
    protected DatabasePlatform databasePlatform;
    private boolean vanillaPlatform;
    protected List<Pair> platforms = new ArrayList<Pair>();
    protected DatabaseConfig databaseConfig;
    protected DbConstraintNaming constraintNaming;
    protected Boolean strictMode;
    protected Boolean includeGeneratedFileComment;
    protected String header;
    protected String applyPrefix = "";
    protected String version;
    protected String name;
    protected String generatePendingDrop;
    private boolean addForeignKeySkipCheck;
    private int lockTimeoutSeconds;
    protected boolean includeBuiltInPartitioning = true;
    protected boolean includeIndex;

    public DefaultDbMigration() {
        this.online = false;
    }

    @Override
    public void setPathToResources(String pathToResources) {
        this.pathToResources = pathToResources;
    }

    @Override
    public void setMigrationPath(String migrationPath) {
        this.migrationPath = migrationPath;
    }

    @Override
    public void setServer(Database database) {
        this.server = (SpiEbeanServer)database;
        this.setServerConfig(this.server.getServerConfig());
    }

    @Override
    public void setServerConfig(DatabaseConfig config) {
        Properties properties;
        if (this.databaseConfig == null) {
            this.databaseConfig = config;
        }
        if (this.constraintNaming == null) {
            this.constraintNaming = this.databaseConfig.getConstraintNaming();
        }
        if ((properties = config.getProperties()) != null) {
            PropertiesWrapper props = new PropertiesWrapper("ebean", config.getName(), properties, null);
            this.migrationPath = props.get("migration.migrationPath", this.migrationPath);
            this.migrationInitPath = props.get("migration.migrationInitPath", this.migrationInitPath);
            this.pathToResources = props.get("migration.pathToResources", this.pathToResources);
        }
    }

    @Override
    public void setStrictMode(boolean strictMode) {
        this.strictMode = strictMode;
    }

    @Override
    public void setApplyPrefix(String applyPrefix) {
        this.applyPrefix = applyPrefix;
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setAddForeignKeySkipCheck(boolean addForeignKeySkipCheck) {
        this.addForeignKeySkipCheck = addForeignKeySkipCheck;
    }

    @Override
    public void setLockTimeout(int seconds) {
        this.lockTimeoutSeconds = seconds;
    }

    @Override
    public void setGeneratePendingDrop(String generatePendingDrop) {
        this.generatePendingDrop = generatePendingDrop;
    }

    @Override
    public void setIncludeIndex(boolean includeIndex) {
        this.includeIndex = includeIndex;
    }

    @Override
    public void setIncludeGeneratedFileComment(boolean includeGeneratedFileComment) {
        this.includeGeneratedFileComment = includeGeneratedFileComment;
    }

    @Override
    public void setIncludeBuiltInPartitioning(boolean includeBuiltInPartitioning) {
        this.includeBuiltInPartitioning = includeBuiltInPartitioning;
    }

    @Override
    public void setHeader(String header) {
        this.header = header;
    }

    @Override
    public void setPlatform(Platform platform) {
        this.vanillaPlatform = true;
        this.setPlatform(this.platform(platform));
    }

    @Override
    public void setPlatform(DatabasePlatform databasePlatform) {
        this.databasePlatform = databasePlatform;
        if (!this.online) {
            DbOffline.setPlatform(databasePlatform.getPlatform());
        }
    }

    @Override
    public void addPlatform(Platform platform) {
        String prefix = platform.base().name().toLowerCase();
        this.addPlatform(platform, prefix);
    }

    @Override
    public void addPlatform(Platform platform, String prefix) {
        this.platforms.add(new Pair(this.platform(platform), prefix));
    }

    @Override
    public void addDatabasePlatform(DatabasePlatform databasePlatform, String prefix) {
        this.platforms.add(new Pair(databasePlatform, prefix));
    }

    @Override
    public String generateMigration() throws IOException {
        String version = this.generateMigrationFor(false);
        if (this.includeIndex) {
            this.generateIndex();
        }
        return version;
    }

    private void generateIndex() throws IOException {
        File topDir = this.migrationDirectory(false);
        if (!this.platforms.isEmpty()) {
            for (Pair pair : this.platforms) {
                new IndexMigration(topDir, pair).generate();
            }
        } else {
            new IndexMigration(topDir, this.databasePlatform).generate();
        }
    }

    @Override
    public String generateInitMigration() throws IOException {
        return this.generateMigrationFor(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateMigrationFor(boolean initMigration) throws IOException {
        if (!this.online) {
            DbOffline.setGenerateMigration();
            if (this.databasePlatform == null && !this.platforms.isEmpty()) {
                this.setPlatform(this.platforms.get((int)0).platform);
            }
        }
        this.setDefaults();
        if (!this.platforms.isEmpty()) {
            this.configurePlatforms();
        }
        try {
            String string;
            String pendingVersion;
            Request request = this.createRequest(initMigration);
            if (!initMigration) {
                if (this.platforms.isEmpty()) {
                    this.generateExtraDdl(request.migrationDir, this.databasePlatform, request.isTablePartitioning());
                } else {
                    for (Pair pair : this.platforms) {
                        PlatformDdlWriter platformWriter = this.createDdlWriter(pair.platform);
                        File subPath = platformWriter.subPath(request.migrationDir, pair.prefix);
                        this.generateExtraDdl(subPath, pair.platform, request.isTablePartitioning());
                    }
                }
            }
            if ((pendingVersion = this.generatePendingDrop()) != null) {
                string = this.generatePendingDrop(request, pendingVersion);
                return string;
            }
            string = this.generateDiff(request);
            return string;
        }
        catch (UnknownResourcePathException e) {
            this.logError("ERROR - " + e.getMessage());
            this.logError("Check the working directory or change dbMigration.setPathToResources() value?");
            Iterator<Pair> iterator = null;
            return iterator;
        }
        finally {
            if (!this.online) {
                DbOffline.reset();
            }
        }
    }

    @Override
    public List<String> getPendingDrops() {
        if (!this.online) {
            DbOffline.setGenerateMigration();
        }
        this.setDefaults();
        try {
            List<String> list = this.createRequest(false).getPendingDrops();
            return list;
        }
        finally {
            if (!this.online) {
                DbOffline.reset();
            }
        }
    }

    private void configurePlatforms() {
        for (Pair pair : this.platforms) {
            PlatformConfig config = this.databaseConfig.newPlatformConfig("dbmigration.platform", pair.prefix);
            pair.platform.configure(config);
        }
    }

    private void generateExtraDdl(File migrationDir, DatabasePlatform dbPlatform, boolean tablePartitioning) throws IOException {
        if (dbPlatform != null) {
            if (tablePartitioning && this.includeBuiltInPartitioning) {
                this.generateExtraDdlFor(migrationDir, dbPlatform, ExtraDdlXmlReader.readBuiltinTablePartitioning());
            }
            this.generateExtraDdlFor(migrationDir, dbPlatform, ExtraDdlXmlReader.readBuiltin());
            this.generateExtraDdlFor(migrationDir, dbPlatform, ExtraDdlXmlReader.read());
        }
    }

    private void generateExtraDdlFor(File migrationDir, DatabasePlatform dbPlatform, ExtraDdl extraDdl) throws IOException {
        if (extraDdl != null) {
            List<DdlScript> ddlScript = extraDdl.getDdlScript();
            for (DdlScript script : ddlScript) {
                if (script.isDrop() || !PlatformMatch.matchPlatform(dbPlatform.getPlatform(), script.getPlatforms())) continue;
                this.writeExtraDdl(migrationDir, script);
            }
        }
    }

    private void writeExtraDdl(File migrationDir, DdlScript script) throws IOException {
        String fullName = this.repeatableMigrationName(script.isInit(), script.getName());
        logger.debug("writing repeatable script {}", (Object)fullName);
        File file = new File(migrationDir, fullName);
        try (FileWriter writer = new FileWriter(file);){
            writer.write(script.getValue());
            writer.flush();
        }
    }

    @Override
    public void setLogToSystemOut(boolean logToSystemOut) {
        this.logToSystemOut = logToSystemOut;
    }

    private void logError(String message) {
        if (this.logToSystemOut) {
            System.out.println("DbMigration> " + message);
        } else {
            logger.error(message);
        }
    }

    private void logInfo(String message, Object value) {
        if (value != null) {
            message = String.format(message, value);
        }
        if (this.logToSystemOut) {
            System.out.println("DbMigration> " + message);
        } else {
            logger.info(message);
        }
    }

    private String repeatableMigrationName(boolean init, String scriptName) {
        StringBuilder sb = new StringBuilder();
        if (init) {
            sb.append("I__");
        } else {
            sb.append("R__");
        }
        sb.append(scriptName.replace(' ', '_'));
        sb.append(".sql");
        return sb.toString();
    }

    private String generateDiff(Request request) throws IOException {
        Migration migration;
        List<String> pendingDrops = request.getPendingDrops();
        if (!pendingDrops.isEmpty()) {
            this.logInfo("Pending un-applied drops in versions %s", pendingDrops);
        }
        if ((migration = request.createDiffMigration()) == null) {
            this.logInfo("no changes detected - no migration written", null);
            return null;
        }
        return this.generateMigration(request, migration, null);
    }

    private String generatePendingDrop(Request request, String pendingVersion) throws IOException {
        Migration migration = request.migrationForPendingDrop(pendingVersion);
        String version = this.generateMigration(request, migration, pendingVersion);
        List<String> pendingDrops = request.getPendingDrops();
        if (!pendingDrops.isEmpty()) {
            this.logInfo("... remaining pending un-applied drops in versions %s", pendingDrops);
        }
        return version;
    }

    private Request createRequest(boolean initMigration) {
        return new Request(initMigration);
    }

    private String generateMigration(Request request, Migration dbMigration, String dropsFor) throws IOException {
        String fullVersion = this.fullVersion(request.nextVersion(), dropsFor);
        this.logInfo("generating migration:%s", fullVersion);
        if (!request.initMigration && !this.writeMigrationXml(dbMigration, request.modelDir, fullVersion)) {
            this.logError("migration already exists, not generating DDL");
            return null;
        }
        if (!this.platforms.isEmpty()) {
            this.writeExtraPlatformDdl(fullVersion, request.currentModel, dbMigration, request.migrationDir);
        } else if (this.databasePlatform != null) {
            DdlOptions options = new DdlOptions(this.addForeignKeySkipCheck);
            DdlWrite write = new DdlWrite(new MConfiguration(), request.current, options);
            PlatformDdlWriter writer = this.createDdlWriter(this.databasePlatform);
            writer.processMigration(dbMigration, write, request.migrationDir, fullVersion);
        }
        return fullVersion;
    }

    private String generatePendingDrop() {
        String nextDrop = System.getProperty("ddl.migration.pendingDropsFor");
        if (nextDrop != null) {
            return nextDrop;
        }
        return this.generatePendingDrop;
    }

    private String fullVersion(String nextVersion, String dropsFor) {
        String version = this.version();
        if (version == null) {
            version = nextVersion != null ? nextVersion : initialVersion;
        }
        String fullVersion = this.applyPrefix + version;
        String name = this.name();
        if (name != null) {
            fullVersion = fullVersion + "__" + this.toUnderScore(name);
        } else if (dropsFor != null) {
            fullVersion = fullVersion + "__" + this.toUnderScore("dropsFor_" + this.trimDropsFor(dropsFor));
        } else if (version.equals(initialVersion)) {
            fullVersion = fullVersion + "__initial";
        }
        return fullVersion;
    }

    String trimDropsFor(String dropsFor) {
        int commentStart;
        if (dropsFor.startsWith("V") || dropsFor.startsWith("v")) {
            dropsFor = dropsFor.substring(1);
        }
        if ((commentStart = dropsFor.indexOf("__")) > -1) {
            dropsFor = dropsFor.substring(0, commentStart);
        }
        return dropsFor;
    }

    private String toUnderScore(String name) {
        return name.replace(' ', '_');
    }

    private void writeExtraPlatformDdl(String fullVersion, CurrentModel currentModel, Migration dbMigration, File writePath) throws IOException {
        DdlOptions options = new DdlOptions(this.addForeignKeySkipCheck);
        for (Pair pair : this.platforms) {
            DdlWrite platformBuffer = new DdlWrite(new MConfiguration(), currentModel.read(), options);
            PlatformDdlWriter platformWriter = this.createDdlWriter(pair.platform);
            File subPath = platformWriter.subPath(writePath, pair.prefix);
            platformWriter.processMigration(dbMigration, platformBuffer, subPath, fullVersion);
        }
    }

    private PlatformDdlWriter createDdlWriter(DatabasePlatform platform) {
        return new PlatformDdlWriter(platform, this.databaseConfig, this.lockTimeoutSeconds);
    }

    private boolean writeMigrationXml(Migration dbMigration, File resourcePath, String fullVersion) {
        String modelFile = fullVersion + this.modelSuffix;
        File file = new File(resourcePath, modelFile);
        if (file.exists()) {
            return false;
        }
        String comment = Boolean.TRUE.equals(this.includeGeneratedFileComment) ? GENERATED_COMMENT : null;
        MigrationXmlWriter xmlWriter = new MigrationXmlWriter(comment);
        xmlWriter.write(dbMigration, file);
        return true;
    }

    private void setDefaults() {
        if (this.server == null) {
            this.setServer(DB.getDefault());
        }
        if (this.vanillaPlatform || this.databasePlatform == null) {
            this.databasePlatform = this.server.getDatabasePlatform();
        }
        if (this.databaseConfig != null) {
            if (this.strictMode != null) {
                this.databaseConfig.setDdlStrictMode(this.strictMode);
            }
            if (this.header != null) {
                this.databaseConfig.setDdlHeader(this.header);
            }
        }
    }

    private String version() {
        String envVersion = this.readEnvironment("ddl.migration.version");
        if (!this.isEmpty(envVersion)) {
            return envVersion.trim();
        }
        return this.version;
    }

    private String name() {
        String envName = this.readEnvironment("ddl.migration.name");
        if (!this.isEmpty(envName)) {
            return envName.trim();
        }
        return this.name;
    }

    private boolean isEmpty(String val) {
        return val == null || val.trim().isEmpty();
    }

    private String readEnvironment(String key) {
        String val = System.getProperty(key);
        if (val == null) {
            val = System.getenv(key);
        }
        return val;
    }

    File migrationDirectory() {
        return this.migrationDirectory(false);
    }

    File migrationDirectory(boolean initMigration) {
        File resourceRootDir = new File(this.pathToResources);
        if (!resourceRootDir.exists()) {
            String msg = String.format("Error - path to resources %s does not exist. Absolute path is %s", this.pathToResources, resourceRootDir.getAbsolutePath());
            throw new UnknownResourcePathException(msg);
        }
        String resourcePath = this.migrationPath(initMigration);
        File path = new File(resourceRootDir, resourcePath);
        if (!path.exists() && !path.mkdirs()) {
            this.logInfo("Warning - Unable to ensure migration directory exists at %s", path.getAbsolutePath());
        }
        return path;
    }

    private String migrationPath(boolean initMigration) {
        return initMigration ? this.migrationInitPath : this.migrationPath;
    }

    private File modelDirectory(File migrationDirectory) {
        if (this.modelPath == null || this.modelPath.isEmpty()) {
            return migrationDirectory;
        }
        File modelDir = new File(migrationDirectory, this.modelPath);
        if (!modelDir.exists() && !modelDir.mkdirs()) {
            this.logInfo("Warning - Unable to ensure migration model directory exists at %s", modelDir.getAbsolutePath());
        }
        return modelDir;
    }

    protected DatabasePlatform platform(Platform platform) {
        switch (platform) {
            case H2: {
                return new H2Platform();
            }
            case HSQLDB: {
                return new HsqldbPlatform();
            }
            case POSTGRES9: {
                return new Postgres9Platform();
            }
            case POSTGRES: {
                return new PostgresPlatform();
            }
            case MARIADB: {
                return new MariaDbPlatform();
            }
            case MYSQL55: {
                return new MySql55Platform();
            }
            case MYSQL: {
                return new MySqlPlatform();
            }
            case ORACLE: {
                return new OraclePlatform();
            }
            case ORACLE11: {
                return new Oracle11Platform();
            }
            case SQLANYWHERE: {
                return new SqlAnywherePlatform();
            }
            case SQLSERVER16: {
                return new SqlServer16Platform();
            }
            case SQLSERVER17: {
                return new SqlServer17Platform();
            }
            case SQLSERVER: {
                throw new IllegalArgumentException("Please choose the more specific SQLSERVER16 or SQLSERVER17 platform. Refer to issue #1340 for details");
            }
            case DB2: {
                return new DB2Platform();
            }
            case SQLITE: {
                return new SQLitePlatform();
            }
            case HANA: {
                return new HanaPlatform();
            }
            case NUODB: {
                return new NuoDbPlatform();
            }
            case COCKROACH: {
                return new CockroachPlatform();
            }
            case CLICKHOUSE: {
                return new ClickHousePlatform();
            }
            case GENERIC: {
                return new DatabasePlatform();
            }
        }
        throw new IllegalArgumentException("Platform missing? " + (Object)((Object)platform));
    }

    static class Pair {
        final DatabasePlatform platform;
        final String prefix;

        Pair(DatabasePlatform platform, String prefix) {
            this.platform = platform;
            this.prefix = prefix;
        }
    }

    private class Request {
        final boolean initMigration;
        final File migrationDir;
        final File modelDir;
        final CurrentModel currentModel;
        final ModelContainer migrated;
        final ModelContainer current;

        private Request(boolean initMigration) {
            this.initMigration = initMigration;
            this.currentModel = new CurrentModel(DefaultDbMigration.this.server, DefaultDbMigration.this.constraintNaming);
            this.current = this.currentModel.read();
            this.migrationDir = DefaultDbMigration.this.migrationDirectory(initMigration);
            if (initMigration) {
                this.modelDir = null;
                this.migrated = new ModelContainer();
            } else {
                this.modelDir = DefaultDbMigration.this.modelDirectory(this.migrationDir);
                MigrationModel migrationModel = new MigrationModel(this.modelDir, DefaultDbMigration.this.modelSuffix);
                this.migrated = migrationModel.read(false);
            }
        }

        boolean isTablePartitioning() {
            return this.current.isTablePartitioning();
        }

        String nextVersion() {
            File migDirectory = DefaultDbMigration.this.migrationDirectory(false);
            File modelDir = DefaultDbMigration.this.modelDirectory(migDirectory);
            return LastMigration.nextVersion(migDirectory, modelDir, this.initMigration);
        }

        Migration migrationForPendingDrop(String pendingVersion) {
            Migration migration = this.migrated.migrationForPendingDrop(pendingVersion);
            this.migrated.registerPendingHistoryDropColumns(this.current);
            return migration;
        }

        public List<String> getPendingDrops() {
            return this.migrated.getPendingDrops();
        }

        Migration createDiffMigration() {
            ModelDiff diff = new ModelDiff(this.migrated);
            diff.compareTo(this.current);
            return diff.isEmpty() ? null : diff.getMigration();
        }
    }
}

