/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.api;

import io.ebeaninternal.api.ScopeTrans;
import io.ebeaninternal.api.SpiTransaction;
import io.ebeaninternal.api.SpiTransactionProxy;
import io.ebeaninternal.server.transaction.TransactionScopeManager;
import io.ebeaninternal.server.util.ArrayStack;
import javax.persistence.PersistenceException;

public class ScopedTransaction
extends SpiTransactionProxy {
    private final TransactionScopeManager manager;
    private final ArrayStack<ScopeTrans> stack = new ArrayStack();
    private ScopeTrans current;
    private boolean scopeCleared;

    public ScopedTransaction(TransactionScopeManager manager) {
        this.manager = manager;
    }

    public String toString() {
        return "ScopedTransaction[" + this.current + "]";
    }

    public void push(ScopeTrans scopeTrans) {
        if (this.current != null) {
            this.stack.push(this.current);
        }
        this.current = scopeTrans;
        this.transaction = scopeTrans.getTransaction();
    }

    public void complete(Object returnOrThrowable, int opCode) {
        this.current.complete(returnOrThrowable, opCode);
        this.pop();
    }

    public void complete() {
        try {
            this.current.complete();
        }
        finally {
            this.pop();
        }
    }

    private void clearScopeOnce() {
        if (!this.scopeCleared) {
            this.manager.clear();
            this.scopeCleared = true;
        }
    }

    private boolean clearScope() {
        if (this.stack.isEmpty()) {
            this.clearScopeOnce();
            return true;
        }
        return false;
    }

    private void pop() {
        if (!this.clearScope()) {
            this.current = this.stack.pop();
            this.transaction = this.current.getTransaction();
        }
    }

    @Override
    public void end() throws PersistenceException {
        try {
            this.current.end();
        }
        finally {
            this.pop();
        }
    }

    @Override
    public void close() {
        this.end();
    }

    @Override
    public void commit() {
        try {
            this.current.commitTransaction();
        }
        finally {
            this.clearScope();
        }
    }

    @Override
    public void rollback() throws PersistenceException {
        try {
            this.current.rollback(null);
        }
        finally {
            this.clearScope();
        }
    }

    @Override
    public void rollback(Throwable e) throws PersistenceException {
        try {
            this.current.rollback(e);
        }
        finally {
            this.clearScope();
        }
    }

    @Override
    public void setRollbackOnly() {
        this.current.setRollbackOnly();
    }

    @Override
    public SpiTransaction current() {
        return this.transaction;
    }

    public Error caughtError(Error e) {
        return this.current.caughtError(e);
    }

    public Exception caughtThrowable(Exception e) {
        return this.current.caughtThrowable(e);
    }
}

