/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.api;

import io.ebean.TxScope;
import io.ebeaninternal.api.SpiTransaction;
import java.util.ArrayList;

public class ScopeTrans {
    private static final int OPCODE_ATHROW = 191;
    private final SpiTransaction transaction;
    private final boolean rollbackOnChecked;
    private final boolean created;
    private final ArrayList<Class<? extends Throwable>> noRollbackFor;
    private final ArrayList<Class<? extends Throwable>> rollbackFor;
    private Boolean restoreBatch;
    private Boolean restoreBatchOnCascade;
    private int restoreBatchSize;
    private Boolean restoreBatchGeneratedKeys;
    private boolean restoreBatchFlushOnQuery;
    private boolean rolledBack;
    private boolean nestedCommit;

    public ScopeTrans(boolean rollbackOnChecked, boolean created, SpiTransaction transaction, TxScope txScope) {
        this.rollbackOnChecked = rollbackOnChecked;
        this.created = created;
        this.transaction = transaction;
        this.noRollbackFor = txScope.getNoRollbackFor();
        this.rollbackFor = txScope.getRollbackFor();
        if (transaction != null) {
            Boolean autoPersistUpdates;
            if (!created && txScope.isBatchSet() || txScope.isBatchOnCascadeSet() || txScope.isBatchSizeSet()) {
                this.restoreBatch = transaction.isBatchMode();
                this.restoreBatchOnCascade = transaction.isBatchOnCascade();
                this.restoreBatchSize = transaction.getBatchSize();
                this.restoreBatchGeneratedKeys = transaction.getBatchGetGeneratedKeys();
                this.restoreBatchFlushOnQuery = transaction.isFlushOnQuery();
            }
            if ((autoPersistUpdates = txScope.getAutoPersistUpdates()) != null) {
                transaction.setAutoPersistUpdates(autoPersistUpdates);
            }
            if (txScope.isBatchSet()) {
                transaction.setBatchMode(txScope.isBatchMode());
            }
            if (!txScope.isFlushOnQuery()) {
                transaction.setFlushOnQuery(false);
            }
            if (txScope.isBatchOnCascadeSet()) {
                transaction.setBatchOnCascade(txScope.isBatchOnCascade());
            }
            if (txScope.isBatchSizeSet()) {
                transaction.setBatchSize(txScope.getBatchSize());
            }
            if (txScope.isSkipGeneratedKeys()) {
                transaction.setGetGeneratedKeys(false);
            }
        }
    }

    public String toString() {
        return "ScopeTrans[" + this.transaction + "]";
    }

    protected SpiTransaction getTransaction() {
        return this.transaction;
    }

    void complete(Object returnOrThrowable, int opCode) {
        if (opCode == 191) {
            this.caughtThrowable((Throwable)returnOrThrowable);
        }
        this.complete();
    }

    public void complete() {
        if (!this.rolledBack) {
            this.commitTransaction();
        }
    }

    public void end() {
        if (this.created || !this.nestedCommit) {
            this.transaction.end();
        }
    }

    protected void commitTransaction() {
        if (this.created) {
            this.transaction.commit();
        } else {
            this.nestedCommit = true;
            this.transaction.setFlushOnQuery(this.restoreBatchFlushOnQuery);
            if (this.restoreBatch != null) {
                this.transaction.setBatchMode(this.restoreBatch);
            }
            if (this.restoreBatchOnCascade != null) {
                this.transaction.setBatchOnCascade(this.restoreBatchOnCascade);
            }
            if (this.restoreBatchSize > 0) {
                this.transaction.setBatchSize(this.restoreBatchSize);
            }
            if (this.restoreBatchGeneratedKeys != null) {
                this.transaction.setGetGeneratedKeys(this.restoreBatchGeneratedKeys);
            }
        }
    }

    public Error caughtError(Error e) {
        this.rollback(e);
        return e;
    }

    public void setRollbackOnly() {
        if (this.transaction != null) {
            this.transaction.setRollbackOnly();
        }
    }

    public <T extends Throwable> T caughtThrowable(T e) {
        if (this.isRollbackThrowable(e)) {
            this.rollback(e);
        }
        return e;
    }

    protected void rollback(Throwable e) {
        if (this.transaction != null && this.transaction.isActive()) {
            this.transaction.rollback(e);
        }
        this.rolledBack = true;
    }

    private boolean isRollbackThrowable(Throwable e) {
        if (e instanceof Error) {
            return true;
        }
        if (this.noRollbackFor != null) {
            for (Class<? extends Throwable> aNoRollbackFor : this.noRollbackFor) {
                if (!aNoRollbackFor.equals(e.getClass())) continue;
                return false;
            }
        }
        if (this.rollbackFor != null) {
            for (Class<? extends Throwable> aRollbackFor : this.rollbackFor) {
                if (!aRollbackFor.equals(e.getClass())) continue;
                return true;
            }
        }
        return e instanceof RuntimeException || this.rollbackOnChecked;
    }
}

