/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.api;

import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import io.ebeaninternal.api.LoadBeanBuffer;
import io.ebeaninternal.api.LoadRequest;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.server.core.OrmQueryRequest;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class LoadBeanRequest
extends LoadRequest {
    private final List<EntityBeanIntercept> batch;
    private final LoadBeanBuffer loadBuffer;
    private final String lazyLoadProperty;
    private final boolean loadCache;
    private boolean loadedFromCache;

    public LoadBeanRequest(LoadBeanBuffer LoadBuffer2, EntityBeanIntercept ebi, boolean loadCache) {
        this(LoadBuffer2, null, true, ebi.getLazyLoadProperty(), loadCache);
        this.loadedFromCache = ebi.isLoadedFromCache();
    }

    public LoadBeanRequest(LoadBeanBuffer LoadBuffer2, OrmQueryRequest<?> parentRequest) {
        this(LoadBuffer2, parentRequest, false, null, false);
    }

    private LoadBeanRequest(LoadBeanBuffer loadBuffer, OrmQueryRequest<?> parentRequest, boolean lazy, String lazyLoadProperty, boolean loadCache) {
        super(parentRequest, lazy);
        this.loadBuffer = loadBuffer;
        this.batch = loadBuffer.getBatch();
        this.lazyLoadProperty = lazyLoadProperty;
        this.loadCache = loadCache;
    }

    @Override
    public Class<?> getBeanType() {
        return this.loadBuffer.getBeanDescriptor().getBeanType();
    }

    public boolean isLoadedFromCache() {
        return this.loadedFromCache;
    }

    private boolean isLoadCache() {
        return this.loadCache;
    }

    public String getDescription() {
        return "path:" + this.loadBuffer.getFullPath() + " batch:" + this.batch.size();
    }

    public List<EntityBeanIntercept> getBatch() {
        return this.batch;
    }

    private LoadBeanBuffer getLoadContext() {
        return this.loadBuffer;
    }

    public int getBatchSize() {
        return this.getLoadContext().getBatchSize();
    }

    public List<Object> getIdList() {
        ArrayList<Object> idList = new ArrayList<Object>();
        BeanDescriptor<?> desc = this.loadBuffer.getBeanDescriptor();
        for (EntityBeanIntercept ebi : this.batch) {
            idList.add(desc.getId(ebi.getOwner()));
        }
        return idList;
    }

    public void configureQuery(SpiQuery<?> query, List<Object> idList) {
        query.setMode(SpiQuery.Mode.LAZYLOAD_BEAN);
        query.setPersistenceContext(this.loadBuffer.getPersistenceContext());
        String mode = this.isLazy() ? "+lazy" : "+query";
        query.setLoadDescription(mode, this.getDescription());
        if (this.isLazy()) {
            query.setLazyLoadBatchSize(this.getBatchSize());
        }
        this.loadBuffer.configureQuery(query, this.lazyLoadProperty);
        if (idList.size() == 1) {
            query.where().idEq(idList.get(0));
        } else {
            query.where().idIn(idList);
        }
    }

    public void postLoad(List<?> list) {
        HashSet<Object> loadedIds = new HashSet<Object>();
        BeanDescriptor<?> desc = this.loadBuffer.getBeanDescriptor();
        for (Object bean : list) {
            EntityBean loadedBean = (EntityBean)bean;
            loadedIds.add(desc.getId(loadedBean));
        }
        if (this.isLoadCache()) {
            desc.cacheBeanPutAll(list);
        }
        if (this.lazyLoadProperty != null) {
            for (EntityBeanIntercept ebi : this.batch) {
                Object id = desc.getId(ebi.getOwner());
                if (loadedIds.contains(id)) continue;
                desc.markAsDeleted(ebi.getOwner());
            }
        }
    }
}

