/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.api;

import io.ebeaninternal.api.BeanCacheResult;
import io.ebeaninternal.api.CacheIdLookup;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class CacheIdLookupSingle<T>
implements CacheIdLookup<T> {
    private final Object idValue;
    private boolean found;

    public CacheIdLookupSingle(Object idValue) {
        this.idValue = idValue;
    }

    @Override
    public Collection<?> idValues() {
        return Collections.singleton(this.idValue);
    }

    @Override
    public List<T> removeHits(BeanCacheResult<T> cacheResult) {
        List<BeanCacheResult.Entry<T>> hits = cacheResult.hits();
        if (hits.size() == 1) {
            this.found = true;
            return Collections.singletonList(hits.get(0).getBean());
        }
        return Collections.emptyList();
    }

    @Override
    public boolean allHits() {
        return this.found;
    }
}

