/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.util;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcClose {
    private static final Logger logger = LoggerFactory.getLogger(JdbcClose.class);

    public static void close(Statement statement) {
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException e) {
            logger.warn("Error closing statement", e);
        }
    }

    public static void close(ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (SQLException e) {
            logger.warn("Error closing resultSet", e);
        }
    }

    public static void close(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException e) {
            logger.warn("Error closing connection", e);
        }
    }

    public static void rollback(Connection connection) {
        try {
            if (connection != null) {
                connection.rollback();
            }
        }
        catch (SQLException e) {
            logger.warn("Error on connection rollback", e);
        }
    }

    public static void cancel(Statement stmt) {
        try {
            if (stmt != null) {
                stmt.cancel();
            }
        }
        catch (SQLException e) {
            logger.warn("Error on cancelling statement", e);
        }
    }
}

