/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.migration;

import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationVersion
implements Comparable<MigrationVersion> {
    private static final Logger logger = LoggerFactory.getLogger(MigrationVersion.class);
    public static final String BOOTINIT_TYPE = "B";
    private static final String INIT_TYPE = "I";
    private static final String REPEAT_TYPE = "R";
    public static final String VERSION_TYPE = "V";
    private static final int[] REPEAT_ORDERING_MIN = new int[]{Integer.MIN_VALUE};
    private static final int[] REPEAT_ORDERING_MAX = new int[]{Integer.MAX_VALUE};
    private static final boolean[] REPEAT_UNDERSCORES = new boolean[]{false};
    private final String raw;
    private final int[] ordering;
    private final boolean[] underscores;
    private final String comment;

    private MigrationVersion(String raw, String comment, boolean init) {
        this.raw = raw;
        this.comment = comment;
        this.ordering = init ? REPEAT_ORDERING_MIN : REPEAT_ORDERING_MAX;
        this.underscores = REPEAT_UNDERSCORES;
    }

    private MigrationVersion(String raw, int[] ordering, boolean[] underscores, String comment) {
        this.raw = raw;
        this.ordering = ordering;
        this.underscores = underscores;
        this.comment = comment;
    }

    public boolean isRepeatable() {
        return this.ordering == REPEAT_ORDERING_MIN || this.ordering == REPEAT_ORDERING_MAX;
    }

    public boolean isRepeatableInit() {
        return this.ordering == REPEAT_ORDERING_MIN;
    }

    public boolean isRepeatableLast() {
        return this.ordering == REPEAT_ORDERING_MAX;
    }

    public String getFull() {
        return this.raw;
    }

    public String toString() {
        return this.raw;
    }

    public String getComment() {
        return this.comment;
    }

    public String getRaw() {
        return this.raw;
    }

    public String asString() {
        return this.formattedVersion(false, false);
    }

    public String normalised() {
        return this.formattedVersion(true, false);
    }

    public String nextVersion() {
        return this.formattedVersion(false, true);
    }

    private String formattedVersion(boolean normalised, boolean nextVersion) {
        if (this.isRepeatable()) {
            return this.getType();
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.ordering.length; ++i) {
            if (i < this.ordering.length - 1) {
                sb.append(this.ordering[i]);
                if (normalised) {
                    sb.append('.');
                    continue;
                }
                sb.append(this.underscores[i] ? (char)'_' : '.');
                continue;
            }
            sb.append(nextVersion ? this.ordering[i] + 1 : this.ordering[i]);
        }
        return sb.toString();
    }

    @Override
    public int compareTo(MigrationVersion other) {
        int otherLength = other.ordering.length;
        for (int i = 0; i < this.ordering.length; ++i) {
            if (i >= otherLength) {
                return 1;
            }
            if (this.ordering[i] == other.ordering[i]) continue;
            return this.ordering[i] > other.ordering[i] ? 1 : -1;
        }
        if (this.ordering.length < otherLength) {
            return -1;
        }
        return this.isRepeatable() ? this.comment.compareTo(other.comment) : 0;
    }

    public static String trim(String raw) {
        return MigrationVersion.parse(raw).asString();
    }

    public static MigrationVersion parse(String raw) {
        String[] sections;
        if (raw.startsWith(VERSION_TYPE) || raw.startsWith("v")) {
            raw = raw.substring(1);
        }
        String comment = "";
        String value = raw;
        int commentStart = raw.indexOf("__");
        if (commentStart > -1) {
            comment = raw.substring(commentStart + 2);
            value = value.substring(0, commentStart);
        }
        if ((sections = (value = value.replace('_', '.')).split("[\\.-]"))[0].startsWith(REPEAT_TYPE) || sections[0].startsWith("r")) {
            return new MigrationVersion(raw, comment, false);
        }
        if (sections[0].startsWith(INIT_TYPE) || sections[0].startsWith("i")) {
            return new MigrationVersion(raw, comment, true);
        }
        boolean[] underscores = new boolean[sections.length];
        int[] ordering = new int[sections.length];
        int delimiterPos = 0;
        int stopIndex = 0;
        for (int i = 0; i < sections.length; ++i) {
            try {
                ordering[i] = Integer.parseInt(sections[i]);
                ++stopIndex;
                underscores[i] = (delimiterPos += sections[i].length()) < raw.length() - 1 && raw.charAt(delimiterPos) == '_';
                ++delimiterPos;
                continue;
            }
            catch (NumberFormatException e) {
                logger.warn("The migrationscript '{}' contains non numeric version part. This may lead to misordered version scripts. NumberFormatException {}", (Object)raw, (Object)e.getMessage());
                break;
            }
        }
        int[] actualOrder = Arrays.copyOf(ordering, stopIndex);
        boolean[] actualUnderscores = Arrays.copyOf(underscores, stopIndex);
        return new MigrationVersion(raw, actualOrder, actualUnderscores, comment);
    }

    public String getType() {
        if (this.ordering == REPEAT_ORDERING_MIN) {
            return INIT_TYPE;
        }
        if (this.ordering == REPEAT_ORDERING_MAX) {
            return REPEAT_TYPE;
        }
        return VERSION_TYPE;
    }
}

