/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.config.dbplatform;

import io.ebean.config.PlatformConfig;
import io.ebean.config.dbplatform.DbPlatformType;
import io.ebean.config.dbplatform.DbPlatformTypeLookup;
import io.ebean.config.dbplatform.DbType;
import java.util.EnumMap;
import java.util.Map;

public class DbPlatformTypeMapping {
    private static final DbPlatformTypeLookup lookup = new DbPlatformTypeLookup();
    private static final DbPlatformType BOOLEAN_LOGICAL = new BooleanLogicalType();
    private static final DbPlatformType INET_NATIVE = new DbPlatformType("inet", false);
    private static final DbPlatformType INET_VARCHAR = new DbPlatformType("varchar", 50);
    private static final DbPlatformType CIDR_NATIVE = new DbPlatformType("cidr", false);
    private static final DbPlatformType CIDR_VARCHAR = new DbPlatformType("varchar", 50);
    private static final DbPlatformType UUID_NATIVE = new DbPlatformType("uuid", false);
    private static final DbPlatformType UUID_PLACEHOLDER = new DbPlatformType("uuidPlaceholder");
    private static final DbPlatformType JSON_CLOB_PLACEHOLDER = new DbPlatformType("jsonClobPlaceholder");
    private static final DbPlatformType JSON_BLOB_PLACEHOLDER = new DbPlatformType("jsonBlobPlaceholder");
    private static final DbPlatformType JSON_VARCHAR_PLACEHOLDER = new DbPlatformType("jsonVarcharPlaceholder");
    private static final DbPlatformType POINT = new DbPlatformType("point");
    private static final DbPlatformType POLYGON = new DbPlatformType("polygon");
    private static final DbPlatformType LINESTRING = new DbPlatformType("linestring");
    private static final DbPlatformType MULTIPOINT = new DbPlatformType("multipoint");
    private static final DbPlatformType MULTILINESTRING = new DbPlatformType("multilinestring");
    private static final DbPlatformType MULTIPOLYGON = new DbPlatformType("multipolygon");
    private final Map<DbType, DbPlatformType> typeMap = new EnumMap<DbType, DbPlatformType>(DbType.class);

    public static DbPlatformTypeMapping logicalTypes() {
        return new DbPlatformTypeMapping(true);
    }

    public DbPlatformTypeMapping() {
        this.loadDefaults(false);
    }

    private DbPlatformTypeMapping(boolean logicalTypes) {
        this.loadDefaults(logicalTypes);
    }

    private void loadDefaults(boolean logicalTypes) {
        this.put(DbType.BOOLEAN, BOOLEAN_LOGICAL);
        this.put(DbType.BIT);
        this.put(DbType.INTEGER);
        this.put(DbType.BIGINT);
        this.put(DbType.DOUBLE);
        this.put(DbType.SMALLINT);
        this.put(DbType.TINYINT);
        this.put(DbType.BLOB);
        this.put(DbType.CLOB);
        this.put(DbType.ARRAY);
        this.put(DbType.DATE);
        this.put(DbType.TIME);
        this.put(DbType.TIMESTAMP);
        this.put(DbType.LONGVARBINARY);
        this.put(DbType.LONGVARCHAR);
        this.put(DbType.REAL, new DbPlatformType("float"));
        this.put(DbType.POINT, POINT);
        this.put(DbType.POLYGON, POLYGON);
        this.put(DbType.LINESTRING, LINESTRING);
        this.put(DbType.MULTIPOINT, MULTIPOINT);
        this.put(DbType.MULTILINESTRING, MULTILINESTRING);
        this.put(DbType.MULTIPOLYGON, MULTIPOLYGON);
        if (logicalTypes) {
            this.put(DbType.VARCHAR, new DbPlatformType("varchar"));
            this.put(DbType.DECIMAL, new DbPlatformType("decimal"));
            this.put(DbType.VARBINARY, new DbPlatformType("varbinary"));
            this.put(DbType.BINARY, new DbPlatformType("binary"));
            this.put(DbType.CHAR, new DbPlatformType("char"));
            this.put(DbType.HSTORE, new DbPlatformType("hstore", false));
            this.put(DbType.JSON, new DbPlatformType("json", false));
            this.put(DbType.JSONB, new DbPlatformType("jsonb", false));
            this.put(DbType.JSONCLOB, new DbPlatformType("jsonclob"));
            this.put(DbType.JSONBLOB, new DbPlatformType("jsonblob"));
            this.put(DbType.JSONVARCHAR, new DbPlatformType("jsonvarchar", 1000));
            this.put(DbType.UUID, UUID_NATIVE);
            this.put(DbType.INET, INET_NATIVE);
            this.put(DbType.CIDR, CIDR_NATIVE);
        } else {
            this.put(DbType.VARCHAR, new DbPlatformType("varchar", 255));
            this.put(DbType.DECIMAL, new DbPlatformType("decimal", 16, 3));
            this.put(DbType.VARBINARY, new DbPlatformType("varbinary", 255));
            this.put(DbType.BINARY, new DbPlatformType("binary", 255));
            this.put(DbType.CHAR, new DbPlatformType("char", 1));
            this.put(DbType.JSON, JSON_CLOB_PLACEHOLDER);
            this.put(DbType.JSONB, JSON_CLOB_PLACEHOLDER);
            this.put(DbType.JSONCLOB, JSON_CLOB_PLACEHOLDER);
            this.put(DbType.JSONBLOB, JSON_BLOB_PLACEHOLDER);
            this.put(DbType.JSONVARCHAR, JSON_VARCHAR_PLACEHOLDER);
            this.put(DbType.UUID, UUID_NATIVE);
            this.put(DbType.INET, INET_VARCHAR);
            this.put(DbType.CIDR, CIDR_VARCHAR);
        }
    }

    public DbPlatformType lookup(String name, boolean withScale) {
        DbType type = lookup.byName(name);
        if (type == null) {
            throw new IllegalArgumentException("Unknown type [" + name + "] - not standard sql type");
        }
        switch (type) {
            case JSONBLOB: {
                return this.get(DbType.BLOB);
            }
            case JSONCLOB: {
                return this.get(DbType.CLOB);
            }
            case JSONVARCHAR: {
                return this.get(DbType.VARCHAR);
            }
            case JSON: {
                return this.getJsonType(DbType.JSON, withScale);
            }
            case JSONB: {
                return this.getJsonType(DbType.JSONB, withScale);
            }
        }
        return this.get(type);
    }

    private DbPlatformType getJsonType(DbType type, boolean withScale) {
        DbPlatformType dbType = this.get(type);
        if (dbType == JSON_CLOB_PLACEHOLDER) {
            return withScale ? this.get(DbType.VARCHAR) : this.get(DbType.CLOB);
        }
        if (dbType == JSON_BLOB_PLACEHOLDER) {
            return this.get(DbType.BLOB);
        }
        if (dbType == JSON_VARCHAR_PLACEHOLDER) {
            return this.get(DbType.VARCHAR);
        }
        return this.get(type);
    }

    private void put(DbType type) {
        this.typeMap.put(type, type.createPlatformType());
    }

    public void put(DbType type, DbPlatformType platformType) {
        this.typeMap.put(type, platformType);
    }

    public DbPlatformType get(int jdbcType) {
        return this.get(lookup.byId(jdbcType));
    }

    public DbPlatformType get(DbType dbType) {
        return this.typeMap.get((Object)dbType);
    }

    public void config(boolean nativeUuidType, PlatformConfig.DbUuid dbUuid) {
        if (!nativeUuidType || !dbUuid.useNativeType()) {
            if (dbUuid.useBinary()) {
                this.put(DbType.UUID, this.get(DbType.BINARY).withLength(16));
            } else {
                this.put(DbType.UUID, this.get(DbType.VARCHAR).withLength(40));
            }
        }
    }

    private static class BooleanLogicalType
    extends DbPlatformType {
        BooleanLogicalType() {
            super("boolean", false);
        }

        @Override
        protected void renderLengthScale(int deployLength, int deployScale, StringBuilder sb) {
        }
    }
}

