/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.config;

import io.ebean.config.AutoTuneMode;
import io.ebean.config.PropertiesWrapper;

public class AutoTuneConfig {
    private AutoTuneMode mode = AutoTuneMode.DEFAULT_OFF;
    private String queryTuningFile = "ebean-autotune.xml";
    private boolean queryTuning;
    private boolean queryTuningAddVersion;
    private boolean profiling;
    private String profilingFile = "ebean-profiling";
    private int profilingBase = 5;
    private double profilingRate = 0.01;
    private int profilingUpdateFrequency;
    private int garbageCollectionWait = 100;
    private boolean skipGarbageCollectionOnShutdown;
    private boolean skipProfileReportingOnShutdown;

    public boolean isActive() {
        return this.profiling || this.queryTuning;
    }

    public String getQueryTuningFile() {
        return this.queryTuningFile;
    }

    public void setQueryTuningFile(String queryTuningFile) {
        this.queryTuningFile = queryTuningFile;
    }

    public String getProfilingFile() {
        return this.profilingFile;
    }

    public void setProfilingFile(String profilingFile) {
        this.profilingFile = profilingFile;
    }

    public int getProfilingUpdateFrequency() {
        return this.profilingUpdateFrequency;
    }

    public void setProfilingUpdateFrequency(int profilingUpdateFrequency) {
        this.profilingUpdateFrequency = profilingUpdateFrequency;
    }

    public AutoTuneMode getMode() {
        return this.mode;
    }

    public void setMode(AutoTuneMode mode) {
        this.mode = mode;
    }

    public boolean isQueryTuning() {
        return this.queryTuning;
    }

    public void setQueryTuning(boolean queryTuning) {
        this.queryTuning = queryTuning;
    }

    public boolean isQueryTuningAddVersion() {
        return this.queryTuningAddVersion;
    }

    public void setQueryTuningAddVersion(boolean queryTuningAddVersion) {
        this.queryTuningAddVersion = queryTuningAddVersion;
    }

    public boolean isProfiling() {
        return this.profiling;
    }

    public void setProfiling(boolean profiling) {
        this.profiling = profiling;
    }

    public int getProfilingBase() {
        return this.profilingBase;
    }

    public void setProfilingBase(int profilingBase) {
        this.profilingBase = profilingBase;
    }

    public double getProfilingRate() {
        return this.profilingRate;
    }

    public void setProfilingRate(double profilingRate) {
        this.profilingRate = profilingRate;
    }

    public int getGarbageCollectionWait() {
        return this.garbageCollectionWait;
    }

    public void setGarbageCollectionWait(int garbageCollectionWait) {
        this.garbageCollectionWait = garbageCollectionWait;
    }

    public boolean isSkipGarbageCollectionOnShutdown() {
        return this.skipGarbageCollectionOnShutdown;
    }

    public void setSkipGarbageCollectionOnShutdown(boolean skipGarbageCollectionOnShutdown) {
        this.skipGarbageCollectionOnShutdown = skipGarbageCollectionOnShutdown;
    }

    public boolean isSkipProfileReportingOnShutdown() {
        return this.skipProfileReportingOnShutdown;
    }

    public void setSkipProfileReportingOnShutdown(boolean skipProfileReportingOnShutdown) {
        this.skipProfileReportingOnShutdown = skipProfileReportingOnShutdown;
    }

    public void loadSettings(PropertiesWrapper p) {
        this.queryTuning = p.getBoolean("autoTune.queryTuning", this.queryTuning);
        this.queryTuningAddVersion = p.getBoolean("autoTune.queryTuningAddVersion", this.queryTuningAddVersion);
        this.queryTuningFile = p.get("autoTune.queryTuningFile", this.queryTuningFile);
        this.skipGarbageCollectionOnShutdown = p.getBoolean("autoTune.skipGarbageCollectionOnShutdown", this.skipGarbageCollectionOnShutdown);
        this.skipProfileReportingOnShutdown = p.getBoolean("autoTune.skipProfileReportingOnShutdown", this.skipProfileReportingOnShutdown);
        this.mode = p.getEnum(AutoTuneMode.class, "autoTune.mode", this.mode);
        this.profiling = p.getBoolean("autoTune.profiling", this.profiling);
        this.profilingBase = p.getInt("autoTune.profilingBase", this.profilingBase);
        this.profilingRate = p.getDouble("autoTune.profilingRate", this.profilingRate);
        this.profilingFile = p.get("autoTune.profilingFile", this.profilingFile);
        this.profilingUpdateFrequency = p.getInt("autoTune.profilingUpdateFrequency", this.profilingUpdateFrequency);
    }
}

