/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.cache;

public class ServerCacheStatistics {
    protected String cacheName;
    protected int maxSize;
    protected int size;
    protected long hitCount;
    protected long missCount;
    protected long putCount;
    protected long removeCount;
    protected long clearCount;
    protected long evictCount;

    public String toString() {
        StringBuilder sb = new StringBuilder(80);
        sb.append(this.cacheName);
        sb.append(" maxSize:").append(this.maxSize);
        sb.append(" size:").append(this.size);
        sb.append(" hitRatio:").append(this.getHitRatio());
        sb.append(" hit:").append(this.hitCount);
        sb.append(" miss:").append(this.missCount);
        sb.append(" put:").append(this.putCount);
        sb.append(" remove:").append(this.removeCount);
        sb.append(" clear:").append(this.clearCount);
        sb.append(" evict:").append(this.evictCount);
        return sb.toString();
    }

    public int getHitRatio() {
        long totalCount = this.hitCount + this.missCount;
        if (totalCount == 0L) {
            return 0;
        }
        return (int)(this.hitCount * 100L / totalCount);
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    public long getHitCount() {
        return this.hitCount;
    }

    public void setHitCount(long hitCount) {
        this.hitCount = hitCount;
    }

    public long getMissCount() {
        return this.missCount;
    }

    public void setMissCount(long missCount) {
        this.missCount = missCount;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public void setPutCount(long putCount) {
        this.putCount = putCount;
    }

    public long getPutCount() {
        return this.putCount;
    }

    public void setRemoveCount(long removeCount) {
        this.removeCount = removeCount;
    }

    public long getRemoveCount() {
        return this.removeCount;
    }

    public void setClearCount(long clearCount) {
        this.clearCount = clearCount;
    }

    public long getClearCount() {
        return this.clearCount;
    }

    public void setEvictCount(long evictCount) {
        this.evictCount = evictCount;
    }

    public long getEvictCount() {
        return this.evictCount;
    }
}

