/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.config;

import io.avaje.config.CoreExpressionEval;
import io.avaje.config.InitialLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InitialLoadContext {
    private static final Logger log = LoggerFactory.getLogger(InitialLoadContext.class);
    private final Map<String, String> map = new LinkedHashMap<String, String>();
    private final Set<String> loadedResources = new LinkedHashSet<String>();
    private final List<File> loadedFiles = new ArrayList<File>();
    private final CoreExpressionEval exprEval = new CoreExpressionEval(this.map);

    InitialLoadContext() {
    }

    List<File> loadedFiles() {
        return this.loadedFiles;
    }

    String eval(String expression) {
        return this.exprEval.eval(expression);
    }

    void loadEnvironmentVars() {
        String podName = System.getenv("POD_NAME");
        this.initSystemProperty(podName, "app.instanceId");
        this.initSystemProperty(InitialLoadContext.podService(podName), "app.name");
        this.initSystemProperty(System.getenv("POD_NAMESPACE"), "app.environment");
        this.initSystemProperty(System.getenv("POD_VERSION"), "app.version");
        this.initSystemProperty(System.getenv("POD_IP"), "app.ipAddress");
    }

    private void initSystemProperty(String envValue, String key) {
        if (envValue != null && System.getProperty(key) == null) {
            this.map.put(key, envValue);
        }
    }

    static String podService(String podName) {
        int p0;
        if (podName != null && podName.length() > 16 && (p0 = podName.lastIndexOf(45, podName.length() - 16)) > -1) {
            return podName.substring(0, p0);
        }
        return null;
    }

    InputStream resource(String resourcePath, InitialLoader.Source source) {
        InputStream is = null;
        if (source == InitialLoader.Source.RESOURCE) {
            is = this.resourceStream(resourcePath);
            if (is != null) {
                this.loadedResources.add(resourcePath);
            }
        } else {
            File file = new File(resourcePath);
            if (file.exists()) {
                try {
                    is = new FileInputStream(file);
                    this.loadedResources.add("file:" + resourcePath);
                    this.loadedFiles.add(file);
                }
                catch (FileNotFoundException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
        return is;
    }

    private InputStream resourceStream(String resourcePath) {
        InputStream is = this.getClass().getResourceAsStream("/" + resourcePath);
        if (is == null) {
            is = ClassLoader.getSystemResourceAsStream(resourcePath);
        }
        return is;
    }

    void put(String key, String val) {
        if (val != null) {
            val = val.trim();
        }
        this.map.put(key, val);
    }

    Properties evalAll() {
        log.info("loaded properties from {}", (Object)this.loadedResources);
        Properties properties = new Properties();
        for (Map.Entry<String, String> entry : this.map.entrySet()) {
            String key = entry.getKey();
            properties.setProperty(key, this.exprEval.eval(entry.getValue()));
        }
        return properties;
    }

    String indirectLocation() {
        String indirectLocation = this.map.get("load.properties");
        if (indirectLocation == null) {
            indirectLocation = this.map.get("load.properties.override");
        }
        return indirectLocation;
    }

    int size() {
        return this.loadedResources.size();
    }

    String getAppName() {
        String appName = this.map.get("app.name");
        return appName != null ? appName : System.getProperty("app.name");
    }
}

