/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.config;

import io.avaje.config.Configuration;
import io.avaje.config.CoreConfiguration;
import java.math.BigDecimal;
import java.net.URL;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Consumer;

public class Config {
    private static final Configuration data = CoreConfiguration.initialise();

    private Config() {
    }

    public static Properties asProperties() {
        return data.asProperties();
    }

    public static Configuration asConfiguration() {
        return data;
    }

    public static void loadIntoSystemProperties() {
        data.loadIntoSystemProperties();
    }

    public static String get(String key) {
        return data.get(key);
    }

    public static String get(String key, String defaultValue) {
        return data.get(key, defaultValue);
    }

    public static Optional<String> getOptional(String key) {
        return data.getOptional(key);
    }

    public static boolean enabled(String key) {
        return Config.getBool(key);
    }

    public static boolean enabled(String key, boolean enabledDefault) {
        return Config.getBool(key, enabledDefault);
    }

    public static boolean getBool(String key) {
        return data.getBool(key);
    }

    public static boolean getBool(String key, boolean defaultValue) {
        return data.getBool(key, defaultValue);
    }

    public static int getInt(String key) {
        return data.getInt(key);
    }

    public static int getInt(String key, int defaultValue) {
        return data.getInt(key, defaultValue);
    }

    public static long getLong(String key) {
        return data.getLong(key);
    }

    public static long getLong(String key, long defaultValue) {
        return data.getLong(key, defaultValue);
    }

    public static BigDecimal getDecimal(String key) {
        return data.getDecimal(key);
    }

    public static BigDecimal getDecimal(String key, String defaultValue) {
        return data.getDecimal(key, defaultValue);
    }

    public static URL getURL(String key) {
        return data.getURL(key);
    }

    public static URL getURL(String key, String defaultValue) {
        return data.getURL(key, defaultValue);
    }

    public static <T extends Enum<T>> T getEnum(Class<T> type, String key) {
        return data.getEnum(type, key);
    }

    public static <T extends Enum<T>> T getEnum(Class<T> type, String key, T defaultValue) {
        return data.getEnum(type, key, defaultValue);
    }

    public static Configuration.ListValue getList() {
        return data.getList();
    }

    public static Configuration.SetValue getSet() {
        return data.getSet();
    }

    public static void setProperty(String key, String value) {
        data.setProperty(key, value);
    }

    public static void onChange(String key, Consumer<String> callback) {
        data.onChange(key, callback);
    }

    public static void onChangeInt(String key, Consumer<Integer> callback) {
        data.onChangeInt(key, callback);
    }

    public static void onChangeLong(String key, Consumer<Long> callback) {
        data.onChangeLong(key, callback);
    }

    public static void onChangeBool(String key, Consumer<Boolean> callback) {
        data.onChangeBool(key, callback);
    }
}

