/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.classpath.scanner.internal.scanner.classpath.android;

import android.content.res.AssetManager;
import io.avaje.classpath.scanner.Resource;
import io.avaje.classpath.scanner.internal.FileCopyUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.util.List;

class AndroidResource
implements Resource {
    private final AssetManager assetManager;
    private final String path;
    private final String name;

    AndroidResource(AssetManager assetManager, String path, String name) {
        this.assetManager = assetManager;
        this.path = path;
        this.name = name;
    }

    public String toString() {
        return this.location();
    }

    @Override
    public String location() {
        return this.path + "/" + this.name;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public InputStream inputStream() {
        try {
            return this.assetManager.open(this.location());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public List<String> loadAsLines(Charset charset) {
        return FileCopyUtils.readLines(this.inputStream(), charset);
    }

    @Override
    public String loadAsString(Charset charset) {
        return FileCopyUtils.copyToString(this.inputStream(), charset);
    }
}

