/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.classpath.scanner.internal.scanner.classpath;

import io.avaje.classpath.scanner.Resource;
import io.avaje.classpath.scanner.internal.FileCopyUtils;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;

class ClassPathResource
implements Resource {
    private final String location;
    private final ClassLoader classLoader;

    ClassPathResource(String location, ClassLoader classLoader) {
        this.location = location;
        this.classLoader = classLoader;
    }

    public String toString() {
        return this.location;
    }

    @Override
    public String location() {
        return this.location;
    }

    @Override
    public String name() {
        return this.location.substring(this.location.lastIndexOf("/") + 1);
    }

    @Override
    public InputStream inputStream() {
        return this.classLoader.getResourceAsStream(this.location);
    }

    @Override
    public List<String> loadAsLines(Charset charset) {
        return FileCopyUtils.readLines(this.inputStream(), charset);
    }

    @Override
    public String loadAsString(Charset charset) {
        return FileCopyUtils.copyToString(this.inputStream(), charset);
    }
}

