/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.classpath.scanner;

import java.util.function.Predicate;

public class FilterResource {
    public static Predicate<String> byPrefixSuffix(String prefix, String suffix) {
        return new ByPrefixSuffix(prefix, suffix);
    }

    public static Predicate<String> bySuffix(String suffix) {
        return new BySuffix(suffix);
    }

    public static Predicate<String> byPrefix(String prefix) {
        return new ByPrefix(prefix);
    }

    private FilterResource() {
    }

    private static class ByPrefixSuffix
    implements Predicate<String> {
        private final String prefix;
        private final String suffix;

        ByPrefixSuffix(String prefix, String suffix) {
            this.prefix = prefix;
            this.suffix = suffix;
        }

        @Override
        public boolean test(String resourceName) {
            String fileName = resourceName.substring(resourceName.lastIndexOf(47) + 1);
            return fileName.startsWith(this.prefix) && fileName.endsWith(this.suffix);
        }
    }

    private static class BySuffix
    implements Predicate<String> {
        private final String suffix;

        BySuffix(String suffix) {
            this.suffix = suffix;
        }

        @Override
        public boolean test(String resourceName) {
            return resourceName.endsWith(this.suffix);
        }
    }

    private static class ByPrefix
    implements Predicate<String> {
        private final String prefix;

        ByPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public boolean test(String resourceName) {
            return resourceName.startsWith(this.prefix);
        }
    }
}

