/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.util;

import com.gufli.kingdomcraft.api.KingdomCraftProvider;
import com.gufli.kingdomcraft.api.entity.PlatformLocation;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.common.scheduler.AbstractScheduler;
import com.gufli.kingdomcraft.common.scheduler.SchedulerTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

public class Teleporter {
    private static final String TELEPORT_KEY = "teleporter";
    private static AbstractScheduler scheduler;

    public static void register(AbstractScheduler scheduler) {
        Teleporter.scheduler = scheduler;
    }

    public static CompletableFuture<Void> teleport(PlatformPlayer player, PlatformLocation target) {
        int delay = 0;
        if (!player.isAdmin() || !player.hasPermission("kingdom.admin.teleportdelay")) {
            delay = KingdomCraftProvider.get().getConfig().getTeleportDelay();
        }
        return Teleporter.teleport(player, target, delay);
    }

    public static CompletableFuture<Void> teleport(PlatformPlayer player, PlatformLocation target, int delay) {
        if (player.has(TELEPORT_KEY)) {
            player.get(TELEPORT_KEY, SchedulerTask.class).cancel();
        }
        if (delay <= 0) {
            player.teleport(target);
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        KingdomCraftProvider.get().getMessages().send((PlatformSender)player, "teleport", delay + "");
        player.set(TELEPORT_KEY, scheduler.syncLater(() -> {
            player.remove(TELEPORT_KEY);
            player.teleport(target);
            future.complete(null);
        }, delay, TimeUnit.SECONDS));
        return future;
    }

    public static void cancel(PlatformPlayer player) {
        if (player == null || !player.has(TELEPORT_KEY)) {
            return;
        }
        KingdomCraftProvider.get().getMessages().send((PlatformSender)player, "teleportCancel", new String[0]);
        player.get(TELEPORT_KEY, SchedulerTask.class).cancel();
        player.remove(TELEPORT_KEY);
    }
}

