/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.scheduler;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.gufli.kingdomcraft.common.scheduler.SchedulerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public abstract class AbstractScheduler {
    private final ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("kingdomcraft-scheduler").build());
    private final CustomExecutor schedulerWorkerPool;
    private final ForkJoinPool worker;

    public AbstractScheduler() {
        this.scheduler.setRemoveOnCancelPolicy(true);
        this.schedulerWorkerPool = new CustomExecutor(Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("kingdomcraft-schedule-worker-%d").build()));
        this.worker = new ForkJoinPool(32, ForkJoinPool.defaultForkJoinWorkerThreadFactory, (t, e) -> e.printStackTrace(), false);
    }

    public abstract Executor sync();

    public Executor async() {
        return this.worker;
    }

    public final void executeAsync(Runnable task) {
        this.async().execute(task);
    }

    public final void executeSync(Runnable task) {
        this.sync().execute(task);
    }

    public SchedulerTask asyncLater(Runnable task, long delay, TimeUnit unit) {
        ScheduledFuture<?> future = this.scheduler.schedule(() -> this.schedulerWorkerPool.execute(task), delay, unit);
        return () -> future.cancel(false);
    }

    public SchedulerTask asyncRepeating(Runnable task, long interval, TimeUnit unit) {
        ScheduledFuture<?> future = this.scheduler.scheduleAtFixedRate(() -> this.schedulerWorkerPool.execute(task), interval, interval, unit);
        return () -> future.cancel(false);
    }

    public SchedulerTask syncLater(Runnable task, long delay, TimeUnit unit) {
        ScheduledFuture<?> future = this.scheduler.schedule(() -> this.sync().execute(task), delay, unit);
        return () -> future.cancel(false);
    }

    public SchedulerTask syncRepeating(Runnable task, long interval, TimeUnit unit) {
        ScheduledFuture<?> future = this.scheduler.scheduleAtFixedRate(() -> this.sync().execute(task), interval, interval, unit);
        return () -> future.cancel(false);
    }

    public <T> CompletableFuture<T> makeAsyncFuture(Callable<T> supplier) {
        CompletableFuture future = new CompletableFuture();
        this.async().execute(() -> {
            try {
                future.complete(supplier.call());
            }
            catch (Exception ex) {
                future.completeExceptionally(ex);
            }
        });
        return future;
    }

    public CompletableFuture<Void> makeAsyncFuture(Runnable runnable) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.async().execute(() -> {
            try {
                runnable.run();
                future.complete(null);
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    private static final class CustomRunnable
    implements Runnable {
        private final Runnable delegate;

        private CustomRunnable(Runnable delegate) {
            this.delegate = delegate;
        }

        @Override
        public void run() {
            try {
                this.delegate.run();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static final class CustomExecutor
    implements Executor {
        private final ExecutorService delegate;

        private CustomExecutor(ExecutorService delegate) {
            this.delegate = delegate;
        }

        @Override
        public void execute(Runnable command) {
            this.delegate.execute(new CustomRunnable(command));
        }
    }
}

