/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.placeholders;

import com.gufli.kingdomcraft.api.domain.User;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.placeholders.PlaceholderManager;
import com.gufli.kingdomcraft.api.placeholders.PlaceholderReplacer;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.placeholders.DefaultPlaceholderReplacer;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PlaceholderManagerImpl
implements PlaceholderManager {
    private final Map<String, PlaceholderReplacer> placeholderReplacers = new HashMap<String, PlaceholderReplacer>();

    public PlaceholderManagerImpl(KingdomCraftImpl kdc) {
        new DefaultPlaceholderReplacer(kdc, this);
    }

    @Override
    public void addPlaceholderReplacer(PlaceholderReplacer placeholderReplacer, String ... placeholders) {
        for (String placeholder : placeholders) {
            this.placeholderReplacers.put(placeholder.toLowerCase(), placeholderReplacer);
        }
    }

    @Override
    public void removePlaceholderReplacer(PlaceholderReplacer placeholderReplacer) {
        this.placeholderReplacers.entrySet().removeIf(pr -> pr.getValue() == placeholderReplacer);
    }

    @Override
    public void removePlaceholderReplacer(String placeholder) {
        this.placeholderReplacers.remove(placeholder);
    }

    @Override
    public String handle(PlatformPlayer player, String str) {
        return this.handle(player, str, "");
    }

    @Override
    public String handle(PlatformPlayer player, String str, String prefix) {
        return this.handle(player.getUser(), str, prefix);
    }

    @Override
    public String handle(User user, String str) {
        return this.handle(user, str, "");
    }

    @Override
    public String handle(User user, String str, String prefix) {
        if (str == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        Pattern p = Pattern.compile("(\\{[^}]+\\})");
        Matcher m3 = p.matcher(str);
        while (m3.find()) {
            PlaceholderReplacer replacer;
            String placeholder = m3.group(1).toLowerCase();
            if (!(placeholder = placeholder.substring(1, placeholder.length() - 1)).startsWith(prefix) || (replacer = this.placeholderReplacers.get(placeholder = placeholder.replaceFirst(Pattern.quote(prefix), ""))) == null) continue;
            String replacement = replacer.replace(user, placeholder);
            if (replacement == null) {
                replacement = "";
            }
            m3.appendReplacement(sb, replacement);
        }
        m3.appendTail(sb);
        return sb.toString();
    }

    @Override
    public String strip(String str, String ... ignore) {
        StringBuffer sb = new StringBuffer();
        Pattern p = Pattern.compile("(\\{[^}]+\\})");
        Matcher m3 = p.matcher(str);
        block0: while (m3.find()) {
            String placeholder = m3.group(1);
            placeholder = placeholder.substring(1, placeholder.length() - 1);
            for (String s2 : ignore) {
                if (!placeholder.equalsIgnoreCase(s2)) continue;
                m3.appendReplacement(sb, "{" + placeholder + "}");
                continue block0;
            }
            m3.appendReplacement(sb, "");
        }
        m3.appendTail(sb);
        return sb.toString();
    }
}

