/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.placeholders;

import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.placeholders.PlaceholderManager;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;

public class DefaultPlaceholderReplacer {
    public DefaultPlaceholderReplacer(KingdomCraftImpl kdc, PlaceholderManager pm) {
        pm.addPlaceholderReplacer((user, placeholder) -> user.getName(), "user", "username");
        pm.addPlaceholderReplacer((user, placeholder) -> {
            if (user.getKingdom() != null) {
                return user.getKingdom().getDisplay();
            }
            PlatformPlayer pp = kdc.getPlayer(user);
            if (pp != null && pp.hasPermission("kingdom.placeholders.empty-no-kingdom")) {
                return null;
            }
            return kdc.getConfig().getNoKingdomDisplay();
        }, "kingdom");
        pm.addPlaceholderReplacer((user, placeholder) -> user.getKingdom() != null ? user.getKingdom().getName() : "", "kingdom_name");
        pm.addPlaceholderReplacer((user, placeholder) -> user.getRank() != null ? user.getRank().getDisplay() : "", "rank");
        pm.addPlaceholderReplacer((user, placeholder) -> user.getRank() != null ? user.getRank().getName() : "", "rank_name");
        pm.addPlaceholderReplacer((user, placeholder) -> {
            if (user.getKingdom() != null) {
                return user.getKingdom().getPrefix();
            }
            PlatformPlayer pp = kdc.getPlayer(user);
            if (pp != null && pp.hasPermission("kingdom.placeholders.empty-no-kingdom")) {
                return null;
            }
            return kdc.getConfig().getNoKingdomPrefix();
        }, "kingdom_prefix");
        pm.addPlaceholderReplacer((user, placeholder) -> {
            if (user.getKingdom() != null) {
                return user.getKingdom().getSuffix();
            }
            PlatformPlayer pp = kdc.getPlayer(user);
            if (pp != null && pp.hasPermission("kingdom.placeholders.empty-no-kingdom")) {
                return null;
            }
            return kdc.getConfig().getNoKingdomSuffix();
        }, "kingdom_suffix");
        pm.addPlaceholderReplacer((user, placeholder) -> user.getRank() != null ? user.getRank().getPrefix() : "", "rank_prefix");
        pm.addPlaceholderReplacer((user, placeholder) -> user.getRank() != null ? user.getRank().getSuffix() : "", "rank_suffix");
        pm.addPlaceholderReplacer((user, placeholder) -> {
            if (user.getKingdom() == null) {
                return "";
            }
            return user.getKingdom().getMemberCount() + "";
        }, "kingdom_member_count");
        pm.addPlaceholderReplacer((user, placeholder) -> {
            if (user.getKingdom() == null) {
                return "";
            }
            return kdc.getOnlineUsers().stream().filter(u -> u.getKingdom() == user.getKingdom()).count() + "";
        }, "kingdom_online_member_count");
        pm.addPlaceholderReplacer((user, placeholder) -> {
            if (user.getKingdom() == null || user.getRank() == null) {
                return "";
            }
            return user.getRank().getMemberCount() + "";
        }, "rank_member_count");
        pm.addPlaceholderReplacer((user, placeholder) -> {
            if (user.getKingdom() == null || user.getRank() == null) {
                return "";
            }
            return kdc.getOnlineUsers().stream().filter(u -> u.getRank() == user.getRank()).count() + "";
        }, "rank_online_member_count");
    }
}

