/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.permissions;

import com.gufli.kingdomcraft.api.domain.Rank;
import com.gufli.kingdomcraft.api.domain.RankPermissionGroup;
import com.gufli.kingdomcraft.api.domain.User;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.config.Configuration;
import com.gufli.kingdomcraft.common.permissions.PermissionGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class PermissionManager {
    private final KingdomCraftImpl kdc;
    private final List<PermissionGroup> groups = new ArrayList<PermissionGroup>();
    private PermissionGroup defaultGroup;

    public PermissionManager(KingdomCraftImpl kdc) {
        this.kdc = kdc;
    }

    public void addPermissionGroup(PermissionGroup group) {
        if (this.groups.contains(group)) {
            return;
        }
        this.groups.add(group);
    }

    public void removePermissionGroup(PermissionGroup group) {
        this.groups.remove(group);
    }

    public PermissionGroup getGroup(String name) {
        return this.groups.stream().filter(g2 -> g2.getName().equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    public List<PermissionGroup> getGroups(Rank rank) {
        return this.getGroups().stream().filter(group -> {
            RankPermissionGroup rpg = rank.getPermissionGroup(group.getName());
            return rpg != null || !group.getRanks().isEmpty() && group.getRanks().stream().anyMatch(r -> r.equalsIgnoreCase(rank.getName()));
        }).collect(Collectors.toList());
    }

    public List<PermissionGroup> getGroups(Rank rank, String world) {
        return this.getGroups(rank).stream().filter(group -> group.getWorlds().isEmpty() || group.getWorlds().stream().anyMatch(w -> w.equalsIgnoreCase(world))).collect(Collectors.toList());
    }

    public List<PermissionGroup> getGroups() {
        return new ArrayList<PermissionGroup>(this.groups);
    }

    public PermissionGroup getDefaultGroup() {
        return this.defaultGroup;
    }

    public List<PermissionGroup> getGroups(PlatformPlayer player) {
        User user = this.kdc.getUser(player);
        ArrayList<PermissionGroup> groups = new ArrayList<PermissionGroup>();
        if (user.getRank() == null) {
            if (this.defaultGroup != null) {
                groups.add(this.defaultGroup);
            }
        } else {
            groups.addAll(this.getGroups(user.getRank(), player.getLocation().getWorldName()));
        }
        return groups;
    }

    public Map<String, Boolean> getTotalPermissions(PermissionGroup group) {
        Map<String, Boolean> perms = group.getPermissionsAsMap();
        this.fillPermissionsMap(group, new ArrayList<String>(), perms);
        return perms;
    }

    public Map<String, Boolean> getTotalPermissions(PlatformPlayer player) {
        List<PermissionGroup> groups = this.getGroups(player);
        HashMap<String, Boolean> permissions = new HashMap<String, Boolean>();
        groups.forEach(group -> permissions.putAll(this.getTotalPermissions((PermissionGroup)group)));
        return permissions;
    }

    private void fillPermissionsMap(PermissionGroup group, List<String> passed, Map<String, Boolean> perms) {
        perms.putAll(group.getPermissionsAsMap());
        passed.add(group.getName());
        for (String inheritance : group.getInheritances()) {
            PermissionGroup g2;
            if (passed.contains(inheritance) || (g2 = this.getGroup(inheritance)) == null) continue;
            this.fillPermissionsMap(g2, passed, perms);
        }
    }

    public void load(Configuration config) {
        this.groups.clear();
        Iterator<String> iterator = config.getKeys(false).iterator();
        while (iterator.hasNext()) {
            String key;
            Configuration cs = config.getConfigurationSection(key = iterator.next());
            PermissionGroup group = new PermissionGroup(key, cs.contains("permissions") ? cs.getStringList("permissions") : new ArrayList(), cs.contains("inheritances") ? cs.getStringList("inheritances") : new ArrayList(), cs.contains("ranks") ? cs.getStringList("ranks") : new ArrayList(), cs.contains("worlds") ? cs.getStringList("worlds") : new ArrayList(), cs.contains("externals") ? cs.getStringList("externals") : new ArrayList());
            if (key.equalsIgnoreCase("default")) {
                this.defaultGroup = group;
                continue;
            }
            this.addPermissionGroup(group);
        }
    }
}

