/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.permissions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PermissionGroup {
    private final String name;
    private final List<String> permissions;
    private final List<String> inheritances;
    private final List<String> ranks;
    private final List<String> worlds;
    private final List<String> externals;

    public PermissionGroup(String name, List<String> permissions, List<String> inheritances, List<String> ranks, List<String> worlds, List<String> externals) {
        this.name = name;
        this.worlds = worlds;
        this.permissions = permissions;
        this.inheritances = inheritances;
        this.ranks = ranks;
        this.externals = externals;
    }

    public PermissionGroup(String name, List<String> permissions, List<String> inheritances, List<String> ranks, List<String> worlds) {
        this(name, permissions, inheritances, ranks, worlds, new ArrayList<String>());
    }

    public PermissionGroup(String name, List<String> permissions, List<String> inheritances, List<String> ranks) {
        this(name, permissions, inheritances, ranks, new ArrayList<String>(), new ArrayList<String>());
    }

    public PermissionGroup(String name, List<String> permissions, List<String> inheritances) {
        this(name, permissions, inheritances, new ArrayList<String>(), new ArrayList<String>(), new ArrayList<String>());
    }

    public String getName() {
        return this.name;
    }

    public List<String> getWorlds() {
        return this.worlds;
    }

    public List<String> getPermissions() {
        return this.permissions;
    }

    public List<String> getRanks() {
        return this.ranks;
    }

    public Map<String, Boolean> getPermissionsAsMap() {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        this.permissions.forEach(s2 -> map.put((String)s2, !s2.startsWith("-")));
        return map;
    }

    public List<String> getInheritances() {
        return this.inheritances;
    }

    public List<String> getExternals() {
        return this.externals;
    }
}

