/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.messages;

import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.api.language.Messages;
import com.gufli.kingdomcraft.common.KingdomCraftPlugin;
import com.gufli.kingdomcraft.common.config.Configuration;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.text.StringEscapeUtils;

public class MessagesImpl
implements Messages {
    private final KingdomCraftPlugin plugin;
    private String prefix = "&6KingdomCraft &2> &a";
    private final Map<String, String> messages = new HashMap<String, String>();

    public MessagesImpl(KingdomCraftPlugin plugin) {
        this.plugin = plugin;
    }

    public void setMessages(Configuration ... configs) {
        for (Configuration config : configs) {
            for (String key : config.getKeys(false)) {
                this.messages.put(key, config.getString(key));
            }
        }
    }

    @Override
    public final String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public String getMessage(String name) {
        if (name == null) {
            return null;
        }
        String msg = this.messages.get(name);
        if (msg == null) {
            return null;
        }
        return this.colorify(StringEscapeUtils.unescapeJava(msg));
    }

    @Override
    public String getMessage(String name, boolean colorify, String ... placeholders) {
        if (colorify) {
            String msg = this.getMessage(name, placeholders);
            if (msg == null) {
                return null;
            }
            return this.colorify(msg);
        }
        return this.getMessage(name, placeholders);
    }

    @Override
    public String getMessage(String name, String ... placeholders) {
        String message = this.getMessage(name);
        if (message == null) {
            return null;
        }
        for (int i = 0; i < placeholders.length; ++i) {
            message = message.replace("{" + i + "}", placeholders[i] == null ? "" : placeholders[i]);
        }
        return message;
    }

    private boolean isEmpty(String name) {
        return this.messages.containsKey(name) && this.messages.get(name).trim().equals("");
    }

    @Override
    public void send(PlatformSender sender, String name, String ... placeholders) {
        if (this.isEmpty(name)) {
            return;
        }
        sender.sendMessage(this.colorify(this.prefix) + this.getMessage(name, placeholders));
    }

    @Override
    public void send(PlatformSender sender, String name, boolean colorify, String ... placeholders) {
        if (this.isEmpty(name)) {
            return;
        }
        sender.sendMessage(this.colorify(this.prefix) + this.getMessage(name, colorify, placeholders));
    }

    @Override
    public String colorify(String msg) {
        return this.plugin.colorify(msg);
    }

    @Override
    public String decolorify(String msg) {
        return this.plugin.decolorify(msg);
    }
}

