/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.event;

import com.gufli.kingdomcraft.api.event.EventManager;
import com.gufli.kingdomcraft.api.events.Event;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class EventManagerImpl
implements EventManager {
    private final List<EventSubscription<?>> executors = new CopyOnWriteArrayList();

    public <T extends Event> EventSubscription<T> addListener(Class<T> type, Consumer<T> consumer) {
        EventSubscription executor = new EventSubscription(type, consumer);
        this.executors.add(executor);
        return executor;
    }

    public <T extends Event> EventSubscription<T> addListener(Class<T> type, BiConsumer<com.gufli.kingdomcraft.api.event.EventSubscription<T>, T> consumer) {
        EventSubscription executor = new EventSubscription(type, consumer);
        this.executors.add(executor);
        return executor;
    }

    @Override
    public <T extends Event> void dispatch(T event) {
        for (EventSubscription<?> exe : new ArrayList(this.executors)) {
            if (!((EventSubscription)exe).type.isAssignableFrom(event.getClass())) continue;
            try {
                ((EventSubscription)exe).consumer.accept(exe, event);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            try {
                if (!this.executors.contains(exe) || !((EventSubscription)exe).shouldUnregister(event)) continue;
                this.executors.remove(exe);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public class EventSubscription<T extends Event>
    implements com.gufli.kingdomcraft.api.event.EventSubscription<T> {
        private final Class<T> type;
        private final BiConsumer<com.gufli.kingdomcraft.api.event.EventSubscription<T>, T> consumer;
        private Function<T, Boolean> unregisterTest;

        private EventSubscription(Class<T> type, BiConsumer<com.gufli.kingdomcraft.api.event.EventSubscription<T>, T> consumer) {
            this.type = type;
            this.consumer = consumer;
        }

        private EventSubscription(Class<T> type, Consumer<T> consumer) {
            this(type, (com.gufli.kingdomcraft.api.event.EventSubscription<T> ignored, T event) -> consumer.accept(event));
        }

        @Override
        public void unregister() {
            EventManagerImpl.this.executors.remove(this);
        }

        @Override
        public EventSubscription<T> unregisterIf(Supplier<Boolean> test) {
            this.unregisterIf((T ignored) -> (Boolean)test.get());
            return this;
        }

        @Override
        public EventSubscription<T> unregisterIf(Function<T, Boolean> test) {
            this.unregisterTest = test;
            return this;
        }

        private boolean shouldUnregister(T event) {
            if (this.unregisterTest != null) {
                return this.unregisterTest.apply(event);
            }
            return false;
        }
    }
}

