/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.editor;

import com.gufli.kingdomcraft.api.domain.Kingdom;
import com.gufli.kingdomcraft.api.domain.KingdomAttribute;
import com.gufli.kingdomcraft.api.domain.Rank;
import com.gufli.kingdomcraft.api.domain.RankAttribute;
import com.gufli.kingdomcraft.api.editor.EditorAttribute;
import com.gufli.kingdomcraft.common.editor.EditorImpl;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class ModelSerializer {
    private final EditorImpl editor;

    ModelSerializer(EditorImpl editor) {
        this.editor = editor;
    }

    public Map<String, String> serialize(EditorAttribute attribute) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("key", attribute.key());
        map.put("display", attribute.display());
        map.put("group", attribute.group());
        map.put("helpLink", attribute.helpLink());
        map.put("type", attribute.type().name());
        return map;
    }

    public Map<String, Object> serialize(Kingdom kingdom) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", kingdom.getName());
        map.put("display", kingdom.getDisplay());
        map.put("prefix", kingdom.getPrefix());
        map.put("suffix", kingdom.getSuffix());
        map.put("defaultrank", kingdom.getDefaultRank() != null ? kingdom.getDefaultRank().getName() : "");
        map.put("max-members", kingdom.getMaxMembers());
        map.put("invite-only", kingdom.isInviteOnly());
        new HashSet(map.keySet()).stream().filter(key -> map.get(key).equals("")).forEach(map::remove);
        if (!this.editor.kingdomAttributes.isEmpty()) {
            HashMap<String, String> attributes = new HashMap<String, String>();
            for (EditorAttribute attribute : this.editor.kingdomAttributes) {
                KingdomAttribute ka = kingdom.getAttribute(attribute.key());
                if (ka != null) {
                    attributes.put(attribute.key(), ka.getValue());
                    continue;
                }
                attributes.put(attribute.key(), "");
            }
            map.put("attributes", attributes);
        }
        HashMap ranks = new HashMap();
        kingdom.getRanks().forEach(rank -> ranks.put(rank.getName(), this.serialize((Rank)rank)));
        if (!ranks.isEmpty()) {
            map.put("ranks", ranks);
        }
        return map;
    }

    private Map<String, Object> serialize(Rank rank) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("display", rank.getDisplay());
        map.put("prefix", rank.getPrefix());
        map.put("suffix", rank.getSuffix());
        map.put("max-members", rank.getMaxMembers());
        map.put("level", rank.getLevel());
        new HashSet(map.keySet()).stream().filter(key -> map.get(key).equals("")).forEach(map::remove);
        if (!this.editor.rankAttributes.isEmpty()) {
            HashMap<String, String> attributes = new HashMap<String, String>();
            for (EditorAttribute attribute : this.editor.rankAttributes) {
                RankAttribute ra = rank.getAttribute(attribute.key());
                if (ra != null) {
                    attributes.put(attribute.key(), ra.getValue());
                    continue;
                }
                attributes.put(attribute.key(), "");
            }
            map.put("attributes", attributes);
        }
        return map;
    }
}

