/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.editor;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.gufli.kingdomcraft.api.domain.Attribute;
import com.gufli.kingdomcraft.api.domain.AttributeHolder;
import com.gufli.kingdomcraft.api.domain.Kingdom;
import com.gufli.kingdomcraft.api.domain.Model;
import com.gufli.kingdomcraft.api.domain.Rank;
import com.gufli.kingdomcraft.api.editor.EditorAttribute;
import com.gufli.kingdomcraft.common.editor.EditorImpl;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ModelDeserializer {
    private final ObjectMapper mapper = new ObjectMapper();
    private final EditorImpl editor;

    ModelDeserializer(EditorImpl editor) {
        this.editor = editor;
    }

    private void deserialize(AttributeHolder holder, List<EditorAttribute> attributes, JsonNode node) {
        for (EditorAttribute attribute : attributes) {
            String value;
            if (!node.has(attribute.key()) || (value = node.get(attribute.key()).asText()) == null || !attribute.validate(value)) continue;
            Attribute a = holder.getAttribute(attribute.key());
            if (a == null) {
                a = holder.createAttribute(attribute.key());
            } else if (a.getValue().equals(value)) continue;
            a.setValue(value);
            a.save();
        }
    }

    public void deserialize(Kingdom kingdom, JsonNode node) {
        Rank rank;
        Object ranks;
        ObjectReader reader;
        if (node.has("display") && !kingdom.getDisplay().equals(node.get("display").asText())) {
            kingdom.setDisplay(node.get("display").asText());
        }
        if (node.has("prefix") && !kingdom.getPrefix().equals(node.get("prefix").asText())) {
            kingdom.setPrefix(node.get("prefix").asText());
        }
        if (node.has("suffix") && !kingdom.getSuffix().equals(node.get("suffix").asText())) {
            kingdom.setSuffix(node.get("suffix").asText());
        }
        if (node.has("max-members") && kingdom.getMaxMembers() != node.get("max-members").asInt()) {
            kingdom.setMaxMembers(node.get("max-members").asInt());
        }
        if (node.has("invite-only") && kingdom.isInviteOnly() != node.get("invite-only").asBoolean()) {
            kingdom.setInviteOnly(node.get("invite-only").asBoolean());
        }
        kingdom.save();
        if (node.has("deleted_ranks")) {
            reader = this.mapper.readerFor(new TypeReference<List<String>>(){});
            try {
                ranks = (List)reader.readValue(node.get("deleted_ranks"));
                ranks.stream().map(kingdom::getRank).filter(Objects::nonNull).forEach(Model::delete);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        if (node.has("ranks")) {
            reader = this.mapper.readerFor(new TypeReference<Map<String, JsonNode>>(){});
            try {
                ranks = (Map)reader.readValue(node.get("ranks"));
                for (String rankname : ranks.keySet()) {
                    Rank rank2 = kingdom.getRank(rankname);
                    if (rank2 == null) {
                        rank2 = kingdom.createRank(rankname);
                        rank2.save();
                    }
                    this.deserialize(rank2, (JsonNode)ranks.get(rankname));
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        if (node.has("defaultrank") && (rank = kingdom.getRank(node.get("defaultrank").asText())) != kingdom.getDefaultRank()) {
            kingdom.setDefaultRank(rank);
            kingdom.save();
        }
        if (node.has("attributes")) {
            this.deserialize(kingdom, this.editor.kingdomAttributes, node.get("attributes"));
        }
    }

    private void deserialize(Rank rank, JsonNode node) {
        if (node.has("display") && !rank.getDisplay().equals(node.get("display").asText())) {
            rank.setDisplay(node.get("display").asText());
        }
        if (node.has("prefix") && !rank.getPrefix().equals(node.get("prefix").asText())) {
            rank.setPrefix(node.get("prefix").asText());
        }
        if (node.has("suffix") && !rank.getSuffix().equals(node.get("suffix").asText())) {
            rank.setSuffix(node.get("suffix").asText());
        }
        if (node.has("max-members") && rank.getMaxMembers() != node.get("max-members").asInt()) {
            rank.setMaxMembers(node.get("max-members").asInt());
        }
        if (node.has("level") && rank.getLevel() != node.get("level").asInt()) {
            rank.setLevel(node.get("level").asInt());
        }
        rank.save();
        if (node.has("attributes")) {
            this.deserialize(rank, this.editor.rankAttributes, node.get("attributes"));
        }
    }
}

