/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.editor;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.gufli.kingdomcraft.api.domain.Kingdom;
import com.gufli.kingdomcraft.api.domain.Model;
import com.gufli.kingdomcraft.api.editor.Editor;
import com.gufli.kingdomcraft.api.editor.EditorAttribute;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.api.events.EditorSaveEvent;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.editor.ModelDeserializer;
import com.gufli.kingdomcraft.common.editor.ModelSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.http.client.methods.CloseableHttpResponse;

public class EditorImpl
implements Editor {
    private static final String editorUrl = "https://webeditor.kingdomcraft.be/";
    private static final String uploadUrl = "https://bytebin.kingdomcraft.be/";
    private static final String fetchUrl = "https://bytebin.kingdomcraft.be/";
    final KingdomCraftImpl kdc;
    final List<EditorAttribute> kingdomAttributes = new CopyOnWriteArrayList<EditorAttribute>();
    final List<EditorAttribute> rankAttributes = new CopyOnWriteArrayList<EditorAttribute>();
    private final ModelSerializer serializer = new ModelSerializer(this);
    private final ModelDeserializer deserializer = new ModelDeserializer(this);

    public EditorImpl(KingdomCraftImpl kdc) {
        this.kdc = kdc;
    }

    @Override
    public void addKingdomAttribute(EditorAttribute attribute) {
        if (this.kingdomAttributes.contains(attribute)) {
            return;
        }
        this.kingdomAttributes.add(attribute);
    }

    @Override
    public void removeKingdomAttribute(EditorAttribute attribute) {
        this.kingdomAttributes.remove(attribute);
    }

    @Override
    public void addRankAttribute(EditorAttribute attribute) {
        if (this.rankAttributes.contains(attribute)) {
            return;
        }
        this.rankAttributes.add(attribute);
    }

    @Override
    public void removeRankAttribute(EditorAttribute attribute) {
        this.rankAttributes.remove(attribute);
    }

    public void startSession(PlatformSender sender) {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode node = mapper.createObjectNode();
        HashMap kingdoms = new HashMap();
        this.kdc.getKingdoms(true).forEach(kingdom -> kingdoms.put(kingdom.getName(), this.serializer.serialize((Kingdom)kingdom)));
        node.set("kingdoms", (JsonNode)mapper.valueToTree(kingdoms));
        HashMap kingdomAttributes = new HashMap();
        this.kingdomAttributes.forEach(attribute -> kingdomAttributes.put(attribute.key(), this.serializer.serialize((EditorAttribute)attribute)));
        node.set("kingdomAttributes", (JsonNode)mapper.valueToTree(kingdomAttributes));
        HashMap rankAttributes = new HashMap();
        this.rankAttributes.forEach(attribute -> rankAttributes.put(attribute.key(), this.serializer.serialize((EditorAttribute)attribute)));
        node.set("rankAttributes", (JsonNode)mapper.valueToTree(rankAttributes));
        try {
            String result = this.upload(mapper.writeValueAsString(node));
            JsonNode resultNode = mapper.readTree(result);
            this.kdc.getMessages().send(sender, "cmdEditorStarted", editorUrl + resultNode.get("key").asText());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.kdc.getMessages().send(sender, "cmdEditorErrorUpload", new String[0]);
        }
    }

    public void finish(PlatformSender sender, String resultKey) {
        JsonNode json;
        ObjectMapper mapper = new ObjectMapper();
        try {
            String result = this.fetch(resultKey);
            json = mapper.readTree(result);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            this.kdc.getMessages().send(sender, "cmdEditorErrorFormat", new String[0]);
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            this.kdc.getMessages().send(sender, "cmdEditorErrorDownload", new String[0]);
            return;
        }
        try {
            Object kingdoms;
            ObjectReader reader;
            if (json.has("deleted_kingdoms")) {
                reader = mapper.readerFor(new TypeReference<List<String>>(){});
                kingdoms = (List)reader.readValue(json.get("deleted_kingdoms"));
                kingdoms.stream().map(this.kdc::getKingdom).filter(Objects::nonNull).forEach(Model::delete);
            }
            if (!json.has("kingdoms")) {
                this.kdc.getMessages().send(sender, "cmdEditorErrorFormat", new String[0]);
                return;
            }
            reader = mapper.readerFor(new TypeReference<Map<String, JsonNode>>(){});
            kingdoms = (Map)reader.readValue(json.get("kingdoms"));
            for (String key : kingdoms.keySet()) {
                Kingdom kingdom = this.kdc.getKingdom(key = key.replace(" ", ""));
                if (kingdom == null) {
                    kingdom = this.kdc.createKingdom(key).get();
                }
                this.deserializer.deserialize(kingdom, (JsonNode)kingdoms.get(key));
            }
            this.kdc.getEventManager().dispatch(new EditorSaveEvent());
            this.kdc.getMessages().send(sender, "cmdEditorSaved", new String[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.kdc.getMessages().send(sender, "cmdEditorErrorSave", new String[0]);
        }
    }

    /*
     * Exception decompiling
     */
    private String upload(String contents) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private String fetch(String key) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private String parseResults(CloseableHttpResponse response) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

