/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.ebean.beans;

import com.gufli.kingdomcraft.api.KingdomCraftProvider;
import com.gufli.kingdomcraft.api.domain.Attribute;
import com.gufli.kingdomcraft.api.domain.Kingdom;
import com.gufli.kingdomcraft.api.domain.KingdomInvite;
import com.gufli.kingdomcraft.api.domain.Rank;
import com.gufli.kingdomcraft.api.domain.User;
import com.gufli.kingdomcraft.api.domain.UserChatChannel;
import com.gufli.kingdomcraft.api.events.UserJoinKingdomEvent;
import com.gufli.kingdomcraft.api.events.UserLeaveKingdomEvent;
import com.gufli.kingdomcraft.api.events.UserRankChangeEvent;
import com.gufli.kingdomcraft.common.ebean.beans.BKingdom;
import com.gufli.kingdomcraft.common.ebean.beans.BKingdomInvite;
import com.gufli.kingdomcraft.common.ebean.beans.BRank;
import com.gufli.kingdomcraft.common.ebean.beans.BUserAttribute;
import com.gufli.kingdomcraft.common.ebean.beans.BUserChatChannel;
import com.gufli.kingdomcraft.common.ebean.beans.BaseModel;
import io.ebean.annotation.ConstraintMode;
import io.ebean.annotation.DbDefault;
import io.ebean.annotation.DbForeignKey;
import io.ebean.annotation.WhenCreated;
import io.ebean.annotation.WhenModified;
import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import io.ebean.common.BeanList;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;

@Entity
@Table(name="users")
public class BUser
extends BaseModel
implements User,
EntityBean {
    @Id
    public String id;
    @Column(unique=true)
    public String name;
    @ManyToOne
    @DbForeignKey(onDelete=ConstraintMode.SET_NULL)
    public BRank rank;
    @ManyToOne
    @DbForeignKey(onDelete=ConstraintMode.SET_NULL)
    public BKingdom kingdom;
    public Instant joinedKingdomAt;
    public Instant lastOnlineAt;
    @OneToMany(mappedBy="user", fetch=FetchType.EAGER)
    public List<BKingdomInvite> kingdomInvites;
    @OneToMany(mappedBy="user", fetch=FetchType.EAGER)
    public List<BUserChatChannel> chatChannels;
    @DbDefault(value="false")
    public boolean adminModeEnabled;
    @DbDefault(value="false")
    public boolean socialSpyEnabled;
    @OneToMany(mappedBy="user", fetch=FetchType.EAGER)
    public List<BUserAttribute> attributes;
    @WhenCreated
    public Instant createdAt;
    @WhenModified
    public Instant updatedAt;
    private static /* synthetic */ String _EBEAN_MARKER = "com.gufli.kingdomcraft.common.ebean.beans.BUser";
    public static /* synthetic */ String[] _ebean_props;
    protected /* synthetic */ EntityBeanIntercept _ebean_intercept;
    protected transient /* synthetic */ Object _ebean_identity;

    public BUser() {
        this._ebean_intercept = new EntityBeanIntercept(this);
    }

    @Override
    public boolean delete() {
        return super.delete();
    }

    @Override
    public void save() {
        super.save();
    }

    public void setName(String name) {
        this._ebean_set_name(name);
    }

    public void setUUID(UUID uuid) {
        this._ebean_set_id(uuid.toString());
    }

    @Override
    public UUID getUniqueId() {
        return UUID.fromString(this._ebean_get_id());
    }

    @Override
    public String getName() {
        return this._ebean_get_name();
    }

    @Override
    public Rank getRank() {
        return this._ebean_get_rank();
    }

    @Override
    public Kingdom getKingdom() {
        return this._ebean_get_kingdom();
    }

    @Override
    public void setKingdom(Kingdom kingdom) {
        if (kingdom == this._ebean_get_kingdom()) {
            return;
        }
        if (this._ebean_get_kingdom() != null) {
            --this._ebean_get_kingdom().memberCount;
        }
        if (this._ebean_get_rank() != null) {
            --this._ebean_get_rank().memberCount;
        }
        BKingdom oldKingdom = this._ebean_get_kingdom();
        if (kingdom == null) {
            this._ebean_set_kingdom(null);
            this._ebean_set_rank(null);
            KingdomCraftProvider.get().getEventManager().dispatch(new UserLeaveKingdomEvent(this, oldKingdom));
            return;
        }
        this._ebean_set_kingdom((BKingdom)kingdom);
        ++this._ebean_get_kingdom().memberCount;
        this._ebean_set_joinedKingdomAt(Instant.now());
        if (kingdom.getDefaultRank() != null) {
            this._ebean_set_rank((BRank)kingdom.getDefaultRank());
            ++this._ebean_get_rank().memberCount;
        } else {
            this._ebean_set_rank(null);
        }
        if (oldKingdom != null) {
            KingdomCraftProvider.get().getEventManager().dispatch(new UserLeaveKingdomEvent(this, oldKingdom));
        }
        KingdomCraftProvider.get().getEventManager().dispatch(new UserJoinKingdomEvent(this));
    }

    @Override
    public void setRank(Rank rank) {
        if (rank == this._ebean_get_rank()) {
            return;
        }
        if (rank != null && !rank.getKingdom().equals(this._ebean_get_kingdom())) {
            throw new IllegalArgumentException("The given rank does not belong to the user their kingdom.");
        }
        if (this._ebean_get_rank() != null) {
            --this._ebean_get_rank().memberCount;
        }
        BRank oldRank = this._ebean_get_rank();
        if (rank == null) {
            this._ebean_set_rank(null);
        } else {
            this._ebean_set_rank((BRank)rank);
            ++this._ebean_get_rank().memberCount;
        }
        KingdomCraftProvider.get().getEventManager().dispatch(new UserRankChangeEvent(this, oldRank));
    }

    @Override
    public List<KingdomInvite> getInvites() {
        return new ArrayList<KingdomInvite>(this._ebean_get_kingdomInvites());
    }

    @Override
    public KingdomInvite getInvite(Kingdom kingdom) {
        return this._ebean_get_kingdomInvites().stream().filter(ki -> ki.kingdom == kingdom).findFirst().orElse(null);
    }

    @Override
    public KingdomInvite addInvite(User sender) {
        if (sender.getKingdom() == null) {
            throw new IllegalArgumentException("Cannot add an invite from a player without a kingdom.");
        }
        BKingdomInvite invite = new BKingdomInvite();
        invite.kingdom = (BKingdom)sender.getKingdom();
        invite.sender = (BUser)sender;
        invite.user = this;
        this._ebean_get_kingdomInvites().add(invite);
        return invite;
    }

    @Override
    public void clearInvites() {
        this.db().deleteAll(this._ebean_get_kingdomInvites());
        this._ebean_get_kingdomInvites().clear();
    }

    @Override
    public UserChatChannel addChatChannel(String channel) {
        BUserChatChannel ucc = (BUserChatChannel)this.getChatChannel(channel);
        if (ucc != null) {
            return ucc;
        }
        ucc = new BUserChatChannel();
        ucc.user = this;
        ucc.channel = channel;
        this._ebean_get_chatChannels().add(ucc);
        return ucc;
    }

    @Override
    public UserChatChannel getChatChannel(String channel) {
        return this._ebean_get_chatChannels().stream().filter(cs -> cs.channel.endsWith(channel)).findFirst().orElse(null);
    }

    @Override
    public boolean isAdminModeEnabled() {
        return this._ebean_get_adminModeEnabled();
    }

    @Override
    public void setAdminModeEnabled(boolean adminMode) {
        this._ebean_set_adminModeEnabled(adminMode);
    }

    @Override
    public boolean isSocialSpyEnabled() {
        return this._ebean_get_socialSpyEnabled();
    }

    @Override
    public void setSocialSpyEnabled(boolean socialSpy) {
        this._ebean_set_socialSpyEnabled(socialSpy);
    }

    @Override
    public Instant getJoinedKingdomAt() {
        return this._ebean_get_joinedKingdomAt();
    }

    @Override
    public Instant getLastOnlineAt() {
        return this._ebean_get_lastOnlineAt();
    }

    @Override
    public void setLastOnlineAt(Instant lastOnlineAt) {
        this._ebean_set_lastOnlineAt(lastOnlineAt);
    }

    @Override
    public Instant getCreatedAt() {
        return this._ebean_get_createdAt();
    }

    @Override
    public Instant getUpdatedAt() {
        return this._ebean_get_updatedAt();
    }

    @Override
    public Attribute getAttribute(String name) {
        return this._ebean_get_attributes().stream().filter(p -> p.getName().equals(name)).findFirst().orElse(null);
    }

    @Override
    public Attribute createAttribute(String name) {
        return this._ebean_get_attributes().stream().filter(p -> p.getName().equals(name)).findFirst().orElseGet(() -> {
            BUserAttribute attribute = new BUserAttribute();
            attribute.user = this;
            attribute.name = name;
            this._ebean_get_attributes().add(attribute);
            return attribute;
        });
    }

    static {
        _ebean_props = new String[]{"id", "name", "rank", "kingdom", "joinedKingdomAt", "lastOnlineAt", "kingdomInvites", "chatChannels", "adminModeEnabled", "socialSpyEnabled", "attributes", "createdAt", "updatedAt"};
    }

    public /* synthetic */ String _ebean_getMarker() {
        return _EBEAN_MARKER;
    }

    @Override
    public /* synthetic */ String[] _ebean_getPropertyNames() {
        return _ebean_props;
    }

    @Override
    public /* synthetic */ String _ebean_getPropertyName(int pos) {
        return _ebean_props[pos];
    }

    @Override
    public /* synthetic */ EntityBeanIntercept _ebean_getIntercept() {
        return this._ebean_intercept;
    }

    @Override
    public /* synthetic */ EntityBeanIntercept _ebean_intercept() {
        if (this._ebean_intercept == null) {
            this._ebean_intercept = new EntityBeanIntercept(this);
        }
        return this._ebean_intercept;
    }

    protected /* synthetic */ String _ebean_get_id() {
        this._ebean_intercept.preGetId();
        return this.id;
    }

    protected /* synthetic */ void _ebean_set_id(String newValue) {
        this._ebean_intercept.preSetter(false, 0, this.id, newValue);
        this.id = newValue;
    }

    protected /* synthetic */ String _ebean_getni_id() {
        return this.id;
    }

    protected /* synthetic */ void _ebean_setni_id(String _newValue) {
        this.id = _newValue;
        this._ebean_intercept.setLoadedProperty(0);
    }

    protected /* synthetic */ String _ebean_get_name() {
        this._ebean_intercept.preGetter(1);
        return this.name;
    }

    protected /* synthetic */ void _ebean_set_name(String newValue) {
        this._ebean_intercept.preSetter(true, 1, this._ebean_get_name(), newValue);
        this.name = newValue;
    }

    protected /* synthetic */ String _ebean_getni_name() {
        return this.name;
    }

    protected /* synthetic */ void _ebean_setni_name(String _newValue) {
        this.name = _newValue;
        this._ebean_intercept.setLoadedProperty(1);
    }

    protected /* synthetic */ BRank _ebean_get_rank() {
        this._ebean_intercept.preGetter(2);
        return this.rank;
    }

    protected /* synthetic */ void _ebean_set_rank(BRank newValue) {
        this._ebean_intercept.preSetter(true, 2, this._ebean_get_rank(), newValue);
        this.rank = newValue;
    }

    protected /* synthetic */ BRank _ebean_getni_rank() {
        return this.rank;
    }

    protected /* synthetic */ void _ebean_setni_rank(BRank _newValue) {
        this.rank = _newValue;
        this._ebean_intercept.setLoadedProperty(2);
    }

    protected /* synthetic */ BKingdom _ebean_get_kingdom() {
        this._ebean_intercept.preGetter(3);
        return this.kingdom;
    }

    protected /* synthetic */ void _ebean_set_kingdom(BKingdom newValue) {
        this._ebean_intercept.preSetter(true, 3, this._ebean_get_kingdom(), newValue);
        this.kingdom = newValue;
    }

    protected /* synthetic */ BKingdom _ebean_getni_kingdom() {
        return this.kingdom;
    }

    protected /* synthetic */ void _ebean_setni_kingdom(BKingdom _newValue) {
        this.kingdom = _newValue;
        this._ebean_intercept.setLoadedProperty(3);
    }

    protected /* synthetic */ Instant _ebean_get_joinedKingdomAt() {
        this._ebean_intercept.preGetter(4);
        return this.joinedKingdomAt;
    }

    protected /* synthetic */ void _ebean_set_joinedKingdomAt(Instant newValue) {
        this._ebean_intercept.preSetter(true, 4, this._ebean_get_joinedKingdomAt(), newValue);
        this.joinedKingdomAt = newValue;
    }

    protected /* synthetic */ Instant _ebean_getni_joinedKingdomAt() {
        return this.joinedKingdomAt;
    }

    protected /* synthetic */ void _ebean_setni_joinedKingdomAt(Instant _newValue) {
        this.joinedKingdomAt = _newValue;
        this._ebean_intercept.setLoadedProperty(4);
    }

    protected /* synthetic */ Instant _ebean_get_lastOnlineAt() {
        this._ebean_intercept.preGetter(5);
        return this.lastOnlineAt;
    }

    protected /* synthetic */ void _ebean_set_lastOnlineAt(Instant newValue) {
        this._ebean_intercept.preSetter(true, 5, this._ebean_get_lastOnlineAt(), newValue);
        this.lastOnlineAt = newValue;
    }

    protected /* synthetic */ Instant _ebean_getni_lastOnlineAt() {
        return this.lastOnlineAt;
    }

    protected /* synthetic */ void _ebean_setni_lastOnlineAt(Instant _newValue) {
        this.lastOnlineAt = _newValue;
        this._ebean_intercept.setLoadedProperty(5);
    }

    protected /* synthetic */ List _ebean_get_kingdomInvites() {
        this._ebean_intercept.preGetter(6);
        if (this.kingdomInvites == null) {
            this.kingdomInvites = new BeanList<BKingdomInvite>();
            this._ebean_intercept.initialisedMany(6);
        }
        return this.kingdomInvites;
    }

    protected /* synthetic */ void _ebean_set_kingdomInvites(List newValue) {
        this._ebean_intercept.preSetterMany(false, 6, this._ebean_get_kingdomInvites(), newValue);
        this.kingdomInvites = newValue;
    }

    protected /* synthetic */ List _ebean_getni_kingdomInvites() {
        return this.kingdomInvites;
    }

    protected /* synthetic */ void _ebean_setni_kingdomInvites(List _newValue) {
        this.kingdomInvites = _newValue;
        this._ebean_intercept.setLoadedProperty(6);
    }

    protected /* synthetic */ List _ebean_get_chatChannels() {
        this._ebean_intercept.preGetter(7);
        if (this.chatChannels == null) {
            this.chatChannels = new BeanList<BUserChatChannel>();
            this._ebean_intercept.initialisedMany(7);
        }
        return this.chatChannels;
    }

    protected /* synthetic */ void _ebean_set_chatChannels(List newValue) {
        this._ebean_intercept.preSetterMany(false, 7, this._ebean_get_chatChannels(), newValue);
        this.chatChannels = newValue;
    }

    protected /* synthetic */ List _ebean_getni_chatChannels() {
        return this.chatChannels;
    }

    protected /* synthetic */ void _ebean_setni_chatChannels(List _newValue) {
        this.chatChannels = _newValue;
        this._ebean_intercept.setLoadedProperty(7);
    }

    protected /* synthetic */ boolean _ebean_get_adminModeEnabled() {
        this._ebean_intercept.preGetter(8);
        return this.adminModeEnabled;
    }

    protected /* synthetic */ void _ebean_set_adminModeEnabled(boolean newValue) {
        this._ebean_intercept.preSetter(true, 8, this._ebean_get_adminModeEnabled(), newValue);
        this.adminModeEnabled = newValue;
    }

    protected /* synthetic */ boolean _ebean_getni_adminModeEnabled() {
        return this.adminModeEnabled;
    }

    protected /* synthetic */ void _ebean_setni_adminModeEnabled(boolean _newValue) {
        this.adminModeEnabled = _newValue;
        this._ebean_intercept.setLoadedProperty(8);
    }

    protected /* synthetic */ boolean _ebean_get_socialSpyEnabled() {
        this._ebean_intercept.preGetter(9);
        return this.socialSpyEnabled;
    }

    protected /* synthetic */ void _ebean_set_socialSpyEnabled(boolean newValue) {
        this._ebean_intercept.preSetter(true, 9, this._ebean_get_socialSpyEnabled(), newValue);
        this.socialSpyEnabled = newValue;
    }

    protected /* synthetic */ boolean _ebean_getni_socialSpyEnabled() {
        return this.socialSpyEnabled;
    }

    protected /* synthetic */ void _ebean_setni_socialSpyEnabled(boolean _newValue) {
        this.socialSpyEnabled = _newValue;
        this._ebean_intercept.setLoadedProperty(9);
    }

    protected /* synthetic */ List _ebean_get_attributes() {
        this._ebean_intercept.preGetter(10);
        if (this.attributes == null) {
            this.attributes = new BeanList<BUserAttribute>();
            this._ebean_intercept.initialisedMany(10);
        }
        return this.attributes;
    }

    protected /* synthetic */ void _ebean_set_attributes(List newValue) {
        this._ebean_intercept.preSetterMany(false, 10, this._ebean_get_attributes(), newValue);
        this.attributes = newValue;
    }

    protected /* synthetic */ List _ebean_getni_attributes() {
        return this.attributes;
    }

    protected /* synthetic */ void _ebean_setni_attributes(List _newValue) {
        this.attributes = _newValue;
        this._ebean_intercept.setLoadedProperty(10);
    }

    protected /* synthetic */ Instant _ebean_get_createdAt() {
        this._ebean_intercept.preGetter(11);
        return this.createdAt;
    }

    protected /* synthetic */ void _ebean_set_createdAt(Instant newValue) {
        this._ebean_intercept.preSetter(true, 11, this._ebean_get_createdAt(), newValue);
        this.createdAt = newValue;
    }

    protected /* synthetic */ Instant _ebean_getni_createdAt() {
        return this.createdAt;
    }

    protected /* synthetic */ void _ebean_setni_createdAt(Instant _newValue) {
        this.createdAt = _newValue;
        this._ebean_intercept.setLoadedProperty(11);
    }

    protected /* synthetic */ Instant _ebean_get_updatedAt() {
        this._ebean_intercept.preGetter(12);
        return this.updatedAt;
    }

    protected /* synthetic */ void _ebean_set_updatedAt(Instant newValue) {
        this._ebean_intercept.preSetter(true, 12, this._ebean_get_updatedAt(), newValue);
        this.updatedAt = newValue;
    }

    protected /* synthetic */ Instant _ebean_getni_updatedAt() {
        return this.updatedAt;
    }

    protected /* synthetic */ void _ebean_setni_updatedAt(Instant _newValue) {
        this.updatedAt = _newValue;
        this._ebean_intercept.setLoadedProperty(12);
    }

    @Override
    public /* synthetic */ Object _ebean_getField(int index) {
        switch (index) {
            case 0: {
                return this.id;
            }
            case 1: {
                return this.name;
            }
            case 2: {
                return this.rank;
            }
            case 3: {
                return this.kingdom;
            }
            case 4: {
                return this.joinedKingdomAt;
            }
            case 5: {
                return this.lastOnlineAt;
            }
            case 6: {
                return this.kingdomInvites;
            }
            case 7: {
                return this.chatChannels;
            }
            case 8: {
                return this.adminModeEnabled;
            }
            case 9: {
                return this.socialSpyEnabled;
            }
            case 10: {
                return this.attributes;
            }
            case 11: {
                return this.createdAt;
            }
            case 12: {
                return this.updatedAt;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    @Override
    public /* synthetic */ Object _ebean_getFieldIntercept(int index) {
        switch (index) {
            case 0: {
                return this._ebean_get_id();
            }
            case 1: {
                return this._ebean_get_name();
            }
            case 2: {
                return this._ebean_get_rank();
            }
            case 3: {
                return this._ebean_get_kingdom();
            }
            case 4: {
                return this._ebean_get_joinedKingdomAt();
            }
            case 5: {
                return this._ebean_get_lastOnlineAt();
            }
            case 6: {
                return this._ebean_get_kingdomInvites();
            }
            case 7: {
                return this._ebean_get_chatChannels();
            }
            case 8: {
                return this._ebean_get_adminModeEnabled();
            }
            case 9: {
                return this._ebean_get_socialSpyEnabled();
            }
            case 10: {
                return this._ebean_get_attributes();
            }
            case 11: {
                return this._ebean_get_createdAt();
            }
            case 12: {
                return this._ebean_get_updatedAt();
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    @Override
    public /* synthetic */ void _ebean_setField(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_setni_id((String)o);
                return;
            }
            case 1: {
                this._ebean_setni_name((String)o);
                return;
            }
            case 2: {
                this._ebean_setni_rank((BRank)o);
                return;
            }
            case 3: {
                this._ebean_setni_kingdom((BKingdom)o);
                return;
            }
            case 4: {
                this._ebean_setni_joinedKingdomAt((Instant)o);
                return;
            }
            case 5: {
                this._ebean_setni_lastOnlineAt((Instant)o);
                return;
            }
            case 6: {
                this._ebean_setni_kingdomInvites((List)o);
                return;
            }
            case 7: {
                this._ebean_setni_chatChannels((List)o);
                return;
            }
            case 8: {
                this._ebean_setni_adminModeEnabled((Boolean)o);
                return;
            }
            case 9: {
                this._ebean_setni_socialSpyEnabled((Boolean)o);
                return;
            }
            case 10: {
                this._ebean_setni_attributes((List)o);
                return;
            }
            case 11: {
                this._ebean_setni_createdAt((Instant)o);
                return;
            }
            case 12: {
                this._ebean_setni_updatedAt((Instant)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    @Override
    public /* synthetic */ void _ebean_setFieldIntercept(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_set_id((String)o);
                return;
            }
            case 1: {
                this._ebean_set_name((String)o);
                return;
            }
            case 2: {
                this._ebean_set_rank((BRank)o);
                return;
            }
            case 3: {
                this._ebean_set_kingdom((BKingdom)o);
                return;
            }
            case 4: {
                this._ebean_set_joinedKingdomAt((Instant)o);
                return;
            }
            case 5: {
                this._ebean_set_lastOnlineAt((Instant)o);
                return;
            }
            case 6: {
                this._ebean_set_kingdomInvites((List)o);
                return;
            }
            case 7: {
                this._ebean_set_chatChannels((List)o);
                return;
            }
            case 8: {
                this._ebean_set_adminModeEnabled((Boolean)o);
                return;
            }
            case 9: {
                this._ebean_set_socialSpyEnabled((Boolean)o);
                return;
            }
            case 10: {
                this._ebean_set_attributes((List)o);
                return;
            }
            case 11: {
                this._ebean_set_createdAt((Instant)o);
                return;
            }
            case 12: {
                this._ebean_set_updatedAt((Instant)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ Object _ebean_getIdentity() {
        BUser bUser = this;
        synchronized (bUser) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            Object tmpId = this._ebean_getField(0);
            this._ebean_identity = tmpId != null ? tmpId : new Object();
            return this._ebean_identity;
        }
    }

    public /* synthetic */ boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((BUser)obj)._ebean_getIdentity());
    }

    public /* synthetic */ int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    @Override
    public /* synthetic */ void _ebean_setEmbeddedLoaded() {
    }

    @Override
    public /* synthetic */ boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    @Override
    public /* synthetic */ Object _ebean_newInstance() {
        return new BUser();
    }
}

