/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.ebean.beans;

import com.gufli.kingdomcraft.api.domain.Kingdom;
import com.gufli.kingdomcraft.api.domain.Rank;
import com.gufli.kingdomcraft.api.domain.RankAttribute;
import com.gufli.kingdomcraft.api.domain.RankPermissionGroup;
import com.gufli.kingdomcraft.common.ebean.StorageContext;
import com.gufli.kingdomcraft.common.ebean.beans.BKingdom;
import com.gufli.kingdomcraft.common.ebean.beans.BRankAttribute;
import com.gufli.kingdomcraft.common.ebean.beans.BRankPermissionGroup;
import com.gufli.kingdomcraft.common.ebean.beans.BUser;
import com.gufli.kingdomcraft.common.ebean.beans.BaseModel;
import com.gufli.kingdomcraft.common.ebean.beans.query.QBUser;
import io.ebean.annotation.ConstraintMode;
import io.ebean.annotation.DbForeignKey;
import io.ebean.annotation.Formula;
import io.ebean.annotation.WhenCreated;
import io.ebean.annotation.WhenModified;
import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import io.ebean.common.BeanList;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

@Entity
@Table(name="ranks")
@UniqueConstraint(columnNames={"name", "kingdom_id"})
public class BRank
extends BaseModel
implements Rank,
EntityBean {
    @Id
    public int id;
    public String name;
    @ManyToOne
    @DbForeignKey(onDelete=ConstraintMode.CASCADE)
    public BKingdom kingdom;
    public String display;
    public String prefix;
    public String suffix;
    public int maxMembers;
    public int level;
    @OneToMany(mappedBy="rank", fetch=FetchType.EAGER)
    public List<BRankAttribute> attributes;
    @OneToMany(mappedBy="rank", fetch=FetchType.EAGER)
    public List<BRankPermissionGroup> permissionGroups;
    @Formula(select="(select count(id) from users where rank_id = t0.id)")
    public int memberCount;
    @WhenCreated
    public Instant createdAt;
    @WhenModified
    public Instant updatedAt;
    private static /* synthetic */ String _EBEAN_MARKER = "com.gufli.kingdomcraft.common.ebean.beans.BRank";
    public static /* synthetic */ String[] _ebean_props;
    protected /* synthetic */ EntityBeanIntercept _ebean_intercept;
    protected transient /* synthetic */ Object _ebean_identity;

    public BRank() {
        this._ebean_intercept = new EntityBeanIntercept(this);
    }

    @Override
    public boolean delete() {
        this._ebean_get_kingdom().ranks.remove(this);
        if (this._ebean_get_kingdom().defaultRank == this) {
            this._ebean_get_kingdom().defaultRank = null;
        }
        BRank defaultRank = this._ebean_get_kingdom().defaultRank;
        StorageContext.players.values().stream().filter(user -> user.getRank() == this).forEach(user -> user.setRank(defaultRank));
        return super.delete();
    }

    @Override
    public void save() {
        super.save();
    }

    @Override
    public int getId() {
        return this._ebean_get_id();
    }

    @Override
    public String getName() {
        return this._ebean_get_name();
    }

    @Override
    public void renameTo(String name) {
        if (this._ebean_get_kingdom().getRank(name) != null) {
            throw new IllegalArgumentException("A rank with that name already exists.");
        }
        this._ebean_set_name(name);
    }

    @Override
    public Kingdom getKingdom() {
        return this._ebean_get_kingdom();
    }

    @Override
    public String getDisplay() {
        return this._ebean_get_display() != null && !this._ebean_get_display().equals("") ? this._ebean_get_display() : this._ebean_get_name();
    }

    @Override
    public void setDisplay(String display) {
        this._ebean_set_display(display);
    }

    @Override
    public String getPrefix() {
        return this._ebean_get_prefix() != null ? this._ebean_get_prefix() : "";
    }

    @Override
    public void setPrefix(String prefix) {
        this._ebean_set_prefix(prefix);
    }

    @Override
    public String getSuffix() {
        return this._ebean_get_suffix() != null ? this._ebean_get_suffix() : "";
    }

    @Override
    public void setSuffix(String suffix) {
        this._ebean_set_suffix(suffix);
    }

    @Override
    public int getMaxMembers() {
        return this._ebean_get_maxMembers();
    }

    @Override
    public void setMaxMembers(int maxMembers) {
        this._ebean_set_maxMembers(maxMembers);
    }

    @Override
    public int getLevel() {
        return this._ebean_get_level();
    }

    @Override
    public void setLevel(int level) {
        this._ebean_set_level(level);
    }

    @Override
    public RankAttribute getAttribute(String name) {
        return this._ebean_get_attributes().stream().filter(p -> p.getName().equals(name)).findFirst().orElse(null);
    }

    @Override
    public RankAttribute createAttribute(String name) {
        return this._ebean_get_attributes().stream().filter(p -> p.getName().equals(name)).findFirst().orElseGet(() -> {
            BRankAttribute attribute = new BRankAttribute();
            attribute.rank = this;
            attribute.name = name;
            this._ebean_get_attributes().add(attribute);
            return attribute;
        });
    }

    @Override
    public List<RankAttribute> getAttributes() {
        return new ArrayList<RankAttribute>(this._ebean_get_attributes());
    }

    @Override
    public List<RankPermissionGroup> getPermissionGroups() {
        return new ArrayList<RankPermissionGroup>(this._ebean_get_permissionGroups());
    }

    @Override
    public RankPermissionGroup getPermissionGroup(String name) {
        return this._ebean_get_permissionGroups().stream().filter(g2 -> g2.getName().equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    @Override
    public RankPermissionGroup createPermissionGroup(String name) {
        return this._ebean_get_permissionGroups().stream().filter(p -> p.getName().equals(name)).findFirst().orElseGet(() -> {
            BRankPermissionGroup permissionGroup = new BRankPermissionGroup();
            permissionGroup.rank = this;
            permissionGroup.name = name;
            this._ebean_get_permissionGroups().add(permissionGroup);
            return permissionGroup;
        });
    }

    @Override
    public int getMemberCount() {
        return this._ebean_get_memberCount();
    }

    @Override
    public Map<UUID, String> getMembers() {
        QBUser alias = QBUser.alias();
        return ((QBUser)((QBUser)new QBUser()._rank()._id().eq(this._ebean_get_id())).select(alias._id(), alias._name())).findStream().collect(Collectors.toMap(BUser::getUniqueId, BUser::getName));
    }

    @Override
    public Rank clone(Kingdom kingdom, boolean withAttributes) {
        Rank clone = kingdom.getRank(this._ebean_get_name());
        if (clone == null) {
            clone = kingdom.createRank(this._ebean_get_name());
        }
        clone.setPrefix(this._ebean_get_prefix());
        clone.setSuffix(this._ebean_get_suffix());
        clone.setDisplay(this._ebean_get_display());
        clone.setMaxMembers(this._ebean_get_maxMembers());
        clone.setLevel(this._ebean_get_level());
        for (RankPermissionGroup rpg : this._ebean_get_permissionGroups()) {
            if (clone.getPermissionGroup(rpg.getName()) != null) continue;
            clone.createPermissionGroup(rpg.getName());
        }
        if (withAttributes) {
            for (RankAttribute attr : this._ebean_get_attributes()) {
                if (clone.getAttribute(attr.getName()) != null) continue;
                clone.createAttribute(attr.getName()).setValue(attr.getValue());
            }
        }
        return clone;
    }

    static {
        _ebean_props = new String[]{"id", "name", "kingdom", "display", "prefix", "suffix", "maxMembers", "level", "attributes", "permissionGroups", "memberCount", "createdAt", "updatedAt"};
    }

    public /* synthetic */ String _ebean_getMarker() {
        return _EBEAN_MARKER;
    }

    @Override
    public /* synthetic */ String[] _ebean_getPropertyNames() {
        return _ebean_props;
    }

    @Override
    public /* synthetic */ String _ebean_getPropertyName(int pos) {
        return _ebean_props[pos];
    }

    @Override
    public /* synthetic */ EntityBeanIntercept _ebean_getIntercept() {
        return this._ebean_intercept;
    }

    @Override
    public /* synthetic */ EntityBeanIntercept _ebean_intercept() {
        if (this._ebean_intercept == null) {
            this._ebean_intercept = new EntityBeanIntercept(this);
        }
        return this._ebean_intercept;
    }

    protected /* synthetic */ int _ebean_get_id() {
        this._ebean_intercept.preGetId();
        return this.id;
    }

    protected /* synthetic */ void _ebean_set_id(int newValue) {
        this._ebean_intercept.preSetter(false, 0, this.id, newValue);
        this.id = newValue;
    }

    protected /* synthetic */ int _ebean_getni_id() {
        return this.id;
    }

    protected /* synthetic */ void _ebean_setni_id(int _newValue) {
        this.id = _newValue;
        this._ebean_intercept.setLoadedProperty(0);
    }

    protected /* synthetic */ String _ebean_get_name() {
        this._ebean_intercept.preGetter(1);
        return this.name;
    }

    protected /* synthetic */ void _ebean_set_name(String newValue) {
        this._ebean_intercept.preSetter(true, 1, this._ebean_get_name(), newValue);
        this.name = newValue;
    }

    protected /* synthetic */ String _ebean_getni_name() {
        return this.name;
    }

    protected /* synthetic */ void _ebean_setni_name(String _newValue) {
        this.name = _newValue;
        this._ebean_intercept.setLoadedProperty(1);
    }

    protected /* synthetic */ BKingdom _ebean_get_kingdom() {
        this._ebean_intercept.preGetter(2);
        return this.kingdom;
    }

    protected /* synthetic */ void _ebean_set_kingdom(BKingdom newValue) {
        this._ebean_intercept.preSetter(true, 2, this._ebean_get_kingdom(), newValue);
        this.kingdom = newValue;
    }

    protected /* synthetic */ BKingdom _ebean_getni_kingdom() {
        return this.kingdom;
    }

    protected /* synthetic */ void _ebean_setni_kingdom(BKingdom _newValue) {
        this.kingdom = _newValue;
        this._ebean_intercept.setLoadedProperty(2);
    }

    protected /* synthetic */ String _ebean_get_display() {
        this._ebean_intercept.preGetter(3);
        return this.display;
    }

    protected /* synthetic */ void _ebean_set_display(String newValue) {
        this._ebean_intercept.preSetter(true, 3, this._ebean_get_display(), newValue);
        this.display = newValue;
    }

    protected /* synthetic */ String _ebean_getni_display() {
        return this.display;
    }

    protected /* synthetic */ void _ebean_setni_display(String _newValue) {
        this.display = _newValue;
        this._ebean_intercept.setLoadedProperty(3);
    }

    protected /* synthetic */ String _ebean_get_prefix() {
        this._ebean_intercept.preGetter(4);
        return this.prefix;
    }

    protected /* synthetic */ void _ebean_set_prefix(String newValue) {
        this._ebean_intercept.preSetter(true, 4, this._ebean_get_prefix(), newValue);
        this.prefix = newValue;
    }

    protected /* synthetic */ String _ebean_getni_prefix() {
        return this.prefix;
    }

    protected /* synthetic */ void _ebean_setni_prefix(String _newValue) {
        this.prefix = _newValue;
        this._ebean_intercept.setLoadedProperty(4);
    }

    protected /* synthetic */ String _ebean_get_suffix() {
        this._ebean_intercept.preGetter(5);
        return this.suffix;
    }

    protected /* synthetic */ void _ebean_set_suffix(String newValue) {
        this._ebean_intercept.preSetter(true, 5, this._ebean_get_suffix(), newValue);
        this.suffix = newValue;
    }

    protected /* synthetic */ String _ebean_getni_suffix() {
        return this.suffix;
    }

    protected /* synthetic */ void _ebean_setni_suffix(String _newValue) {
        this.suffix = _newValue;
        this._ebean_intercept.setLoadedProperty(5);
    }

    protected /* synthetic */ int _ebean_get_maxMembers() {
        this._ebean_intercept.preGetter(6);
        return this.maxMembers;
    }

    protected /* synthetic */ void _ebean_set_maxMembers(int newValue) {
        this._ebean_intercept.preSetter(true, 6, this._ebean_get_maxMembers(), newValue);
        this.maxMembers = newValue;
    }

    protected /* synthetic */ int _ebean_getni_maxMembers() {
        return this.maxMembers;
    }

    protected /* synthetic */ void _ebean_setni_maxMembers(int _newValue) {
        this.maxMembers = _newValue;
        this._ebean_intercept.setLoadedProperty(6);
    }

    protected /* synthetic */ int _ebean_get_level() {
        this._ebean_intercept.preGetter(7);
        return this.level;
    }

    protected /* synthetic */ void _ebean_set_level(int newValue) {
        this._ebean_intercept.preSetter(true, 7, this._ebean_get_level(), newValue);
        this.level = newValue;
    }

    protected /* synthetic */ int _ebean_getni_level() {
        return this.level;
    }

    protected /* synthetic */ void _ebean_setni_level(int _newValue) {
        this.level = _newValue;
        this._ebean_intercept.setLoadedProperty(7);
    }

    protected /* synthetic */ List _ebean_get_attributes() {
        this._ebean_intercept.preGetter(8);
        if (this.attributes == null) {
            this.attributes = new BeanList<BRankAttribute>();
            this._ebean_intercept.initialisedMany(8);
        }
        return this.attributes;
    }

    protected /* synthetic */ void _ebean_set_attributes(List newValue) {
        this._ebean_intercept.preSetterMany(false, 8, this._ebean_get_attributes(), newValue);
        this.attributes = newValue;
    }

    protected /* synthetic */ List _ebean_getni_attributes() {
        return this.attributes;
    }

    protected /* synthetic */ void _ebean_setni_attributes(List _newValue) {
        this.attributes = _newValue;
        this._ebean_intercept.setLoadedProperty(8);
    }

    protected /* synthetic */ List _ebean_get_permissionGroups() {
        this._ebean_intercept.preGetter(9);
        if (this.permissionGroups == null) {
            this.permissionGroups = new BeanList<BRankPermissionGroup>();
            this._ebean_intercept.initialisedMany(9);
        }
        return this.permissionGroups;
    }

    protected /* synthetic */ void _ebean_set_permissionGroups(List newValue) {
        this._ebean_intercept.preSetterMany(false, 9, this._ebean_get_permissionGroups(), newValue);
        this.permissionGroups = newValue;
    }

    protected /* synthetic */ List _ebean_getni_permissionGroups() {
        return this.permissionGroups;
    }

    protected /* synthetic */ void _ebean_setni_permissionGroups(List _newValue) {
        this.permissionGroups = _newValue;
        this._ebean_intercept.setLoadedProperty(9);
    }

    protected /* synthetic */ int _ebean_get_memberCount() {
        this._ebean_intercept.preGetter(10);
        return this.memberCount;
    }

    protected /* synthetic */ void _ebean_set_memberCount(int newValue) {
        this._ebean_intercept.preSetter(true, 10, this._ebean_get_memberCount(), newValue);
        this.memberCount = newValue;
    }

    protected /* synthetic */ int _ebean_getni_memberCount() {
        return this.memberCount;
    }

    protected /* synthetic */ void _ebean_setni_memberCount(int _newValue) {
        this.memberCount = _newValue;
        this._ebean_intercept.setLoadedProperty(10);
    }

    protected /* synthetic */ Instant _ebean_get_createdAt() {
        this._ebean_intercept.preGetter(11);
        return this.createdAt;
    }

    protected /* synthetic */ void _ebean_set_createdAt(Instant newValue) {
        this._ebean_intercept.preSetter(true, 11, this._ebean_get_createdAt(), newValue);
        this.createdAt = newValue;
    }

    protected /* synthetic */ Instant _ebean_getni_createdAt() {
        return this.createdAt;
    }

    protected /* synthetic */ void _ebean_setni_createdAt(Instant _newValue) {
        this.createdAt = _newValue;
        this._ebean_intercept.setLoadedProperty(11);
    }

    protected /* synthetic */ Instant _ebean_get_updatedAt() {
        this._ebean_intercept.preGetter(12);
        return this.updatedAt;
    }

    protected /* synthetic */ void _ebean_set_updatedAt(Instant newValue) {
        this._ebean_intercept.preSetter(true, 12, this._ebean_get_updatedAt(), newValue);
        this.updatedAt = newValue;
    }

    protected /* synthetic */ Instant _ebean_getni_updatedAt() {
        return this.updatedAt;
    }

    protected /* synthetic */ void _ebean_setni_updatedAt(Instant _newValue) {
        this.updatedAt = _newValue;
        this._ebean_intercept.setLoadedProperty(12);
    }

    @Override
    public /* synthetic */ Object _ebean_getField(int index) {
        switch (index) {
            case 0: {
                return this.id;
            }
            case 1: {
                return this.name;
            }
            case 2: {
                return this.kingdom;
            }
            case 3: {
                return this.display;
            }
            case 4: {
                return this.prefix;
            }
            case 5: {
                return this.suffix;
            }
            case 6: {
                return this.maxMembers;
            }
            case 7: {
                return this.level;
            }
            case 8: {
                return this.attributes;
            }
            case 9: {
                return this.permissionGroups;
            }
            case 10: {
                return this.memberCount;
            }
            case 11: {
                return this.createdAt;
            }
            case 12: {
                return this.updatedAt;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    @Override
    public /* synthetic */ Object _ebean_getFieldIntercept(int index) {
        switch (index) {
            case 0: {
                return this._ebean_get_id();
            }
            case 1: {
                return this._ebean_get_name();
            }
            case 2: {
                return this._ebean_get_kingdom();
            }
            case 3: {
                return this._ebean_get_display();
            }
            case 4: {
                return this._ebean_get_prefix();
            }
            case 5: {
                return this._ebean_get_suffix();
            }
            case 6: {
                return this._ebean_get_maxMembers();
            }
            case 7: {
                return this._ebean_get_level();
            }
            case 8: {
                return this._ebean_get_attributes();
            }
            case 9: {
                return this._ebean_get_permissionGroups();
            }
            case 10: {
                return this._ebean_get_memberCount();
            }
            case 11: {
                return this._ebean_get_createdAt();
            }
            case 12: {
                return this._ebean_get_updatedAt();
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    @Override
    public /* synthetic */ void _ebean_setField(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_setni_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_setni_name((String)o);
                return;
            }
            case 2: {
                this._ebean_setni_kingdom((BKingdom)o);
                return;
            }
            case 3: {
                this._ebean_setni_display((String)o);
                return;
            }
            case 4: {
                this._ebean_setni_prefix((String)o);
                return;
            }
            case 5: {
                this._ebean_setni_suffix((String)o);
                return;
            }
            case 6: {
                this._ebean_setni_maxMembers((Integer)o);
                return;
            }
            case 7: {
                this._ebean_setni_level((Integer)o);
                return;
            }
            case 8: {
                this._ebean_setni_attributes((List)o);
                return;
            }
            case 9: {
                this._ebean_setni_permissionGroups((List)o);
                return;
            }
            case 10: {
                this._ebean_setni_memberCount((Integer)o);
                return;
            }
            case 11: {
                this._ebean_setni_createdAt((Instant)o);
                return;
            }
            case 12: {
                this._ebean_setni_updatedAt((Instant)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    @Override
    public /* synthetic */ void _ebean_setFieldIntercept(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_set_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_set_name((String)o);
                return;
            }
            case 2: {
                this._ebean_set_kingdom((BKingdom)o);
                return;
            }
            case 3: {
                this._ebean_set_display((String)o);
                return;
            }
            case 4: {
                this._ebean_set_prefix((String)o);
                return;
            }
            case 5: {
                this._ebean_set_suffix((String)o);
                return;
            }
            case 6: {
                this._ebean_set_maxMembers((Integer)o);
                return;
            }
            case 7: {
                this._ebean_set_level((Integer)o);
                return;
            }
            case 8: {
                this._ebean_set_attributes((List)o);
                return;
            }
            case 9: {
                this._ebean_set_permissionGroups((List)o);
                return;
            }
            case 10: {
                this._ebean_set_memberCount((Integer)o);
                return;
            }
            case 11: {
                this._ebean_set_createdAt((Instant)o);
                return;
            }
            case 12: {
                this._ebean_set_updatedAt((Instant)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ Object _ebean_getIdentity() {
        BRank bRank = this;
        synchronized (bRank) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            this._ebean_identity = this._ebean_get_id() != 0 ? Integer.valueOf(this._ebean_get_id()) : new Object();
            return this._ebean_identity;
        }
    }

    public /* synthetic */ boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((BRank)obj)._ebean_getIdentity());
    }

    public /* synthetic */ int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    @Override
    public /* synthetic */ void _ebean_setEmbeddedLoaded() {
    }

    @Override
    public /* synthetic */ boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    @Override
    public /* synthetic */ Object _ebean_newInstance() {
        return new BRank();
    }
}

