/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.ebean.beans;

import com.gufli.kingdomcraft.api.KingdomCraftProvider;
import com.gufli.kingdomcraft.api.domain.Kingdom;
import com.gufli.kingdomcraft.api.domain.KingdomAttribute;
import com.gufli.kingdomcraft.api.domain.Rank;
import com.gufli.kingdomcraft.api.entity.PlatformLocation;
import com.gufli.kingdomcraft.api.events.KingdomDeleteEvent;
import com.gufli.kingdomcraft.api.item.Item;
import com.gufli.kingdomcraft.common.ebean.StorageContext;
import com.gufli.kingdomcraft.common.ebean.beans.BKingdomAttribute;
import com.gufli.kingdomcraft.common.ebean.beans.BRank;
import com.gufli.kingdomcraft.common.ebean.beans.BUser;
import com.gufli.kingdomcraft.common.ebean.beans.BaseModel;
import com.gufli.kingdomcraft.common.ebean.beans.ItemConverter;
import com.gufli.kingdomcraft.common.ebean.beans.PlatformLocationConverter;
import com.gufli.kingdomcraft.common.ebean.beans.query.QBUser;
import io.ebean.annotation.ConstraintMode;
import io.ebean.annotation.DbForeignKey;
import io.ebean.annotation.Formula;
import io.ebean.annotation.WhenCreated;
import io.ebean.annotation.WhenModified;
import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import io.ebean.common.BeanList;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;

@Entity
@Table(name="kingdoms")
public class BKingdom
extends BaseModel
implements Kingdom,
EntityBean {
    @Id
    public int id;
    @Column(unique=true)
    public String name;
    public String display;
    public String prefix;
    public String suffix;
    @Convert(converter=PlatformLocationConverter.class, attributeName="spawn")
    public PlatformLocation spawn;
    public boolean inviteOnly;
    public int maxMembers;
    @Convert(converter=ItemConverter.class, attributeName="item")
    @Column(length=1023)
    public Item item;
    @OneToOne
    @DbForeignKey(onDelete=ConstraintMode.SET_NULL)
    public BRank defaultRank;
    @OneToMany(mappedBy="kingdom", fetch=FetchType.EAGER)
    public List<BRank> ranks;
    @OneToMany(mappedBy="kingdom", fetch=FetchType.EAGER)
    public List<BKingdomAttribute> attributes;
    @Formula(select="(select count(id) from users where kingdom_id = t0.id)")
    public int memberCount;
    @WhenCreated
    Instant createdAt;
    @WhenModified
    Instant updatedAt;
    private static /* synthetic */ String _EBEAN_MARKER = "com.gufli.kingdomcraft.common.ebean.beans.BKingdom";
    public static /* synthetic */ String[] _ebean_props;
    protected /* synthetic */ EntityBeanIntercept _ebean_intercept;
    protected transient /* synthetic */ Object _ebean_identity;

    public BKingdom() {
        this._ebean_intercept = new EntityBeanIntercept(this);
    }

    @Override
    public boolean delete() {
        StorageContext.kingdoms.remove(this);
        StorageContext.players.values().stream().filter(user -> user.getKingdom() == this).forEach(user -> user.setKingdom(null));
        KingdomCraftProvider.get().getEventManager().dispatch(new KingdomDeleteEvent(this));
        return super.delete();
    }

    @Override
    public void save() {
        super.save();
    }

    @Override
    public int getId() {
        return this._ebean_get_id();
    }

    @Override
    public String getName() {
        return this._ebean_get_name();
    }

    @Override
    public void renameTo(String name) {
        if (StorageContext.kingdoms.stream().anyMatch(k -> k.getName().equalsIgnoreCase(name))) {
            throw new IllegalArgumentException("A kingdom with that name already exists.");
        }
        this._ebean_set_name(name);
    }

    @Override
    public String getDisplay() {
        return this._ebean_get_display() != null && !this._ebean_get_display().equals("") ? this._ebean_get_display() : this._ebean_get_name();
    }

    @Override
    public void setDisplay(String display) {
        this._ebean_set_display(display);
    }

    @Override
    public String getPrefix() {
        return this._ebean_get_prefix() != null ? this._ebean_get_prefix() : "";
    }

    @Override
    public void setPrefix(String prefix) {
        this._ebean_set_prefix(prefix);
    }

    @Override
    public String getSuffix() {
        return this._ebean_get_suffix() != null ? this._ebean_get_suffix() : "";
    }

    @Override
    public void setSuffix(String suffix) {
        this._ebean_set_suffix(suffix);
    }

    @Override
    public boolean isInviteOnly() {
        return this._ebean_get_inviteOnly();
    }

    @Override
    public void setInviteOnly(boolean inviteOnly) {
        this._ebean_set_inviteOnly(inviteOnly);
    }

    @Override
    public int getMaxMembers() {
        return this._ebean_get_maxMembers();
    }

    @Override
    public void setMaxMembers(int maxMembers) {
        this._ebean_set_maxMembers(maxMembers);
    }

    @Override
    public Rank getDefaultRank() {
        return this._ebean_get_defaultRank();
    }

    @Override
    public void setDefaultRank(Rank defaultRank) {
        if (!this._ebean_get_ranks().contains(defaultRank)) {
            throw new IllegalArgumentException("The given defaultRank does not belong to this kingdom.");
        }
        this._ebean_set_defaultRank((BRank)defaultRank);
    }

    @Override
    public Item getItem() {
        return this._ebean_get_item();
    }

    @Override
    public void setItem(Item item) {
        this._ebean_set_item(item);
    }

    @Override
    public List<Rank> getRanks() {
        return new ArrayList<Rank>(this._ebean_get_ranks());
    }

    @Override
    public Rank getRank(String name) {
        return this._ebean_get_ranks().stream().filter(r -> r.name.equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    @Override
    public Rank createRank(String name) {
        if (this.getRank(name) != null) {
            throw new IllegalArgumentException("A rank with that name already exists.");
        }
        BRank rank = new BRank();
        rank.name = name;
        rank.kingdom = this;
        this._ebean_get_ranks().add(rank);
        return rank;
    }

    @Override
    public KingdomAttribute getAttribute(String name) {
        return this._ebean_get_attributes().stream().filter(p -> p.getName().equals(name)).findFirst().orElse(null);
    }

    @Override
    public KingdomAttribute createAttribute(String name) {
        return this._ebean_get_attributes().stream().filter(p -> p.getName().equals(name)).findFirst().orElseGet(() -> {
            BKingdomAttribute attribute = new BKingdomAttribute();
            attribute.kingdom = this;
            attribute.name = name;
            this._ebean_get_attributes().add(attribute);
            return attribute;
        });
    }

    @Override
    public PlatformLocation getSpawn() {
        return this._ebean_get_spawn();
    }

    @Override
    public void setSpawn(PlatformLocation location) {
        this._ebean_set_spawn(location);
    }

    @Override
    public int getMemberCount() {
        return this._ebean_get_memberCount();
    }

    public void resetMemberCount() {
        this._ebean_set_memberCount(0);
    }

    @Override
    public Map<UUID, String> getMembers() {
        QBUser alias = QBUser.alias();
        return ((QBUser)((QBUser)new QBUser()._kingdom()._id().eq(this._ebean_get_id())).select(alias._id(), alias._name())).findStream().collect(Collectors.toMap(BUser::getUniqueId, BUser::getName));
    }

    @Override
    public Instant getCreatedAt() {
        return this._ebean_get_createdAt();
    }

    @Override
    public void copyTo(Kingdom target, boolean withAttributes) {
        if (this._ebean_get_prefix() != null) {
            target.setPrefix(this._ebean_get_prefix().replace("{kingdom_name}", target.getName()));
        }
        if (this._ebean_get_suffix() != null) {
            target.setSuffix(this._ebean_get_suffix().replace("{kingdom_name}", target.getName()));
        }
        if (this._ebean_get_display() != null) {
            target.setDisplay(this._ebean_get_display().replace("{kingdom_name}", target.getName()));
        }
        target.setMaxMembers(this._ebean_get_maxMembers());
        target.setInviteOnly(this._ebean_get_inviteOnly());
        if (withAttributes) {
            for (KingdomAttribute attr : this._ebean_get_attributes()) {
                if (target.getAttribute(attr.getName()) != null) continue;
                target.createAttribute(attr.getName()).setValue(attr.getValue());
            }
        }
    }

    static {
        _ebean_props = new String[]{"id", "name", "display", "prefix", "suffix", "spawn", "inviteOnly", "maxMembers", "item", "defaultRank", "ranks", "attributes", "memberCount", "createdAt", "updatedAt"};
    }

    public /* synthetic */ String _ebean_getMarker() {
        return _EBEAN_MARKER;
    }

    @Override
    public /* synthetic */ String[] _ebean_getPropertyNames() {
        return _ebean_props;
    }

    @Override
    public /* synthetic */ String _ebean_getPropertyName(int pos) {
        return _ebean_props[pos];
    }

    @Override
    public /* synthetic */ EntityBeanIntercept _ebean_getIntercept() {
        return this._ebean_intercept;
    }

    @Override
    public /* synthetic */ EntityBeanIntercept _ebean_intercept() {
        if (this._ebean_intercept == null) {
            this._ebean_intercept = new EntityBeanIntercept(this);
        }
        return this._ebean_intercept;
    }

    protected /* synthetic */ int _ebean_get_id() {
        this._ebean_intercept.preGetId();
        return this.id;
    }

    protected /* synthetic */ void _ebean_set_id(int newValue) {
        this._ebean_intercept.preSetter(false, 0, this.id, newValue);
        this.id = newValue;
    }

    protected /* synthetic */ int _ebean_getni_id() {
        return this.id;
    }

    protected /* synthetic */ void _ebean_setni_id(int _newValue) {
        this.id = _newValue;
        this._ebean_intercept.setLoadedProperty(0);
    }

    protected /* synthetic */ String _ebean_get_name() {
        this._ebean_intercept.preGetter(1);
        return this.name;
    }

    protected /* synthetic */ void _ebean_set_name(String newValue) {
        this._ebean_intercept.preSetter(true, 1, this._ebean_get_name(), newValue);
        this.name = newValue;
    }

    protected /* synthetic */ String _ebean_getni_name() {
        return this.name;
    }

    protected /* synthetic */ void _ebean_setni_name(String _newValue) {
        this.name = _newValue;
        this._ebean_intercept.setLoadedProperty(1);
    }

    protected /* synthetic */ String _ebean_get_display() {
        this._ebean_intercept.preGetter(2);
        return this.display;
    }

    protected /* synthetic */ void _ebean_set_display(String newValue) {
        this._ebean_intercept.preSetter(true, 2, this._ebean_get_display(), newValue);
        this.display = newValue;
    }

    protected /* synthetic */ String _ebean_getni_display() {
        return this.display;
    }

    protected /* synthetic */ void _ebean_setni_display(String _newValue) {
        this.display = _newValue;
        this._ebean_intercept.setLoadedProperty(2);
    }

    protected /* synthetic */ String _ebean_get_prefix() {
        this._ebean_intercept.preGetter(3);
        return this.prefix;
    }

    protected /* synthetic */ void _ebean_set_prefix(String newValue) {
        this._ebean_intercept.preSetter(true, 3, this._ebean_get_prefix(), newValue);
        this.prefix = newValue;
    }

    protected /* synthetic */ String _ebean_getni_prefix() {
        return this.prefix;
    }

    protected /* synthetic */ void _ebean_setni_prefix(String _newValue) {
        this.prefix = _newValue;
        this._ebean_intercept.setLoadedProperty(3);
    }

    protected /* synthetic */ String _ebean_get_suffix() {
        this._ebean_intercept.preGetter(4);
        return this.suffix;
    }

    protected /* synthetic */ void _ebean_set_suffix(String newValue) {
        this._ebean_intercept.preSetter(true, 4, this._ebean_get_suffix(), newValue);
        this.suffix = newValue;
    }

    protected /* synthetic */ String _ebean_getni_suffix() {
        return this.suffix;
    }

    protected /* synthetic */ void _ebean_setni_suffix(String _newValue) {
        this.suffix = _newValue;
        this._ebean_intercept.setLoadedProperty(4);
    }

    protected /* synthetic */ PlatformLocation _ebean_get_spawn() {
        this._ebean_intercept.preGetter(5);
        return this.spawn;
    }

    protected /* synthetic */ void _ebean_set_spawn(PlatformLocation newValue) {
        this._ebean_intercept.preSetter(true, 5, this._ebean_get_spawn(), newValue);
        this.spawn = newValue;
    }

    protected /* synthetic */ PlatformLocation _ebean_getni_spawn() {
        return this.spawn;
    }

    protected /* synthetic */ void _ebean_setni_spawn(PlatformLocation _newValue) {
        this.spawn = _newValue;
        this._ebean_intercept.setLoadedProperty(5);
    }

    protected /* synthetic */ boolean _ebean_get_inviteOnly() {
        this._ebean_intercept.preGetter(6);
        return this.inviteOnly;
    }

    protected /* synthetic */ void _ebean_set_inviteOnly(boolean newValue) {
        this._ebean_intercept.preSetter(true, 6, this._ebean_get_inviteOnly(), newValue);
        this.inviteOnly = newValue;
    }

    protected /* synthetic */ boolean _ebean_getni_inviteOnly() {
        return this.inviteOnly;
    }

    protected /* synthetic */ void _ebean_setni_inviteOnly(boolean _newValue) {
        this.inviteOnly = _newValue;
        this._ebean_intercept.setLoadedProperty(6);
    }

    protected /* synthetic */ int _ebean_get_maxMembers() {
        this._ebean_intercept.preGetter(7);
        return this.maxMembers;
    }

    protected /* synthetic */ void _ebean_set_maxMembers(int newValue) {
        this._ebean_intercept.preSetter(true, 7, this._ebean_get_maxMembers(), newValue);
        this.maxMembers = newValue;
    }

    protected /* synthetic */ int _ebean_getni_maxMembers() {
        return this.maxMembers;
    }

    protected /* synthetic */ void _ebean_setni_maxMembers(int _newValue) {
        this.maxMembers = _newValue;
        this._ebean_intercept.setLoadedProperty(7);
    }

    protected /* synthetic */ Item _ebean_get_item() {
        this._ebean_intercept.preGetter(8);
        return this.item;
    }

    protected /* synthetic */ void _ebean_set_item(Item newValue) {
        this._ebean_intercept.preSetter(true, 8, this._ebean_get_item(), newValue);
        this.item = newValue;
    }

    protected /* synthetic */ Item _ebean_getni_item() {
        return this.item;
    }

    protected /* synthetic */ void _ebean_setni_item(Item _newValue) {
        this.item = _newValue;
        this._ebean_intercept.setLoadedProperty(8);
    }

    protected /* synthetic */ BRank _ebean_get_defaultRank() {
        this._ebean_intercept.preGetter(9);
        return this.defaultRank;
    }

    protected /* synthetic */ void _ebean_set_defaultRank(BRank newValue) {
        this._ebean_intercept.preSetter(true, 9, this._ebean_get_defaultRank(), newValue);
        this.defaultRank = newValue;
    }

    protected /* synthetic */ BRank _ebean_getni_defaultRank() {
        return this.defaultRank;
    }

    protected /* synthetic */ void _ebean_setni_defaultRank(BRank _newValue) {
        this.defaultRank = _newValue;
        this._ebean_intercept.setLoadedProperty(9);
    }

    protected /* synthetic */ List _ebean_get_ranks() {
        this._ebean_intercept.preGetter(10);
        if (this.ranks == null) {
            this.ranks = new BeanList<BRank>();
            this._ebean_intercept.initialisedMany(10);
        }
        return this.ranks;
    }

    protected /* synthetic */ void _ebean_set_ranks(List newValue) {
        this._ebean_intercept.preSetterMany(false, 10, this._ebean_get_ranks(), newValue);
        this.ranks = newValue;
    }

    protected /* synthetic */ List _ebean_getni_ranks() {
        return this.ranks;
    }

    protected /* synthetic */ void _ebean_setni_ranks(List _newValue) {
        this.ranks = _newValue;
        this._ebean_intercept.setLoadedProperty(10);
    }

    protected /* synthetic */ List _ebean_get_attributes() {
        this._ebean_intercept.preGetter(11);
        if (this.attributes == null) {
            this.attributes = new BeanList<BKingdomAttribute>();
            this._ebean_intercept.initialisedMany(11);
        }
        return this.attributes;
    }

    protected /* synthetic */ void _ebean_set_attributes(List newValue) {
        this._ebean_intercept.preSetterMany(false, 11, this._ebean_get_attributes(), newValue);
        this.attributes = newValue;
    }

    protected /* synthetic */ List _ebean_getni_attributes() {
        return this.attributes;
    }

    protected /* synthetic */ void _ebean_setni_attributes(List _newValue) {
        this.attributes = _newValue;
        this._ebean_intercept.setLoadedProperty(11);
    }

    protected /* synthetic */ int _ebean_get_memberCount() {
        this._ebean_intercept.preGetter(12);
        return this.memberCount;
    }

    protected /* synthetic */ void _ebean_set_memberCount(int newValue) {
        this._ebean_intercept.preSetter(true, 12, this._ebean_get_memberCount(), newValue);
        this.memberCount = newValue;
    }

    protected /* synthetic */ int _ebean_getni_memberCount() {
        return this.memberCount;
    }

    protected /* synthetic */ void _ebean_setni_memberCount(int _newValue) {
        this.memberCount = _newValue;
        this._ebean_intercept.setLoadedProperty(12);
    }

    protected /* synthetic */ Instant _ebean_get_createdAt() {
        this._ebean_intercept.preGetter(13);
        return this.createdAt;
    }

    protected /* synthetic */ void _ebean_set_createdAt(Instant newValue) {
        this._ebean_intercept.preSetter(true, 13, this._ebean_get_createdAt(), newValue);
        this.createdAt = newValue;
    }

    protected /* synthetic */ Instant _ebean_getni_createdAt() {
        return this.createdAt;
    }

    protected /* synthetic */ void _ebean_setni_createdAt(Instant _newValue) {
        this.createdAt = _newValue;
        this._ebean_intercept.setLoadedProperty(13);
    }

    protected /* synthetic */ Instant _ebean_get_updatedAt() {
        this._ebean_intercept.preGetter(14);
        return this.updatedAt;
    }

    protected /* synthetic */ void _ebean_set_updatedAt(Instant newValue) {
        this._ebean_intercept.preSetter(true, 14, this._ebean_get_updatedAt(), newValue);
        this.updatedAt = newValue;
    }

    protected /* synthetic */ Instant _ebean_getni_updatedAt() {
        return this.updatedAt;
    }

    protected /* synthetic */ void _ebean_setni_updatedAt(Instant _newValue) {
        this.updatedAt = _newValue;
        this._ebean_intercept.setLoadedProperty(14);
    }

    @Override
    public /* synthetic */ Object _ebean_getField(int index) {
        switch (index) {
            case 0: {
                return this.id;
            }
            case 1: {
                return this.name;
            }
            case 2: {
                return this.display;
            }
            case 3: {
                return this.prefix;
            }
            case 4: {
                return this.suffix;
            }
            case 5: {
                return this.spawn;
            }
            case 6: {
                return this.inviteOnly;
            }
            case 7: {
                return this.maxMembers;
            }
            case 8: {
                return this.item;
            }
            case 9: {
                return this.defaultRank;
            }
            case 10: {
                return this.ranks;
            }
            case 11: {
                return this.attributes;
            }
            case 12: {
                return this.memberCount;
            }
            case 13: {
                return this.createdAt;
            }
            case 14: {
                return this.updatedAt;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    @Override
    public /* synthetic */ Object _ebean_getFieldIntercept(int index) {
        switch (index) {
            case 0: {
                return this._ebean_get_id();
            }
            case 1: {
                return this._ebean_get_name();
            }
            case 2: {
                return this._ebean_get_display();
            }
            case 3: {
                return this._ebean_get_prefix();
            }
            case 4: {
                return this._ebean_get_suffix();
            }
            case 5: {
                return this._ebean_get_spawn();
            }
            case 6: {
                return this._ebean_get_inviteOnly();
            }
            case 7: {
                return this._ebean_get_maxMembers();
            }
            case 8: {
                return this._ebean_get_item();
            }
            case 9: {
                return this._ebean_get_defaultRank();
            }
            case 10: {
                return this._ebean_get_ranks();
            }
            case 11: {
                return this._ebean_get_attributes();
            }
            case 12: {
                return this._ebean_get_memberCount();
            }
            case 13: {
                return this._ebean_get_createdAt();
            }
            case 14: {
                return this._ebean_get_updatedAt();
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    @Override
    public /* synthetic */ void _ebean_setField(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_setni_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_setni_name((String)o);
                return;
            }
            case 2: {
                this._ebean_setni_display((String)o);
                return;
            }
            case 3: {
                this._ebean_setni_prefix((String)o);
                return;
            }
            case 4: {
                this._ebean_setni_suffix((String)o);
                return;
            }
            case 5: {
                this._ebean_setni_spawn((PlatformLocation)o);
                return;
            }
            case 6: {
                this._ebean_setni_inviteOnly((Boolean)o);
                return;
            }
            case 7: {
                this._ebean_setni_maxMembers((Integer)o);
                return;
            }
            case 8: {
                this._ebean_setni_item((Item)o);
                return;
            }
            case 9: {
                this._ebean_setni_defaultRank((BRank)o);
                return;
            }
            case 10: {
                this._ebean_setni_ranks((List)o);
                return;
            }
            case 11: {
                this._ebean_setni_attributes((List)o);
                return;
            }
            case 12: {
                this._ebean_setni_memberCount((Integer)o);
                return;
            }
            case 13: {
                this._ebean_setni_createdAt((Instant)o);
                return;
            }
            case 14: {
                this._ebean_setni_updatedAt((Instant)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    @Override
    public /* synthetic */ void _ebean_setFieldIntercept(int index, Object o) {
        switch (index) {
            case 0: {
                this._ebean_set_id((Integer)o);
                return;
            }
            case 1: {
                this._ebean_set_name((String)o);
                return;
            }
            case 2: {
                this._ebean_set_display((String)o);
                return;
            }
            case 3: {
                this._ebean_set_prefix((String)o);
                return;
            }
            case 4: {
                this._ebean_set_suffix((String)o);
                return;
            }
            case 5: {
                this._ebean_set_spawn((PlatformLocation)o);
                return;
            }
            case 6: {
                this._ebean_set_inviteOnly((Boolean)o);
                return;
            }
            case 7: {
                this._ebean_set_maxMembers((Integer)o);
                return;
            }
            case 8: {
                this._ebean_set_item((Item)o);
                return;
            }
            case 9: {
                this._ebean_set_defaultRank((BRank)o);
                return;
            }
            case 10: {
                this._ebean_set_ranks((List)o);
                return;
            }
            case 11: {
                this._ebean_set_attributes((List)o);
                return;
            }
            case 12: {
                this._ebean_set_memberCount((Integer)o);
                return;
            }
            case 13: {
                this._ebean_set_createdAt((Instant)o);
                return;
            }
            case 14: {
                this._ebean_set_updatedAt((Instant)o);
                return;
            }
        }
        throw new RuntimeException("Invalid index " + index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ Object _ebean_getIdentity() {
        BKingdom bKingdom = this;
        synchronized (bKingdom) {
            if (this._ebean_identity != null) {
                return this._ebean_identity;
            }
            this._ebean_identity = this._ebean_get_id() != 0 ? Integer.valueOf(this._ebean_get_id()) : new Object();
            return this._ebean_identity;
        }
    }

    public /* synthetic */ boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this._ebean_getIdentity().equals(((BKingdom)obj)._ebean_getIdentity());
    }

    public /* synthetic */ int hashCode() {
        return this._ebean_getIdentity().hashCode();
    }

    @Override
    public /* synthetic */ void _ebean_setEmbeddedLoaded() {
    }

    @Override
    public /* synthetic */ boolean _ebean_isEmbeddedNewOrDirty() {
        return false;
    }

    @Override
    public /* synthetic */ Object _ebean_newInstance() {
        return new BKingdom();
    }
}

