/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.ebean;

import com.gufli.kingdomcraft.api.domain.Kingdom;
import com.gufli.kingdomcraft.api.domain.Model;
import com.gufli.kingdomcraft.api.domain.Rank;
import com.gufli.kingdomcraft.api.domain.Relation;
import com.gufli.kingdomcraft.api.domain.RelationType;
import com.gufli.kingdomcraft.api.domain.User;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.KingdomCraftPlugin;
import com.gufli.kingdomcraft.common.commands.admin.SqlDumpCommand;
import com.gufli.kingdomcraft.common.ebean.beans.BKingdom;
import com.gufli.kingdomcraft.common.ebean.beans.BKingdomAttribute;
import com.gufli.kingdomcraft.common.ebean.beans.BKingdomInvite;
import com.gufli.kingdomcraft.common.ebean.beans.BRank;
import com.gufli.kingdomcraft.common.ebean.beans.BRankAttribute;
import com.gufli.kingdomcraft.common.ebean.beans.BRankPermissionGroup;
import com.gufli.kingdomcraft.common.ebean.beans.BRelation;
import com.gufli.kingdomcraft.common.ebean.beans.BUser;
import com.gufli.kingdomcraft.common.ebean.beans.BUserAttribute;
import com.gufli.kingdomcraft.common.ebean.beans.BUserChatChannel;
import com.gufli.kingdomcraft.common.ebean.beans.ItemConverter;
import com.gufli.kingdomcraft.common.ebean.beans.PlatformLocationConverter;
import com.gufli.kingdomcraft.common.ebean.beans.query.QBKingdom;
import com.gufli.kingdomcraft.common.ebean.beans.query.QBRelation;
import com.gufli.kingdomcraft.common.ebean.beans.query.QBUser;
import io.ebean.DB;
import io.ebean.Database;
import io.ebean.DatabaseFactory;
import io.ebean.Transaction;
import io.ebean.annotation.Platform;
import io.ebean.config.DatabaseConfig;
import io.ebean.datasource.DataSourceConfig;
import io.ebean.datasource.DataSourceFactory;
import io.ebean.datasource.DataSourcePool;
import io.ebean.migration.MigrationConfig;
import io.ebean.migration.MigrationRunner;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.stream.Collectors;

public class StorageContext {
    public static BKingdom templateKingdom;
    public static final Set<BKingdom> kingdoms;
    public static final Set<BRelation> relations;
    public static final Map<PlatformPlayer, User> players;
    private boolean initialized = false;
    private final KingdomCraftPlugin plugin;

    public StorageContext(KingdomCraftPlugin plugin) {
        this.plugin = plugin;
    }

    public void init(String url, String driver, String username, String password) {
        DataSourceConfig dataSourceConfig = new DataSourceConfig();
        dataSourceConfig.setUrl(url);
        dataSourceConfig.setDriver(driver);
        dataSourceConfig.setUsername(username);
        dataSourceConfig.setPassword(password);
        try {
            DataSourcePool pool = DataSourceFactory.create("kingdomcraft", dataSourceConfig);
            this.migrate(pool);
            this.connect(pool);
        }
        catch (Exception ex) {
            this.plugin.log(ex.getMessage(), Level.SEVERE);
            return;
        }
        kingdoms.addAll(new QBKingdom().findList());
        for (Kingdom kingdom : kingdoms) {
            if (kingdom.getId() != -1) continue;
            templateKingdom = (BKingdom)kingdom;
            StorageContext.templateKingdom.name = "template";
            kingdoms.remove(kingdom);
            break;
        }
        if (templateKingdom == null) {
            templateKingdom = new BKingdom();
            StorageContext.templateKingdom.id = -1;
            StorageContext.templateKingdom.name = "template";
            templateKingdom.setDisplay("&f{kingdom_name}");
            templateKingdom.setPrefix("&7[&f{kingdom_name}&7]");
            Rank member = templateKingdom.createRank("member");
            member.setDisplay("&7Member");
            member.setLevel(0);
            member.setPrefix("&7[Member]");
            Rank rank = templateKingdom.createRank("duke");
            rank.setDisplay("&2Duke");
            rank.setLevel(20);
            rank.setPrefix("&7[&2Duke&7]");
            Rank king = templateKingdom.createRank("king");
            king.setDisplay("&6King");
            king.setLevel(30);
            king.setPrefix("&7[&6King&7]");
            this.saveAsync(templateKingdom, member, rank, king).thenRun(() -> {
                templateKingdom.setDefaultRank(member);
                this.saveAsync(templateKingdom);
            });
        }
        new QBRelation().findList().forEach(rel -> {
            this.reassign((Relation)rel);
            relations.add((BRelation)rel);
        });
        this.initialized = true;
    }

    private void migrate(DataSourcePool pool) throws SQLException {
        MigrationConfig config = new MigrationConfig();
        Connection conn = pool.getConnection();
        String platform = conn.getMetaData().getDatabaseProductName().toLowerCase();
        config.setMigrationPath("dbmigration/" + platform);
        MigrationRunner runner = new MigrationRunner(config);
        runner.run(conn);
    }

    private void connect(DataSourcePool pool) {
        DatabaseConfig config = new DatabaseConfig();
        config.setDataSource(pool);
        config.setRegister(true);
        config.setDefaultServer(false);
        config.setName("kingdomcraft");
        config.addClass(BKingdom.class);
        config.addClass(BKingdomAttribute.class);
        config.addClass(BKingdomInvite.class);
        config.addClass(BRank.class);
        config.addClass(BRankAttribute.class);
        config.addClass(BRankPermissionGroup.class);
        config.addClass(BRelation.class);
        config.addClass(BUser.class);
        config.addClass(BUserChatChannel.class);
        config.addClass(BUserAttribute.class);
        config.addClass(PlatformLocationConverter.class);
        config.addClass(ItemConverter.class);
        DatabaseFactory.create(config);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void stop() {
        DB.byName("kingdomcraft").shutdown(true, true);
    }

    public void registerDumpCommand(KingdomCraftImpl kdc) {
        Database db = DB.byName("kingdomcraft");
        if (db.getPlatform() == Platform.H2) {
            kdc.getCommandManager().addCommand(new SqlDumpCommand(kdc));
        }
    }

    public Set<Kingdom> getKingdoms() {
        return new HashSet<Kingdom>(kingdoms);
    }

    public Kingdom getKingdom(String name) {
        return kingdoms.stream().filter(k -> k.getName().equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    public Kingdom getKingdom(long id) {
        return kingdoms.stream().filter(k -> (long)k.getId() == id).findFirst().orElse(null);
    }

    public Kingdom createKingdom(String name) {
        BKingdom kingdom = new BKingdom();
        kingdom.name = name;
        kingdoms.add(kingdom);
        return kingdom;
    }

    public Kingdom getTemplateKingdom() {
        return templateKingdom;
    }

    public Set<Relation> getRelations(Kingdom kingdom) {
        return relations.stream().filter(r -> !r.isRequest()).filter(r -> ((Object)r.kingdom).equals(kingdom) || ((Object)r.otherKingdom).equals(kingdom)).collect(Collectors.toSet());
    }

    public Relation getRelation(Kingdom kingdom, Kingdom other) {
        return relations.stream().filter(r -> !r.isRequest()).filter(r -> ((Object)r.kingdom).equals(kingdom) && ((Object)r.otherKingdom).equals(other) || ((Object)r.kingdom).equals(other) && ((Object)r.otherKingdom).equals(kingdom)).findFirst().orElse(null);
    }

    public void setRelation(Kingdom kingdom, Kingdom other, RelationType type) {
        Relation oldrel = this.getRelation(kingdom, other);
        if (oldrel != null) {
            relations.remove(oldrel);
            oldrel.delete();
        }
        Set requests = relations.stream().filter(Relation::isRequest).filter(r -> ((Object)r.kingdom).equals(kingdom) && ((Object)r.otherKingdom).equals(other) || ((Object)r.otherKingdom).equals(kingdom) && ((Object)r.kingdom).equals(other)).collect(Collectors.toSet());
        relations.removeAll(requests);
        this.deleteAsync(requests);
        if (type == RelationType.NEUTRAL) {
            return;
        }
        BRelation newrel = this.createRelation(kingdom, other, type, false);
        relations.add(newrel);
        this.saveAsync(newrel);
    }

    public void addRelationRequest(Kingdom kingdom, Kingdom other, RelationType type) {
        this.removeRelationRequest(kingdom, other);
        BRelation rel = this.createRelation(kingdom, other, type, true);
        relations.add(rel);
        this.saveAsync(rel);
    }

    public Relation getRelationRequest(Kingdom kingdom, Kingdom other) {
        return relations.stream().filter(Relation::isRequest).filter(r -> ((Object)r.kingdom).equals(kingdom) && ((Object)r.otherKingdom).equals(other)).findFirst().orElse(null);
    }

    public void removeRelationRequest(Kingdom kingdom, Kingdom other) {
        Relation rel = this.getRelationRequest(kingdom, other);
        if (rel == null) {
            return;
        }
        relations.remove(rel);
        this.deleteAsync(rel);
    }

    private BRelation createRelation(Kingdom kingdom, Kingdom other, RelationType type, boolean isRequest) {
        BRelation rel = new BRelation();
        rel.kingdom = (BKingdom)kingdom;
        rel.otherKingdom = (BKingdom)other;
        rel.relation = type.getId();
        rel.isRequest = isRequest;
        return rel;
    }

    private void reassign(Relation relation) {
        BRelation brel = (BRelation)relation;
        brel.kingdom = (BKingdom)this.getKingdom(brel.kingdom.getName());
        brel.otherKingdom = (BKingdom)this.getKingdom(brel.otherKingdom.getName());
    }

    public void clearUsers() {
        new QBUser().delete();
        for (User user : players.values()) {
            user.setKingdom(null);
            ((BUser)user).insert();
        }
        for (BKingdom kingdom : kingdoms) {
            kingdom.resetMemberCount();
        }
        this.saveAsync(kingdoms);
    }

    public void purgeUsers() {
        ((QBUser)new QBUser()._updatedAt().before(Instant.now().minus(2L, ChronoUnit.WEEKS))).delete();
    }

    public Set<User> getOnlineUsers() {
        return new HashSet<User>(players.values());
    }

    public User getOnlineUser(String name) {
        return players.values().stream().filter(u -> u.getName().equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    public User getOnlineUser(UUID uuid) {
        return players.values().stream().filter(u -> u.getUniqueId().equals(uuid)).findFirst().orElse(null);
    }

    public CompletableFuture<List<User>> getUsers() {
        return this.plugin.getScheduler().makeAsyncFuture(() -> {
            List<BUser> users = new QBUser().findList();
            users.forEach(this::reassign);
            return users.stream().map(u -> u).collect(Collectors.toList());
        });
    }

    public CompletableFuture<User> getUser(String name) {
        User user = this.getOnlineUser(name);
        if (user != null) {
            return CompletableFuture.completedFuture(user);
        }
        return this.reassign(this.plugin.getScheduler().makeAsyncFuture(() -> (BUser)new QBUser()._name().ieq(name).findOne()));
    }

    public CompletableFuture<User> getUser(UUID uuid) {
        User user = this.getOnlineUser(uuid);
        if (user != null) {
            return CompletableFuture.completedFuture(user);
        }
        return this.reassign(this.plugin.getScheduler().makeAsyncFuture(() -> (BUser)((QBUser)new QBUser()._id().eq(uuid.toString())).findOne()));
    }

    public User createUser(UUID uuid, String name) {
        BUser user = new BUser();
        user.id = uuid.toString();
        user.name = name;
        return user;
    }

    public void updateName(User user, String name) {
        BUser buser = (BUser)user;
        buser.setName(name);
        this.saveAsync(buser);
    }

    public void updateUUID(User user, UUID id) {
        BUser buser = (BUser)user;
        ((QBUser)new QBUser()._id().eq(buser.id)).asUpdate().set("id", id.toString()).update();
        buser.setUUID(id);
        this.saveAsync(buser);
    }

    public void login(User user) {
        BUser buser = (BUser)user;
        buser.setLastOnlineAt(Instant.now());
        this.saveAsync(buser);
    }

    private CompletableFuture<User> reassign(CompletableFuture<User> future) {
        return future.thenApply(u -> {
            if (u != null) {
                this.reassign((User)u);
            }
            return u;
        });
    }

    private void reassign(User user) {
        BUser buser = (BUser)user;
        if (buser.kingdom != null) {
            buser.kingdom = (BKingdom)this.getKingdom(buser.kingdom.getName());
            if (buser.rank != null) {
                buser.rank = (BRank)buser.kingdom.getRank(buser.rank.getName());
            }
        }
        for (BKingdomInvite ki : buser.kingdomInvites) {
            ki.kingdom = (BKingdom)this.getKingdom(ki.kingdom.getName());
        }
    }

    public void addPlayer(PlatformPlayer player, User user) {
        players.put(player, user);
    }

    public void removePlayer(PlatformPlayer player) {
        players.remove(player);
    }

    public Set<PlatformPlayer> getPlayers() {
        return new HashSet<PlatformPlayer>(players.keySet());
    }

    public PlatformPlayer getPlayer(UUID uuid) {
        return players.keySet().stream().filter(p -> p.getUniqueId().equals(uuid)).findFirst().orElse(null);
    }

    public PlatformPlayer getPlayer(User user) {
        return this.getPlayer(user.getUniqueId());
    }

    public PlatformPlayer getPlayer(String name) {
        return players.keySet().stream().filter(p -> p.getName().equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    public CompletableFuture<Void> saveAsync(Model ... models) {
        return this.saveAsync(Arrays.asList(models));
    }

    public <T extends Model> CompletableFuture<Void> saveAsync(Collection<T> models) {
        return this.plugin.getScheduler().makeAsyncFuture(() -> this.save(models)).exceptionally(ex -> {
            if (ex != null) {
                ex.printStackTrace();
                this.plugin.log(ex.getMessage(), Level.SEVERE);
            }
            return null;
        });
    }

    private <T extends Model> void save(Collection<T> models) {
        try (Transaction transaction = DB.byName("kingdomcraft").beginTransaction();){
            for (Model m3 : models) {
                m3.save();
            }
            transaction.commit();
        }
    }

    public CompletableFuture<Void> deleteAsync(Model ... models) {
        return this.deleteAsync(Arrays.asList(models));
    }

    public <T extends Model> CompletableFuture<Void> deleteAsync(Collection<T> models) {
        return this.plugin.getScheduler().makeAsyncFuture(() -> this.delete(models)).exceptionally(ex -> {
            if (ex != null) {
                ex.printStackTrace();
                this.plugin.log(ex.getMessage(), Level.SEVERE);
            }
            return null;
        });
    }

    private <T extends Model> void delete(Collection<T> models) {
        try (Transaction transaction = DB.byName("kingdomcraft").beginTransaction();){
            for (Model m3 : models) {
                m3.delete();
            }
            transaction.commit();
        }
    }

    static {
        kingdoms = new CopyOnWriteArraySet<BKingdom>();
        relations = new CopyOnWriteArraySet<BRelation>();
        players = new ConcurrentHashMap<PlatformPlayer, User>();
    }
}

