/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.config;

import com.gufli.kingdomcraft.api.config.KingdomCraftConfig;
import com.gufli.kingdomcraft.api.domain.RelationType;
import com.gufli.kingdomcraft.common.config.Configuration;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class Config
implements KingdomCraftConfig {
    private List<String> commandAliases = Arrays.asList("k", "kd", "kdc", "kingdom");
    private int teleportDelay = 0;
    private String language = "en";
    private ZoneId timezone = ZoneId.systemDefault();
    private DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private DateTimeFormatter timeFormat = DateTimeFormatter.ofPattern("HH:mm");
    private DateTimeFormatter dateTimeFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
    private List<RelationType> friendlyFireRelations = new ArrayList<RelationType>();
    private boolean friendlyFire = false;
    private List<String> kingdomJoinCommands = new ArrayList<String>();
    private List<String> kingdomLeaveCommands = new ArrayList<String>();
    private List<String> kingdomCreateCommands = new ArrayList<String>();
    private List<String> kingdomDeleteCommands = new ArrayList<String>();
    private boolean respawnAtKingdom = true;
    private String joinMessage;
    private String leaveMessage;
    private String deathMessage;
    private String killMessage;
    private String killWeaponMessage;
    private String noKingdomPrefix;
    private String noKingdomSuffix;
    private String noKingdomDisplay;
    private boolean isChatEnabledInDisabledWorlds = false;
    private boolean showJoinAndLeaveMessagesKingdomOnly = false;
    private boolean updateDisplayNames = false;

    public void load(Configuration config) {
        if (config.contains("command-aliases")) {
            this.commandAliases = config.getStringList("command-aliases");
        }
        if (config.contains("teleport-delay")) {
            this.teleportDelay = config.getInt("teleport-delay");
        }
        if (config.contains("language")) {
            this.language = config.getString("language");
        }
        if (config.contains("timezone")) {
            try {
                this.timezone = ZoneId.of(config.getString("timezone"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (config.contains("date-format")) {
            try {
                this.dateFormat = DateTimeFormatter.ofPattern(config.getString("date-format"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (config.contains("time-format")) {
            try {
                this.timeFormat = DateTimeFormatter.ofPattern(config.getString("time-format"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String dateFormat = config.contains("date-format") ? config.getString("date-format") : "yyyy-MM-dd";
        String timeFormat = config.contains("time-format") ? config.getString("time-format") : "HH:mm";
        try {
            this.dateTimeFormat = DateTimeFormatter.ofPattern(dateFormat + " " + timeFormat);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (config.contains("friendly-fire-relationships")) {
            this.friendlyFireRelations = config.getStringList("friendly-fire-relationships").stream().map(s2 -> Arrays.stream(RelationType.values()).filter(rel -> rel.name().equalsIgnoreCase((String)s2)).findFirst().orElse(null)).filter(Objects::nonNull).collect(Collectors.toList());
        }
        if (config.contains("friendly-fire")) {
            this.friendlyFire = config.getBoolean("friendly-fire");
        }
        if (config.contains("events.kingdom-join")) {
            this.kingdomJoinCommands = config.getStringList("events.kingdom-join");
        }
        if (config.contains("events.kingdom-leave")) {
            this.kingdomLeaveCommands = config.getStringList("events.kingdom-leave");
        }
        if (config.contains("events.kingdom-create")) {
            this.kingdomCreateCommands = config.getStringList("events.kingdom-create");
        }
        if (config.contains("events.kingdom-delete")) {
            this.kingdomDeleteCommands = config.getStringList("events.kingdom-delete");
        }
        if (config.contains("respawn-at-kingdom")) {
            this.respawnAtKingdom = config.getBoolean("respawn-at-kingdom");
        }
        if (config.contains("messages.join")) {
            this.joinMessage = config.getString("messages.join");
        }
        if (config.contains("messages.leave")) {
            this.leaveMessage = config.getString("messages.leave");
        }
        if (config.contains("messages.death")) {
            this.deathMessage = config.getString("messages.death");
        }
        if (config.contains("messages.kill")) {
            this.killMessage = config.getString("messages.kill");
        }
        if (config.contains("messages.kill-weapon")) {
            this.killWeaponMessage = config.getString("messages.kill-weapon");
        }
        if (config.contains("nokingdom.prefix")) {
            this.noKingdomPrefix = config.getString("nokingdom.prefix");
        }
        if (config.contains("nokingdom.suffix")) {
            this.noKingdomSuffix = config.getString("nokingdom.suffix");
        }
        if (config.contains("nokingdom.display")) {
            this.noKingdomDisplay = config.getString("nokingdom.display");
        }
        if (config.contains("enable-chat-in-disabled-worlds")) {
            this.isChatEnabledInDisabledWorlds = config.getBoolean("enable-chat-in-disabled-worlds");
        }
        if (config.contains("join-and-leave-kingdom-only")) {
            this.showJoinAndLeaveMessagesKingdomOnly = config.getBoolean("join-and-leave-kingdom-only");
        }
        if (config.contains("update-display-names")) {
            this.updateDisplayNames = config.getBoolean("update-display-names");
        }
    }

    @Override
    public List<String> getCommandAliases() {
        return this.commandAliases;
    }

    @Override
    public int getTeleportDelay() {
        return this.teleportDelay;
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    @Override
    public ZoneId getTimeZone() {
        return this.timezone;
    }

    @Override
    public DateTimeFormatter getDateFormat() {
        return this.dateFormat;
    }

    @Override
    public DateTimeFormatter getTimeFormat() {
        return this.timeFormat;
    }

    @Override
    public DateTimeFormatter getDateTimeFormat() {
        return this.dateTimeFormat;
    }

    @Override
    public List<RelationType> getFriendlyFireRelationTypes() {
        return this.friendlyFireRelations;
    }

    @Override
    public boolean isFriendlyFireEnabled() {
        return this.friendlyFire;
    }

    @Override
    public List<String> getOnKingdomJoinCommands() {
        return this.kingdomJoinCommands;
    }

    @Override
    public List<String> getOnKingdomLeaveCommands() {
        return this.kingdomLeaveCommands;
    }

    @Override
    public List<String> getOnKingdomCreateCommands() {
        return this.kingdomCreateCommands;
    }

    @Override
    public List<String> getOnKingdomDeleteCommands() {
        return this.kingdomDeleteCommands;
    }

    @Override
    public boolean respawnAtKingdom() {
        return this.respawnAtKingdom;
    }

    @Override
    public String getOnJoinMessage() {
        return this.joinMessage;
    }

    @Override
    public String getOnLeaveMessage() {
        return this.leaveMessage;
    }

    @Override
    public String getOnDeathMessage() {
        return this.deathMessage;
    }

    @Override
    public String getOnKillMessage() {
        return this.killMessage;
    }

    @Override
    public String getOnKillWeaponMessage() {
        return this.killWeaponMessage;
    }

    @Override
    public String getNoKingdomPrefix() {
        return this.noKingdomPrefix;
    }

    @Override
    public String getNoKingdomSuffix() {
        return this.noKingdomSuffix;
    }

    @Override
    public String getNoKingdomDisplay() {
        return this.noKingdomDisplay;
    }

    @Override
    public boolean isChatEnabledInDisabledWorlds() {
        return this.isChatEnabledInDisabledWorlds;
    }

    @Override
    public boolean showJoinAndLeaveKingdomOnly() {
        return this.showJoinAndLeaveMessagesKingdomOnly;
    }

    @Override
    public boolean updateDisplayNames() {
        return this.updateDisplayNames;
    }
}

