/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.commands.tphere;

import com.gufli.kingdomcraft.api.domain.Kingdom;
import com.gufli.kingdomcraft.api.domain.User;
import com.gufli.kingdomcraft.api.entity.PlatformLocation;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.command.CommandBase;
import java.util.List;
import java.util.stream.Collectors;

public class TpHereOtherCommand
extends CommandBase {
    public TpHereOtherCommand(KingdomCraftImpl kdc) {
        super(kdc, "tphere", 1, true);
        this.setArgumentsHint("<kingdom>");
        this.setExplanationMessage(() -> kdc.getMessages().getMessage("cmdTpHereOtherExplanation"));
        this.setPermissions("kingdom.tphere.other");
    }

    @Override
    public List<String> autocomplete(PlatformPlayer player, String[] args) {
        return this.kdc.getKingdoms().stream().map(Kingdom::getName).collect(Collectors.toList());
    }

    @Override
    public void execute(PlatformSender sender, String[] args) {
        PlatformPlayer player = (PlatformPlayer)sender;
        Kingdom kingdom = this.kdc.getKingdom(args[0]);
        if (kingdom == null || kingdom.isTemplate()) {
            this.kdc.getMessages().send(sender, "cmdErrorKingdomNotExist", args[0]);
            return;
        }
        PlatformLocation loc = player.getLocation();
        for (PlatformPlayer p : this.kdc.getOnlinePlayers()) {
            User pu;
            if (p == sender || (pu = this.kdc.getUser(p)).getKingdom() != kingdom) continue;
            p.teleport(loc);
            this.kdc.getMessages().send((PlatformSender)p, "cmdTpHereTarget", player.getName());
        }
        this.kdc.getMessages().send((PlatformSender)player, "cmdTpHereOther", kingdom.getName());
    }
}

