/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.commands.tphere;

import com.gufli.kingdomcraft.api.domain.Kingdom;
import com.gufli.kingdomcraft.api.domain.User;
import com.gufli.kingdomcraft.api.entity.PlatformLocation;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.command.CommandBase;

public class TpHereCommand
extends CommandBase {
    public TpHereCommand(KingdomCraftImpl kdc) {
        super(kdc, "tphere", 0, true);
        this.setExplanationMessage(() -> kdc.getMessages().getMessage("cmdTpHereExplanation"));
        this.setPermissions("kingdom.tphere");
    }

    @Override
    public void execute(PlatformSender sender, String[] args) {
        PlatformPlayer player = (PlatformPlayer)sender;
        User user = this.kdc.getUser(player);
        Kingdom kingdom = user.getKingdom();
        if (kingdom == null) {
            this.kdc.getMessages().send(sender, "cmdErrorSenderNoKingdom", new String[0]);
            return;
        }
        PlatformLocation loc = player.getLocation();
        for (PlatformPlayer p : this.kdc.getOnlinePlayers()) {
            User pu;
            if (p == sender || (pu = this.kdc.getUser(p)).getKingdom() != kingdom) continue;
            p.teleport(loc);
            this.kdc.getMessages().send((PlatformSender)p, "cmdTpHereTarget", player.getName());
        }
        this.kdc.getMessages().send((PlatformSender)player, "cmdTpHere", new String[0]);
    }
}

