/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.commands.spawn;

import com.gufli.kingdomcraft.api.domain.Kingdom;
import com.gufli.kingdomcraft.api.entity.PlatformLocation;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.command.CommandBase;
import java.util.List;
import java.util.stream.Collectors;

public class TpSpawnOtherCommand
extends CommandBase {
    public TpSpawnOtherCommand(KingdomCraftImpl kdc) {
        super(kdc, "tpspawn", 2);
        this.setArgumentsHint("<player> <kingdom>");
        this.setExplanationMessage(() -> kdc.getMessages().getMessage("cmdTpSpawnOtherExplanation"));
        this.setPermissions("kingdom.tpspawn.other");
    }

    @Override
    public List<String> autocomplete(PlatformPlayer sender, String[] args) {
        if (args.length == 1) {
            return this.kdc.getOnlinePlayers().stream().map(PlatformPlayer::getName).collect(Collectors.toList());
        }
        if (args.length == 2) {
            return this.kdc.getKingdoms().stream().map(Kingdom::getName).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    public void execute(PlatformSender sender, String[] args) {
        PlatformPlayer target = this.kdc.getPlayer(args[0]);
        if (target == null) {
            this.kdc.getMessages().send(sender, "cmdErrorNotOnline", args[0]);
            return;
        }
        Kingdom kingdom = this.kdc.getKingdom(args[1]);
        if (kingdom == null || kingdom.isTemplate()) {
            this.kdc.getMessages().send(sender, "cmdErrorKingdomNotExist", args[1]);
            return;
        }
        PlatformLocation loc = kingdom.getSpawn();
        if (loc == null) {
            this.kdc.getMessages().send(sender, "cmdSpawnOtherNotExists", kingdom.getName());
            return;
        }
        target.teleport(loc);
        this.kdc.getMessages().send(sender, "cmdTpSpawn", target.getName(), kingdom.getName());
        this.kdc.getMessages().send((PlatformSender)target, "cmdTpSpawnTarget", kingdom.getName());
    }
}

