/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.commands.spawn;

import com.gufli.kingdomcraft.api.domain.Kingdom;
import com.gufli.kingdomcraft.api.entity.PlatformLocation;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.command.CommandBase;
import java.util.List;
import java.util.stream.Collectors;

public class TpSpawnCommand
extends CommandBase {
    public TpSpawnCommand(KingdomCraftImpl kdc) {
        super(kdc, "tpspawn", 1);
        this.setArgumentsHint("<player>");
        this.setExplanationMessage(() -> kdc.getMessages().getMessage("cmdTpSpawnExplanation"));
        this.setPermissions("kingdom.tpspawn");
    }

    @Override
    public List<String> autocomplete(PlatformPlayer sender, String[] args) {
        if (args.length == 1) {
            return this.kdc.getKingdoms().stream().map(Kingdom::getName).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    public void execute(PlatformSender sender, String[] args) {
        PlatformPlayer target = this.kdc.getPlayer(args[0]);
        if (target == null) {
            this.kdc.getMessages().send(sender, "cmdErrorNotOnline", args[0]);
            return;
        }
        Kingdom kingdom = this.kdc.getUser(target).getKingdom();
        if (kingdom == null) {
            this.kdc.getMessages().send(sender, "cmdErrorTargetNoKingdom", target.getName());
            return;
        }
        PlatformLocation loc = kingdom.getSpawn();
        if (loc == null) {
            this.kdc.getMessages().send(sender, "cmdSpawnOtherNotExists", kingdom.getName());
            return;
        }
        target.teleport(loc);
        this.kdc.getMessages().send(sender, "cmdTpSpawn", target.getName(), kingdom.getName());
        this.kdc.getMessages().send((PlatformSender)target, "cmdTpSpawnTarget", kingdom.getName());
    }
}

