/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.commands.spawn;

import com.gufli.kingdomcraft.api.domain.Kingdom;
import com.gufli.kingdomcraft.api.entity.PlatformLocation;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.command.CommandBase;
import java.util.List;
import java.util.stream.Collectors;

public class TpAllSpawnOtherCommand
extends CommandBase {
    public TpAllSpawnOtherCommand(KingdomCraftImpl kdc) {
        super(kdc, "tpallspawn", 1);
        this.setArgumentsHint("<kingdom>");
        this.setExplanationMessage(() -> kdc.getMessages().getMessage("cmdTpAllSpawnOtherExplanation"));
        this.setPermissions("kingdom.tpallspawn.other");
    }

    @Override
    public List<String> autocomplete(PlatformPlayer sender, String[] args) {
        if (args.length == 1) {
            List<String> names = this.kdc.getKingdoms().stream().map(Kingdom::getName).collect(Collectors.toList());
            names.add("ALL");
            return names;
        }
        return null;
    }

    @Override
    public void execute(PlatformSender sender, String[] args) {
        if (args[0].equalsIgnoreCase("ALL")) {
            for (Kingdom kd : this.kdc.getKingdoms()) {
                PlatformLocation loc = kd.getSpawn();
                if (loc == null) {
                    this.kdc.getMessages().send(sender, "cmdSpawnOtherNotExists", kd.getName());
                    continue;
                }
                this.teleport(kd);
            }
            this.kdc.getMessages().send(sender, "cmdTpAllSpawn", "ALL");
            return;
        }
        Kingdom kingdom = this.kdc.getKingdom(args[0]);
        if (kingdom == null || kingdom.isTemplate()) {
            this.kdc.getMessages().send(sender, "cmdErrorKingdomNotExist", args[1]);
            return;
        }
        PlatformLocation loc = kingdom.getSpawn();
        if (loc == null) {
            this.kdc.getMessages().send(sender, "cmdSpawnOtherNotExists", kingdom.getName());
            return;
        }
        this.kdc.getMessages().send(sender, "cmdTpAllSpawn", kingdom.getName());
        this.teleport(kingdom);
    }

    private void teleport(Kingdom kingdom) {
        PlatformLocation loc = kingdom.getSpawn();
        for (PlatformPlayer pp : this.kdc.getOnlinePlayers()) {
            if (!pp.getUser().getKingdom().equals(kingdom)) continue;
            pp.teleport(loc);
            this.kdc.getMessages().send((PlatformSender)pp, "cmdTpAllSpawnTarget", kingdom.getName());
        }
    }
}

