/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.commands.spawn;

import com.gufli.kingdomcraft.api.domain.Kingdom;
import com.gufli.kingdomcraft.api.entity.PlatformLocation;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.command.CommandBase;
import java.util.List;

public class TpAllSpawnCommand
extends CommandBase {
    public TpAllSpawnCommand(KingdomCraftImpl kdc) {
        super(kdc, "tpallspawn", 0);
        this.setExplanationMessage(() -> kdc.getMessages().getMessage("cmdTpAllSpawnExplanation"));
        this.setPermissions("kingdom.tpallspawn");
    }

    @Override
    public List<String> autocomplete(PlatformPlayer sender, String[] args) {
        return null;
    }

    @Override
    public void execute(PlatformSender sender, String[] args) {
        Kingdom kingdom = ((PlatformPlayer)sender).getUser().getKingdom();
        if (kingdom == null) {
            this.kdc.getMessages().send(sender, "cmdErrorSenderNoKingdom", new String[0]);
            return;
        }
        PlatformLocation loc = kingdom.getSpawn();
        if (loc == null) {
            this.kdc.getMessages().send(sender, "cmdSpawnNotExists", new String[0]);
            return;
        }
        this.kdc.getMessages().send(sender, "cmdTpAllSpawn", kingdom.getName());
        for (PlatformPlayer pp : this.kdc.getOnlinePlayers()) {
            if (!pp.getUser().getKingdom().equals(kingdom)) continue;
            pp.teleport(loc);
            this.kdc.getMessages().send((PlatformSender)pp, "cmdTpAllSpawnTarget", kingdom.getName());
        }
    }
}

