/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.commands.spawn;

import com.gufli.kingdomcraft.api.domain.Kingdom;
import com.gufli.kingdomcraft.api.domain.User;
import com.gufli.kingdomcraft.api.entity.PlatformLocation;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.command.CommandBase;
import com.gufli.kingdomcraft.common.util.Teleporter;
import java.text.DecimalFormat;

public class SpawnCommand
extends CommandBase {
    public SpawnCommand(KingdomCraftImpl kdc) {
        super(kdc, "spawn", 0, true);
        this.addCommand("s");
        this.setExplanationMessage(() -> kdc.getMessages().getMessage("cmdSpawnExplanation"));
        this.setPermissions("kingdom.spawn");
    }

    @Override
    public void execute(PlatformSender sender, String[] args) {
        User user = this.kdc.getUser((PlatformPlayer)sender);
        Kingdom kingdom = user.getKingdom();
        if (kingdom == null) {
            this.kdc.getMessages().send(sender, "cmdErrorSenderNoKingdom", new String[0]);
            return;
        }
        PlatformLocation loc = kingdom.getSpawn();
        if (loc == null) {
            this.kdc.getMessages().send(sender, "cmdSpawnNotExists", new String[0]);
            return;
        }
        Teleporter.teleport((PlatformPlayer)sender, loc).thenRun(() -> {
            DecimalFormat df = new DecimalFormat("#");
            String str = df.format(loc.getX()) + ", " + df.format(loc.getY()) + ", " + df.format(loc.getZ());
            this.kdc.getMessages().send(sender, "cmdSpawn", str);
        });
    }
}

