/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.commands.spawn;

import com.gufli.kingdomcraft.api.domain.Kingdom;
import com.gufli.kingdomcraft.api.entity.PlatformLocation;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.command.CommandBase;
import java.text.DecimalFormat;
import java.util.List;
import java.util.stream.Collectors;

public class SetSpawnOtherCommand
extends CommandBase {
    public SetSpawnOtherCommand(KingdomCraftImpl kdc) {
        super(kdc, "setspawn", 1, true);
        this.setArgumentsHint("<kingdom>");
        this.setExplanationMessage(() -> kdc.getMessages().getMessage("cmdSetSpawnOtherExplanation"));
        this.setPermissions("kingdom.setspawn.other");
    }

    @Override
    public List<String> autocomplete(PlatformPlayer sender, String[] args) {
        if (args.length == 1) {
            return this.kdc.getKingdoms().stream().map(Kingdom::getName).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    public void execute(PlatformSender sender, String[] args) {
        Kingdom kingdom = this.kdc.getKingdom(args[0]);
        if (kingdom == null || kingdom.isTemplate()) {
            this.kdc.getMessages().send(sender, "cmdErrorKingdomNotExist", args[0]);
            return;
        }
        PlatformLocation loc = ((PlatformPlayer)sender).getLocation();
        kingdom.setSpawn(loc);
        this.kdc.saveAsync(kingdom);
        DecimalFormat df = new DecimalFormat("#");
        String str = df.format(loc.getX()) + ", " + df.format(loc.getY()) + ", " + df.format(loc.getZ());
        this.kdc.getMessages().send(sender, "cmdSetSpawnOther", kingdom.getName(), str);
    }
}

