/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.commands.spawn;

import com.gufli.kingdomcraft.api.domain.Kingdom;
import com.gufli.kingdomcraft.api.domain.User;
import com.gufli.kingdomcraft.api.entity.PlatformLocation;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.command.CommandBase;
import java.text.DecimalFormat;

public class SetSpawnCommand
extends CommandBase {
    public SetSpawnCommand(KingdomCraftImpl kdc) {
        super(kdc, "setspawn", 0, true);
        this.setExplanationMessage(() -> kdc.getMessages().getMessage("cmdSetSpawnExplanation"));
        this.setPermissions("kingdom.setspawn");
    }

    @Override
    public void execute(PlatformSender sender, String[] args) {
        User user = this.kdc.getUser((PlatformPlayer)sender);
        Kingdom kingdom = user.getKingdom();
        if (kingdom == null) {
            this.kdc.getMessages().send(sender, "cmdErrorSenderNoKingdom", new String[0]);
            return;
        }
        PlatformLocation loc = ((PlatformPlayer)sender).getLocation();
        kingdom.setSpawn(loc);
        this.kdc.saveAsync(kingdom);
        DecimalFormat df = new DecimalFormat("#");
        String str = df.format(loc.getX()) + ", " + df.format(loc.getY()) + ", " + df.format(loc.getZ());
        this.kdc.getMessages().send(sender, "cmdSetSpawn", str);
    }
}

