/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.commands.relations;

import com.gufli.kingdomcraft.api.domain.Kingdom;
import com.gufli.kingdomcraft.api.domain.Relation;
import com.gufli.kingdomcraft.api.domain.RelationType;
import com.gufli.kingdomcraft.api.domain.User;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.command.CommandBase;
import java.util.List;
import java.util.stream.Collectors;

public class TruceCommand
extends CommandBase {
    public TruceCommand(KingdomCraftImpl kdc) {
        super(kdc, "truce", 1, true);
        this.setArgumentsHint("<kingdom>");
        this.setExplanationMessage(() -> kdc.getMessages().getMessage("cmdTruceExplanation"));
        this.setPermissions("kingdom.truce");
    }

    @Override
    public List<String> autocomplete(PlatformPlayer player, String[] args) {
        User user;
        Kingdom kingdom;
        if (args.length == 1 && (kingdom = (user = this.kdc.getUser(player)).getKingdom()) != null) {
            return this.kdc.getKingdoms().stream().filter(k -> k != kingdom).filter(k -> {
                Relation rel = this.kdc.getRelation(kingdom, (Kingdom)k);
                return rel != null && rel.getType() == RelationType.ENEMY;
            }).map(Kingdom::getName).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    public void execute(PlatformSender sender, String[] args) {
        User user = this.kdc.getUser((PlatformPlayer)sender);
        Kingdom kingdom = user.getKingdom();
        if (kingdom == null) {
            this.kdc.getMessages().send(sender, "cmdErrorSenderNoKingdom", new String[0]);
            return;
        }
        Kingdom target = this.kdc.getKingdom(args[0]);
        if (target == null) {
            this.kdc.getMessages().send(sender, "cmdErrorKingdomNotExist", args[0]);
            return;
        }
        if (target == kingdom) {
            this.kdc.getMessages().send(sender, "cmdErrorSameKingdom", new String[0]);
            return;
        }
        Relation existing = this.kdc.getRelation(kingdom, target);
        if (existing != null && existing.getType() == RelationType.TRUCE) {
            this.kdc.getMessages().send(sender, "cmdTruceAlready", target.getName());
            return;
        }
        if (existing == null || existing.getType() != RelationType.ENEMY) {
            this.kdc.getMessages().send(sender, "cmdTruceNotEnemies", target.getName());
            return;
        }
        Relation request = this.kdc.getRelationRequest(target, kingdom);
        if (request == null || request.getType() != RelationType.TRUCE) {
            request = this.kdc.getRelationRequest(kingdom, target);
            if (request != null && request.getType() == RelationType.TRUCE) {
                this.kdc.getMessages().send(sender, "cmdTruceRequestAlready", target.getName());
                return;
            }
            this.kdc.addRelationRequest(kingdom, target, RelationType.TRUCE);
            this.kdc.getMessages().send(sender, "cmdTruceRequest", target.getName());
            for (PlatformPlayer member : this.kdc.getOnlinePlayers()) {
                if (this.kdc.getUser(member).getKingdom() != target || !member.has("kingdom.truce")) continue;
                this.kdc.getMessages().send((PlatformSender)member, "cmdTruceRequestTarget", kingdom.getName());
            }
            return;
        }
        this.kdc.setRelation(target, kingdom, RelationType.TRUCE);
        for (PlatformPlayer member : this.kdc.getOnlinePlayers()) {
            Kingdom kd = member.getUser().getKingdom();
            if (kd == kingdom) {
                this.kdc.getMessages().send((PlatformSender)member, "cmdTruce", target.getName());
                continue;
            }
            if (kd != target) continue;
            this.kdc.getMessages().send((PlatformSender)member, "cmdTruce", kingdom.getName());
        }
    }
}

