/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.commands.relations;

import com.gufli.kingdomcraft.api.domain.Kingdom;
import com.gufli.kingdomcraft.api.domain.Relation;
import com.gufli.kingdomcraft.api.domain.RelationType;
import com.gufli.kingdomcraft.api.domain.User;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.command.CommandBase;
import java.util.List;
import java.util.stream.Collectors;

public class NeutralCommand
extends CommandBase {
    public NeutralCommand(KingdomCraftImpl kdc) {
        super(kdc, "neutral", 1, true);
        this.setArgumentsHint("<kingdom>");
        this.setExplanationMessage(() -> kdc.getMessages().getMessage("cmdNeutralExplanation"));
        this.setPermissions("kingdom.neutral");
    }

    @Override
    public List<String> autocomplete(PlatformPlayer player, String[] args) {
        User user;
        Kingdom kingdom;
        if (args.length == 1 && (kingdom = (user = this.kdc.getUser(player)).getKingdom()) != null) {
            return this.kdc.getKingdoms().stream().filter(k -> k != kingdom).map(Kingdom::getName).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    public void execute(PlatformSender sender, String[] args) {
        Relation request;
        User user = this.kdc.getUser((PlatformPlayer)sender);
        Kingdom kingdom = user.getKingdom();
        if (kingdom == null) {
            this.kdc.getMessages().send(sender, "cmdErrorSenderNoKingdom", new String[0]);
            return;
        }
        Kingdom target = this.kdc.getKingdom(args[0]);
        if (target == null) {
            this.kdc.getMessages().send(sender, "cmdErrorKingdomNotExist", args[0]);
            return;
        }
        if (target == kingdom) {
            this.kdc.getMessages().send(sender, "cmdErrorSameKingdom", new String[0]);
            return;
        }
        Relation existing = this.kdc.getRelation(kingdom, target);
        if (existing == null || existing.getType() == RelationType.NEUTRAL) {
            this.kdc.getMessages().send(sender, "cmdNeutralAlready", target.getName());
            return;
        }
        if (!(existing.getType() != RelationType.ENEMY && existing.getType() != RelationType.TRUCE || (request = this.kdc.getRelationRequest(target, kingdom)) != null && request.getType() == RelationType.NEUTRAL)) {
            request = this.kdc.getRelationRequest(kingdom, target);
            if (request != null && request.getType() == RelationType.NEUTRAL) {
                this.kdc.getMessages().send(sender, "cmdNeutralRequestAlready", target.getName());
                return;
            }
            this.kdc.addRelationRequest(kingdom, target, RelationType.NEUTRAL);
            this.kdc.getMessages().send(sender, "cmdNeutralRequest", target.getName());
            for (PlatformPlayer member : this.kdc.getOnlinePlayers()) {
                if (this.kdc.getUser(member).getKingdom() != target || !member.hasPermission("kingdom.neutral")) continue;
                this.kdc.getMessages().send((PlatformSender)member, "cmdNeutralRequestTarget", kingdom.getName());
            }
            return;
        }
        this.kdc.setRelation(target, kingdom, RelationType.NEUTRAL);
        for (PlatformPlayer member : this.kdc.getOnlinePlayers()) {
            Kingdom kd = member.getUser().getKingdom();
            if (kd == kingdom) {
                this.kdc.getMessages().send((PlatformSender)member, "cmdNeutral", target.getName());
                continue;
            }
            if (kd != target) continue;
            this.kdc.getMessages().send((PlatformSender)member, "cmdNeutral", kingdom.getName());
        }
    }
}

