/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.commands.relations;

import com.gufli.kingdomcraft.api.domain.Kingdom;
import com.gufli.kingdomcraft.api.domain.Relation;
import com.gufli.kingdomcraft.api.domain.RelationType;
import com.gufli.kingdomcraft.api.domain.User;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.command.CommandBase;
import java.util.List;
import java.util.stream.Collectors;

public class EnemyCommand
extends CommandBase {
    public EnemyCommand(KingdomCraftImpl kdc) {
        super(kdc, "enemy", 1, true);
        this.setArgumentsHint("<kingdom>");
        this.setExplanationMessage(() -> kdc.getMessages().getMessage("cmdEnemyExplanation"));
        this.setPermissions("kingdom.enemy");
    }

    @Override
    public List<String> autocomplete(PlatformPlayer player, String[] args) {
        User user;
        Kingdom kingdom;
        if (args.length == 1 && (kingdom = (user = this.kdc.getUser(player)).getKingdom()) != null) {
            return this.kdc.getKingdoms().stream().filter(k -> k != kingdom).map(Kingdom::getName).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    public void execute(PlatformSender sender, String[] args) {
        User user = this.kdc.getUser((PlatformPlayer)sender);
        Kingdom kingdom = user.getKingdom();
        if (kingdom == null) {
            this.kdc.getMessages().send(sender, "cmdErrorSenderNoKingdom", new String[0]);
            return;
        }
        Kingdom target = this.kdc.getKingdom(args[0]);
        if (target == null) {
            this.kdc.getMessages().send(sender, "cmdErrorKingdomNotExist", args[0]);
            return;
        }
        if (target == kingdom) {
            this.kdc.getMessages().send(sender, "cmdErrorSameKingdom", new String[0]);
            return;
        }
        Relation existing = this.kdc.getRelation(kingdom, target);
        if (existing != null && existing.getType() == RelationType.ENEMY) {
            this.kdc.getMessages().send(sender, "cmdEnemyAlready", target.getName());
            return;
        }
        this.kdc.setRelation(kingdom, target, RelationType.ENEMY);
        for (PlatformPlayer member : this.kdc.getOnlinePlayers()) {
            Kingdom kd = member.getUser().getKingdom();
            if (kd == kingdom) {
                this.kdc.getMessages().send((PlatformSender)member, "cmdEnemy", target.getName());
                continue;
            }
            if (kd != target) continue;
            this.kdc.getMessages().send((PlatformSender)member, "cmdEnemy", kingdom.getName());
        }
    }
}

