/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.commands.relations;

import com.gufli.kingdomcraft.api.domain.Kingdom;
import com.gufli.kingdomcraft.api.domain.Relation;
import com.gufli.kingdomcraft.api.domain.RelationType;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.command.CommandBase;
import java.util.List;
import java.util.stream.Collectors;

public class AllyOtherCommand
extends CommandBase {
    public AllyOtherCommand(KingdomCraftImpl kdc) {
        super(kdc, "ally", 2);
        this.setArgumentsHint("<kingdom1> <kingdom2>");
        this.setExplanationMessage(() -> kdc.getMessages().getMessage("cmdAllyOtherExplanation"));
        this.setPermissions("kingdom.ally.other");
    }

    @Override
    public List<String> autocomplete(PlatformPlayer player, String[] args) {
        if (args.length == 1) {
            return this.kdc.getKingdoms().stream().map(Kingdom::getName).collect(Collectors.toList());
        }
        if (args.length == 2) {
            Kingdom kingdom = this.kdc.getKingdom(args[0]);
            return this.kdc.getKingdoms().stream().filter(k -> k != kingdom).map(Kingdom::getName).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    public void execute(PlatformSender sender, String[] args) {
        Kingdom kingdom = this.kdc.getKingdom(args[0]);
        if (kingdom == null) {
            this.kdc.getMessages().send(sender, "cmdErrorKingdomNotExist", args[0]);
            return;
        }
        Kingdom target = this.kdc.getKingdom(args[1]);
        if (target == null) {
            this.kdc.getMessages().send(sender, "cmdErrorKingdomNotExist", args[1]);
            return;
        }
        if (target == kingdom) {
            this.kdc.getMessages().send(sender, "cmdErrorSameKingdom", new String[0]);
            return;
        }
        Relation existing = this.kdc.getRelation(kingdom, target);
        if (existing != null && existing.getType() == RelationType.ALLY) {
            this.kdc.getMessages().send(sender, "cmdAllyOtherAlready", kingdom.getName(), target.getName());
            return;
        }
        this.kdc.setRelation(kingdom, target, RelationType.ALLY);
        this.kdc.getMessages().send(sender, "cmdAllyOther", kingdom.getName(), target.getName());
        for (PlatformPlayer member : this.kdc.getOnlinePlayers()) {
            Kingdom kd = member.getUser().getKingdom();
            if (kd == kingdom) {
                this.kdc.getMessages().send((PlatformSender)member, "cmdAlly", target.getName());
                continue;
            }
            if (kd != target) continue;
            this.kdc.getMessages().send((PlatformSender)member, "cmdAlly", kingdom.getName());
        }
    }
}

