/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.commands.relations;

import com.gufli.kingdomcraft.api.domain.Kingdom;
import com.gufli.kingdomcraft.api.domain.Relation;
import com.gufli.kingdomcraft.api.domain.RelationType;
import com.gufli.kingdomcraft.api.domain.User;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.command.CommandBase;
import java.util.List;
import java.util.stream.Collectors;

public class AllyCommand
extends CommandBase {
    public AllyCommand(KingdomCraftImpl kdc) {
        super(kdc, "ally", 1, true);
        this.setArgumentsHint("<kingdom>");
        this.setExplanationMessage(() -> kdc.getMessages().getMessage("cmdAllyExplanation"));
        this.setPermissions("kingdom.ally");
    }

    @Override
    public List<String> autocomplete(PlatformPlayer player, String[] args) {
        User user;
        Kingdom kingdom;
        if (args.length == 1 && (kingdom = (user = this.kdc.getUser(player)).getKingdom()) != null) {
            return this.kdc.getKingdoms().stream().filter(k -> k != kingdom).map(Kingdom::getName).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    public void execute(PlatformSender sender, String[] args) {
        User user = this.kdc.getUser((PlatformPlayer)sender);
        Kingdom kingdom = user.getKingdom();
        if (kingdom == null) {
            this.kdc.getMessages().send(sender, "cmdErrorSenderNoKingdom", new String[0]);
            return;
        }
        Kingdom target = this.kdc.getKingdom(args[0]);
        if (target == null) {
            this.kdc.getMessages().send(sender, "cmdErrorKingdomNotExist", args[0]);
            return;
        }
        if (target == kingdom) {
            this.kdc.getMessages().send(sender, "cmdErrorSameKingdom", new String[0]);
            return;
        }
        Relation existing = this.kdc.getRelation(kingdom, target);
        if (existing != null && existing.getType() == RelationType.ALLY) {
            this.kdc.getMessages().send(sender, "cmdAllyAlready", target.getName());
            return;
        }
        Relation request = this.kdc.getRelationRequest(target, kingdom);
        if (request == null || request.getType() != RelationType.ALLY) {
            request = this.kdc.getRelationRequest(kingdom, target);
            if (request != null && request.getType() == RelationType.ALLY) {
                this.kdc.getMessages().send(sender, "cmdAllyRequestAlready", target.getName());
                return;
            }
            this.kdc.addRelationRequest(kingdom, target, RelationType.ALLY);
            this.kdc.getMessages().send(sender, "cmdAllyRequest", target.getName());
            for (PlatformPlayer member : this.kdc.getOnlinePlayers()) {
                if (this.kdc.getUser(member).getKingdom() != target || !member.hasPermission("kingdom.ally")) continue;
                this.kdc.getMessages().send((PlatformSender)member, "cmdAllyRequestTarget", kingdom.getName());
            }
            return;
        }
        this.kdc.setRelation(target, kingdom, RelationType.ALLY);
        for (PlatformPlayer member : this.kdc.getOnlinePlayers()) {
            Kingdom kd = member.getUser().getKingdom();
            if (kd == kingdom) {
                this.kdc.getMessages().send((PlatformSender)member, "cmdAlly", target.getName());
                continue;
            }
            if (kd != target) continue;
            this.kdc.getMessages().send((PlatformSender)member, "cmdAlly", kingdom.getName());
        }
    }
}

