/*
 * Decompiled with CFR 0.152.
 */
package com.gufli.kingdomcraft.common.commands.member;

import com.gufli.kingdomcraft.api.domain.Kingdom;
import com.gufli.kingdomcraft.api.domain.Rank;
import com.gufli.kingdomcraft.api.domain.User;
import com.gufli.kingdomcraft.api.entity.PlatformPlayer;
import com.gufli.kingdomcraft.api.entity.PlatformSender;
import com.gufli.kingdomcraft.common.KingdomCraftImpl;
import com.gufli.kingdomcraft.common.command.CommandBase;
import java.util.List;
import java.util.stream.Collectors;

public class SetRankCommand
extends CommandBase {
    public SetRankCommand(KingdomCraftImpl kdc) {
        super(kdc, "setrank", 2);
        this.setArgumentsHint("<player> <rank>");
        this.setExplanationMessage(() -> kdc.getMessages().getMessage("cmdSetRankExplanation"));
        this.setPermissions("kingdom.setrank", "kingdom.setrank.other");
    }

    @Override
    public List<String> autocomplete(PlatformPlayer player, String[] args) {
        if (args.length == 1) {
            if (player.hasPermission("kingdom.setrank.other")) {
                return this.kdc.getOnlinePlayers().stream().filter(p -> this.kdc.getUser((PlatformPlayer)p).getKingdom() != null).map(PlatformPlayer::getName).collect(Collectors.toList());
            }
            User user = this.kdc.getUser(player);
            if (player.hasPermission("kingdom.setrank") && user.getKingdom() != null) {
                return this.kdc.getOnlinePlayers().stream().filter(p -> this.kdc.getUser((PlatformPlayer)p).getKingdom() == user.getKingdom()).filter(p -> {
                    User u = this.kdc.getUser((PlatformPlayer)p);
                    return u.getRank() == null || u.getRank().getLevel() < user.getRank().getLevel();
                }).map(PlatformPlayer::getName).collect(Collectors.toList());
            }
            return null;
        }
        if (args.length == 2) {
            User user = this.kdc.getUser(player);
            if (user.getKingdom() == null) {
                return null;
            }
            User target = this.kdc.getOnlineUser(args[0]);
            if (target == null || target.getKingdom() == null) {
                return null;
            }
            if (!player.hasPermission("kingdom.setrank.other") && user.getKingdom() != target.getKingdom()) {
                return null;
            }
            return user.getKingdom().getRanks().stream().filter(rank -> rank.getMaxMembers() == 0 || rank.getMemberCount() < rank.getMaxMembers()).map(Rank::getName).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    public void execute(PlatformSender sender, String[] args) {
        this.kdc.getPlugin().getScheduler().executeAsync(() -> {
            try {
                User target = this.kdc.getUser(args[0]).get();
                if (target == null) {
                    this.kdc.getMessages().send(sender, "cmdErrorPlayerNotExist", args[0]);
                    return;
                }
                Kingdom kingdom = target.getKingdom();
                if (kingdom == null) {
                    this.kdc.getMessages().send(sender, "cmdErrorTargetNoKingdom", target.getName());
                    return;
                }
                Rank rank = kingdom.getRanks().stream().filter(r -> r.getName().equalsIgnoreCase(args[1])).findFirst().orElse(null);
                if (rank == null) {
                    this.kdc.getMessages().send(sender, "cmdSetRankNotExist", args[1]);
                    return;
                }
                if (!sender.hasPermission("kingdom.setrank.other")) {
                    User user = this.kdc.getUser((PlatformPlayer)sender);
                    if (user.getKingdom() != kingdom) {
                        this.kdc.getMessages().send(sender, "cmdErrorNoPermission", new String[0]);
                        return;
                    }
                    if (user.getRank() == null || user.getRank().getLevel() <= rank.getLevel()) {
                        this.kdc.getMessages().send(sender, "cmdSetRankLowLevelTarget", rank.getName());
                        return;
                    }
                    if (target.getRank() != null && user.getRank().getLevel() <= target.getRank().getLevel()) {
                        this.kdc.getMessages().send(sender, "cmdSetRankLowLevelCurrent", target.getName());
                        return;
                    }
                }
                if (target.getRank() == rank) {
                    this.kdc.getMessages().send(sender, "cmdSetRankAlready", target.getName(), rank.getName());
                    return;
                }
                if (!sender.hasPermission("kingdom.setrank.other") && rank.getMaxMembers() > 0 && rank.getMaxMembers() <= rank.getMemberCount()) {
                    this.kdc.getMessages().send(sender, "cmdSetRankFull", rank.getName());
                    return;
                }
                target.setRank(rank);
                this.kdc.saveAsync(target);
                PlatformPlayer targetPlayer = this.kdc.getPlayer(target);
                if (targetPlayer != null) {
                    this.kdc.getMessages().send((PlatformSender)targetPlayer, "cmdSetRankTarget", rank.getName());
                }
                this.kdc.getMessages().send(sender, "cmdSetRankSender", target.getName(), rank.getName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }
}

